/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.util.List;
import org.apache.jetspeed.security.Group;
import org.apache.jetspeed.security.GroupManager;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.security.impl.BaseJetspeedPrincipalManager;
import org.apache.jetspeed.security.impl.GroupImpl;
import org.apache.jetspeed.security.impl.TransientGroup;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupManagerImpl
extends BaseJetspeedPrincipalManager
implements GroupManager {
    private static final Logger log = LoggerFactory.getLogger(GroupManagerImpl.class);
    private JetspeedPrincipalType userType;
    private JetspeedPrincipalType roleType;
    private UserManager userManager;

    public GroupManagerImpl(JetspeedPrincipalType principalType, JetspeedPrincipalType userType, JetspeedPrincipalType roleType, JetspeedPrincipalAccessManager jpam, JetspeedPrincipalStorageManager jpsm) {
        super(principalType, jpam, jpsm);
        this.userType = userType;
        this.roleType = roleType;
    }

    public void checkInitialized() {
        if (this.userManager == null) {
            this.userManager = (UserManager)this.getPrincipalManagerProvider().getManager(this.userType);
        }
    }

    public Group newGroup(String name, boolean mapped) {
        GroupImpl group = new GroupImpl(name);
        group.setMapped(mapped);
        return group;
    }

    public Group newTransientGroup(String name) {
        TransientGroup group = new TransientGroup(name);
        return group;
    }

    public Group addGroup(String groupName) throws SecurityException {
        return this.addGroup(groupName, true);
    }

    public Group addGroup(String groupName, boolean mapped) throws SecurityException {
        Group group = this.newGroup(groupName, mapped);
        super.addPrincipal((JetspeedPrincipal)group, null);
        if (log.isDebugEnabled()) {
            log.debug("Added group: " + groupName);
        }
        return group;
    }

    public void removeGroup(String groupName) throws SecurityException {
        super.removePrincipal(groupName);
    }

    public boolean groupExists(String groupName) {
        return super.principalExists(groupName);
    }

    public Group getGroup(String groupName) throws SecurityException {
        Group group = (Group)super.getPrincipal(groupName);
        if (null == group) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("group", (Object)groupName));
        }
        return group;
    }

    public List<Group> getGroupsForUser(String username) throws SecurityException {
        return super.getAssociatedFrom(username, this.userType, "isMemberOf");
    }

    public List<Group> getGroupsInRole(String roleName) throws SecurityException {
        return super.getAssociatedTo(roleName, this.roleType, "isMemberOf");
    }

    public void addUserToGroup(String username, String groupName) throws SecurityException {
        this.checkInitialized();
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)username));
        }
        Group group = this.getGroup(groupName);
        if (group == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("group", (Object)groupName));
        }
        super.addAssociation((JetspeedPrincipal)user, (JetspeedPrincipal)group, "isMemberOf");
    }

    public void removeUserFromGroup(String username, String groupName) throws SecurityException {
        this.checkInitialized();
        User user = this.userManager.getUser(username);
        if (user == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("user", (Object)username));
        }
        Group group = this.getGroup(groupName);
        if (group == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped("group", (Object)groupName));
        }
        super.removeAssociation((JetspeedPrincipal)user, (JetspeedPrincipal)group, "isMemberOf");
    }

    public boolean isUserInGroup(String username, String groupName) throws SecurityException {
        return this.getAssociatedNamesFrom(username, this.userType, "isMemberOf").contains(groupName);
    }

    public List<Group> getGroups(String nameFilter) throws SecurityException {
        return super.getPrincipals(nameFilter);
    }

    public List<String> getGroupNames(String nameFilter) throws SecurityException {
        return this.getPrincipalNames(nameFilter);
    }

    public void updateGroup(Group group) throws SecurityException {
        super.updatePrincipal((JetspeedPrincipal)group);
    }

    public void addGroupToGroup(Group from, Group to, String associationName) throws SecurityException {
        this.addAssociation((JetspeedPrincipal)from, (JetspeedPrincipal)to, associationName);
    }

    public void removeGroupFromGroup(Group from, Group to, String associationName) throws SecurityException {
        this.removeAssociation((JetspeedPrincipal)from, (JetspeedPrincipal)to, associationName);
    }

    public List<Group> getGroupsAssociatedFrom(Group from, String associationName) {
        return this.getAssociatedFrom(from.getName(), from.getType(), associationName);
    }

    public List<Group> getGroupsAssociatedTo(Group to, String associationName) {
        return this.getAssociatedFrom(to.getName(), to.getType(), associationName);
    }

    public JetspeedPrincipal newPrincipal(String name, boolean mapped) {
        return this.newGroup(name, mapped);
    }

    public JetspeedPrincipal newTransientPrincipal(String name) {
        return this.newTransientGroup(name);
    }
}

