/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jetspeed.Jetspeed;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationReference;
import org.apache.jetspeed.security.JetspeedPrincipalAssociationType;
import org.apache.jetspeed.security.JetspeedPrincipalManager;
import org.apache.jetspeed.security.JetspeedPrincipalManagerProvider;
import org.apache.jetspeed.security.JetspeedPrincipalType;
import org.apache.jetspeed.security.PrincipalManagerEventListener;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAccessManager;
import org.apache.jetspeed.security.spi.JetspeedPrincipalAssociationHandler;
import org.apache.jetspeed.security.spi.JetspeedPrincipalManagerSPI;
import org.apache.jetspeed.security.spi.JetspeedPrincipalStorageManager;
import org.apache.jetspeed.security.spi.impl.SynchronizationStateAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJetspeedPrincipalManager
implements JetspeedPrincipalManagerSPI {
    private JetspeedPrincipalType principalType;
    private List<JetspeedPrincipalAssociationType> associationTypes = new ArrayList<JetspeedPrincipalAssociationType>();
    private Map<AssociationHandlerKey, JetspeedPrincipalAssociationHandler> assHandlers = new HashMap<AssociationHandlerKey, JetspeedPrincipalAssociationHandler>();
    private Map<AssociationHandlerKey, JetspeedPrincipalAssociationType> reqAssociations = new HashMap<AssociationHandlerKey, JetspeedPrincipalAssociationType>();
    private JetspeedPrincipalAccessManager jpam;
    private JetspeedPrincipalStorageManager jpsm;
    protected static JetspeedPrincipalManagerProvider jpmp;
    private List<PrincipalManagerEventListener> listeners = new LinkedList<PrincipalManagerEventListener>();

    public BaseJetspeedPrincipalManager(JetspeedPrincipalType principalType, JetspeedPrincipalAccessManager jpam, JetspeedPrincipalStorageManager jpsm) {
        this.principalType = principalType;
        this.jpam = jpam;
        this.jpsm = jpsm;
    }

    protected final void validatePrincipal(JetspeedPrincipal principal) {
        if (!principal.getType().getName().equals(this.principalType.getName())) {
            throw new IllegalArgumentException("Principal is not of type " + this.principalType.getName());
        }
        if (principal.isTransient()) {
            throw new IllegalArgumentException("Principal is transient");
        }
    }

    public static void setJetspeedPrincipalManagerProvider(JetspeedPrincipalManagerProvider Jpmp) {
        jpmp = Jpmp;
    }

    public JetspeedPrincipalManagerProvider getPrincipalManagerProvider() {
        if (jpmp == null) {
            jpmp = (JetspeedPrincipalManagerProvider)Jetspeed.getComponentManager().getComponent((Object)"org.apache.jetspeed.security.spi.JetspeedPrincipalManagerProvider");
        }
        return jpmp;
    }

    public JetspeedPrincipalAccessManager getPrincipalAccessManager() {
        return this.jpam;
    }

    public final JetspeedPrincipalType getPrincipalType() {
        return this.principalType;
    }

    public final JetspeedPrincipalManager getPrincipalManager() {
        return this;
    }

    public List<JetspeedPrincipalAssociationType> getAssociationTypes() {
        return Collections.unmodifiableList(this.associationTypes);
    }

    public boolean principalExists(String name) {
        return this.jpam.principalExists(name, this.principalType);
    }

    public JetspeedPrincipal getPrincipal(String name) {
        return this.jpam.getPrincipal(name, this.principalType);
    }

    public List<String> getPrincipalNames(String nameFilter) {
        return this.jpam.getPrincipalNames(nameFilter, this.principalType);
    }

    public List<? extends JetspeedPrincipal> getPrincipals(String nameFilter) {
        return this.jpam.getPrincipals(nameFilter, this.principalType);
    }

    public List<? extends JetspeedPrincipal> getPrincipalsByAttribute(String attributeName, String attributeValue) {
        return this.jpam.getPrincipalsByAttribute(attributeName, attributeValue, this.principalType);
    }

    public void removePrincipal(String name) throws SecurityException {
        JetspeedPrincipal principal = this.jpam.getPrincipal(name, this.principalType);
        if (principal == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(this.principalType.getName(), (Object)name));
        }
        this.removePrincipal(principal);
    }

    public final List<? extends JetspeedPrincipal> getAssociatedFrom(String principalFromName, JetspeedPrincipalType from, String associationName) {
        if (!this.assHandlers.containsKey(new AssociationHandlerKey(associationName, from.getName(), this.principalType.getName()))) {
            return Collections.emptyList();
        }
        return this.jpam.getAssociatedFrom(principalFromName, from, this.principalType, associationName);
    }

    public final List<String> getAssociatedNamesFrom(String principalFromName, JetspeedPrincipalType from, String associationName) {
        if (!this.assHandlers.containsKey(new AssociationHandlerKey(associationName, from.getName(), this.principalType.getName()))) {
            return Collections.emptyList();
        }
        return this.jpam.getAssociatedNamesFrom(principalFromName, from, this.principalType, associationName);
    }

    public final List<String> getAssociatedNamesTo(String principalToName, JetspeedPrincipalType to, String associationName) {
        if (!this.assHandlers.containsKey(new AssociationHandlerKey(associationName, this.principalType.getName(), to.getName()))) {
            return Collections.emptyList();
        }
        return this.jpam.getAssociatedNamesTo(principalToName, this.principalType, to, associationName);
    }

    public final List<? extends JetspeedPrincipal> getAssociatedTo(String principalToName, JetspeedPrincipalType to, String associationName) {
        if (!this.assHandlers.containsKey(new AssociationHandlerKey(associationName, this.principalType.getName(), to.getName()))) {
            return Collections.emptyList();
        }
        return this.jpam.getAssociatedTo(principalToName, this.principalType, to, associationName);
    }

    @Override
    public void addAssociationHandler(JetspeedPrincipalAssociationHandler jpah) {
        if (jpah.getAssociationType().getFromPrincipalType().getName().equals(this.principalType.getName()) || jpah.getAssociationType().getToPrincipalType().getName().equals(this.principalType.getName())) {
            AssociationHandlerKey key = new AssociationHandlerKey(jpah);
            if (this.assHandlers.containsKey(key)) {
                throw new IllegalStateException("An AssociationHandler for " + jpah.getAssociationType().getAssociationName() + " already defined");
            }
            this.assHandlers.put(key, jpah);
            this.associationTypes.add(jpah.getAssociationType());
            if (jpah.getAssociationType().isRequired() && jpah.getAssociationType().getFromPrincipalType().getName().equals(this.principalType.getName())) {
                this.reqAssociations.put(key, jpah.getAssociationType());
            }
        } else {
            throw new IllegalArgumentException("AssociationHandler is not handling a " + this.principalType.getName() + " JetspeedPrincipal");
        }
    }

    public void addPrincipal(JetspeedPrincipal principal, Set<JetspeedPrincipalAssociationReference> associations) throws SecurityException {
        this.validatePrincipal(principal);
        if (!this.isSynchronizing()) {
            HashMap<AssociationHandlerKey, JetspeedPrincipalAssociationType> reqAss = new HashMap<AssociationHandlerKey, JetspeedPrincipalAssociationType>(this.reqAssociations);
            if (associations != null) {
                AssociationHandlerKey key = null;
                for (JetspeedPrincipalAssociationReference ref : associations) {
                    if (ref.ref.isTransient()) {
                        throw new IllegalArgumentException("Associated principal of type " + ref.ref.getType().getName() + " is transient");
                    }
                    key = ref.type == JetspeedPrincipalAssociationReference.Type.FROM ? new AssociationHandlerKey(ref.associationName, ref.ref.getType().getName(), this.principalType.getName()) : new AssociationHandlerKey(ref.associationName, this.principalType.getName(), ref.ref.getType().getName());
                    if (!this.assHandlers.containsKey(key)) {
                        if (ref.type == JetspeedPrincipalAssociationReference.Type.FROM) {
                            throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_UNSUPPORTED.createScoped(ref.ref.getType().getName(), (Object)ref.associationName, (Object)principal.getType().getName()));
                        }
                        throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_UNSUPPORTED.createScoped(principal.getType().getName(), (Object)ref.associationName, (Object)ref.ref.getType().getName()));
                    }
                    reqAss.remove(key);
                }
            }
            if (!reqAss.isEmpty()) {
                JetspeedPrincipalAssociationType assType = (JetspeedPrincipalAssociationType)reqAss.values().iterator().next();
                throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_REQUIRED.createScoped(assType.getFromPrincipalType().getName(), (Object)assType.getAssociationName(), (Object)assType.getToPrincipalType().getName()));
            }
        }
        this.jpsm.addPrincipal(principal, associations);
        if (associations != null) {
            for (JetspeedPrincipalAssociationReference ref : associations) {
                if (ref.type == JetspeedPrincipalAssociationReference.Type.FROM) {
                    this.addAssociation(ref.ref, principal, ref.associationName);
                    continue;
                }
                this.addAssociation(principal, ref.ref, ref.associationName);
            }
        }
        this.notifyNewPrincipal(principal);
    }

    public void removePrincipal(JetspeedPrincipal principal) throws SecurityException {
        this.validatePrincipal(principal);
        for (JetspeedPrincipalAssociationHandler jpah : this.assHandlers.values()) {
            if (jpah.getAssociationType().getFromPrincipalType().getName().equals(this.principalType.getName())) {
                jpah.beforeRemoveFrom(principal);
            }
            if (!jpah.getAssociationType().getToPrincipalType().getName().equals(this.principalType.getName())) continue;
            jpah.beforeRemoveTo(principal);
        }
        this.jpsm.removePrincipal(principal);
        this.notifyRemovedPrincipal(principal);
    }

    public void updatePrincipal(JetspeedPrincipal principal) throws SecurityException {
        this.validatePrincipal(principal);
        if (principal.isReadOnly() && !this.isSynchronizing()) {
            throw new SecurityException(SecurityException.PRINCIPAL_IS_READ_ONLY.createScoped(principal.getType().getName(), (Object)principal.getName()));
        }
        this.jpsm.updatePrincipal(principal);
        this.notifyUpdatedPrincipal(principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PrincipalManagerEventListener listener) {
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PrincipalManagerEventListener listener) {
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void addAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        AssociationHandlerKey key = new AssociationHandlerKey(associationName, from.getType().getName(), to.getType().getName());
        JetspeedPrincipalAssociationHandler jpah = this.assHandlers.get(key);
        if (jpah == null) {
            throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_UNSUPPORTED.createScoped(from.getType().getName(), (Object)associationName, (Object)to.getType().getName()));
        }
        if (from.isTransient() || from.getId() == null) {
            JetspeedPrincipal pfrom = jpah.getManagerFrom().getPrincipal(from.getName());
            if (pfrom == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(from.getType().getName(), (Object)from.getName()));
            }
            from = pfrom;
        }
        if (to.isTransient() || to.getId() == null) {
            JetspeedPrincipal pto = jpah.getManagerTo().getPrincipal(to.getName());
            if (pto == null) {
                throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(to.getType().getName(), (Object)to.getName()));
            }
            to = pto;
        }
        jpah.add(from, to);
        this.notifyAddedAssociation(from, to, associationName);
    }

    public void transferAssociationFrom(JetspeedPrincipal from, JetspeedPrincipal to, JetspeedPrincipal target, String associationName) throws SecurityException {
    }

    public void transferAssociationTo(JetspeedPrincipal from, JetspeedPrincipal to, JetspeedPrincipal target, String associationName) throws SecurityException {
    }

    public void removeAssociation(JetspeedPrincipal from, JetspeedPrincipal to, String associationName) throws SecurityException {
        AssociationHandlerKey key = new AssociationHandlerKey(associationName, from.getType().getName(), to.getType().getName());
        JetspeedPrincipalAssociationHandler jpah = this.assHandlers.get(key);
        if (jpah != null) {
            if (jpah.getAssociationType().isRequired() && !this.isSynchronizing()) {
                JetspeedPrincipalAssociationType assType = jpah.getAssociationType();
                throw new SecurityException(SecurityException.PRINCIPAL_ASSOCIATION_REQUIRED.createScoped(assType.getFromPrincipalType().getName(), (Object)assType.getAssociationName(), (Object)assType.getToPrincipalType().getName()));
            }
            if (from.isTransient() || from.getId() == null) {
                JetspeedPrincipal pfrom = jpah.getManagerFrom().getPrincipal(from.getName());
                if (pfrom == null) {
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(from.getType().getName(), (Object)from.getName()));
                }
                from = pfrom;
            }
            if (to.isTransient() || to.getId() == null) {
                JetspeedPrincipal pto = jpah.getManagerTo().getPrincipal(to.getName());
                if (pto == null) {
                    throw new SecurityException(SecurityException.PRINCIPAL_DOES_NOT_EXIST.createScoped(to.getType().getName(), (Object)to.getName()));
                }
                to = pto;
            }
            jpah.remove(from, to);
            this.notifyRemovedAssociation(from, to, associationName);
        }
    }

    protected boolean isSynchronizing() {
        return SynchronizationStateAccess.isSynchronizing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewPrincipal(JetspeedPrincipal principal) throws SecurityException {
        ArrayList<PrincipalManagerEventListener> listenersList = null;
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PrincipalManagerEventListener>(this.listeners);
        }
        for (PrincipalManagerEventListener listener : listenersList) {
            listener.newPrincipal(principal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdatedPrincipal(JetspeedPrincipal principal) throws SecurityException {
        ArrayList<PrincipalManagerEventListener> listenersList = null;
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PrincipalManagerEventListener>(this.listeners);
        }
        for (PrincipalManagerEventListener listener : listenersList) {
            listener.updatePrincipal(principal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemovedPrincipal(JetspeedPrincipal principal) {
        ArrayList<PrincipalManagerEventListener> listenersList = null;
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PrincipalManagerEventListener>(this.listeners);
        }
        for (PrincipalManagerEventListener listener : listenersList) {
            listener.removePrincipal(principal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAddedAssociation(JetspeedPrincipal fromPrincipal, JetspeedPrincipal toPrincipal, String associationName) {
        ArrayList<PrincipalManagerEventListener> listenersList = null;
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PrincipalManagerEventListener>(this.listeners);
        }
        for (PrincipalManagerEventListener listener : listenersList) {
            listener.associationAdded(fromPrincipal, toPrincipal, associationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemovedAssociation(JetspeedPrincipal fromPrincipal, JetspeedPrincipal toPrincipal, String associationName) {
        ArrayList<PrincipalManagerEventListener> listenersList = null;
        List<PrincipalManagerEventListener> list = this.listeners;
        synchronized (list) {
            listenersList = new ArrayList<PrincipalManagerEventListener>(this.listeners);
        }
        for (PrincipalManagerEventListener listener : listenersList) {
            listener.associationRemoved(fromPrincipal, toPrincipal, associationName);
        }
    }

    private static class AssociationHandlerKey
    implements Serializable {
        String name;
        String fromPrincipalType;
        String toPrincipalType;

        public AssociationHandlerKey(JetspeedPrincipalAssociationHandler jpah) {
            this(jpah.getAssociationType().getAssociationName(), jpah.getAssociationType().getFromPrincipalType().getName(), jpah.getAssociationType().getToPrincipalType().getName());
        }

        public AssociationHandlerKey(String name, String fromPrincipalType, String toPrincipalType) {
            this.name = name;
            this.fromPrincipalType = fromPrincipalType;
            this.toPrincipalType = toPrincipalType;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof AssociationHandlerKey) {
                AssociationHandlerKey other = (AssociationHandlerKey)o;
                return other.name.equals(this.name) && other.fromPrincipalType.equals(this.fromPrincipalType) && other.toPrincipalType.equals(this.toPrincipalType);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.fromPrincipalType.hashCode() + this.toPrincipalType.hashCode();
        }
    }
}

