/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapMemberShipDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapMembershipDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapUserPrincipalDao;

public class LdapUserPrincipalDaoImpl
extends LdapPrincipalDaoImpl
implements LdapUserPrincipalDao {
    private LdapMembershipDao membership;

    public LdapUserPrincipalDaoImpl() throws SecurityException {
        this.membership = new LdapMemberShipDaoImpl();
    }

    public LdapUserPrincipalDaoImpl(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
        this.membership = new LdapMemberShipDaoImpl(ldapConfig);
    }

    public void addGroup(String userPrincipalUid, String groupPrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getUserGroupMembershipAttribute())) {
            this.modifyUserGroupByUser(userPrincipalUid, groupPrincipalUid, 1);
        } else {
            this.modifyUserGroupByGroup(userPrincipalUid, groupPrincipalUid, 1);
        }
    }

    private void modifyUserGroupByGroup(String userPrincipalUid, String groupPrincipalUid, int operationType) throws SecurityException {
        this.validateUid(userPrincipalUid);
        this.validateUid(groupPrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getGroupMembershipAttribute(), this.getUserDN(userPrincipalUid));
            this.ctx.modifyAttributes(this.getGroupDN(groupPrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private void modifyUserGroupByUser(String userPrincipalUid, String groupPrincipalUid, int operationType) throws SecurityException {
        this.validateUid(userPrincipalUid);
        this.validateUid(groupPrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getUserGroupMembershipAttribute(), this.getGroupDN(groupPrincipalUid));
            this.ctx.modifyAttributes(this.getUserDN(userPrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public void removeGroup(String userPrincipalUid, String groupPrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getUserGroupMembershipAttribute())) {
            this.modifyUserGroupByUser(userPrincipalUid, groupPrincipalUid, 3);
        } else {
            this.modifyUserGroupByGroup(userPrincipalUid, groupPrincipalUid, 3);
        }
    }

    public void addRole(String userPrincipalUid, String rolePrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getUserRoleMembershipAttribute())) {
            this.modifyUserRoleByUser(userPrincipalUid, rolePrincipalUid, 1);
        } else {
            this.modifyUserRoleByRole(userPrincipalUid, rolePrincipalUid, 1);
        }
    }

    private void modifyUserRoleByUser(String userPrincipalUid, String rolePrincipalUid, int operationType) throws SecurityException {
        this.validateUid(userPrincipalUid);
        this.validateUid(rolePrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getUserRoleMembershipAttribute(), this.getRoleDN(rolePrincipalUid));
            this.ctx.modifyAttributes(this.getUserDN(userPrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private void modifyUserRoleByRole(String userPrincipalUid, String rolePrincipalUid, int operationType) throws SecurityException {
        this.validateUid(userPrincipalUid);
        this.validateUid(rolePrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getRoleMembershipAttribute(), this.getUserDN(userPrincipalUid));
            this.ctx.modifyAttributes(this.getRoleDN(rolePrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public void removeRole(String userPrincipalUid, String rolePrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getUserRoleMembershipAttribute())) {
            this.modifyUserRoleByUser(userPrincipalUid, rolePrincipalUid, 3);
        } else {
            this.modifyUserRoleByRole(userPrincipalUid, rolePrincipalUid, 3);
        }
    }

    protected Attributes defineLdapAttributes(String principalUid) {
        int i;
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        for (i = 0; i < this.getObjectClasses().length; ++i) {
            classes.add(this.getObjectClasses()[i]);
        }
        attrs.put(classes);
        for (i = 0; i < this.getAttributes().length; ++i) {
            attrs.put(this.parseAttr(this.getAttributes()[i], principalUid)[0], this.parseAttr(this.getAttributes()[i], principalUid)[1]);
        }
        attrs.put(this.getEntryPrefix(), principalUid);
        return attrs;
    }

    protected Principal makePrincipal(String principalUid) {
        return new UserPrincipalImpl(principalUid);
    }

    public void addRoleToGroup(String groupPrincipalUid, String rolePrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getRoleGroupMembershipForRoleAttribute())) {
            this.modifyRoleGroupByRole(groupPrincipalUid, rolePrincipalUid, 1);
        } else {
            this.modifyRoleGroupByGroup(groupPrincipalUid, rolePrincipalUid, 1);
        }
    }

    private void modifyRoleGroupByRole(String groupPrincipalUid, String rolePrincipalUid, int operationType) throws SecurityException {
        this.validateUid(groupPrincipalUid);
        this.validateUid(rolePrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getRoleGroupMembershipForRoleAttribute(), this.getGroupDN(groupPrincipalUid));
            this.ctx.modifyAttributes(this.getRoleDN(rolePrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private void modifyRoleGroupByGroup(String groupPrincipalUid, String rolePrincipalUid, int operationType) throws SecurityException {
        this.validateUid(groupPrincipalUid);
        this.validateUid(rolePrincipalUid);
        try {
            BasicAttributes attrs = new BasicAttributes(false);
            attrs.put(this.getGroupMembershipForRoleAttribute(), this.getRoleDN(rolePrincipalUid));
            this.ctx.modifyAttributes(this.getGroupDN(groupPrincipalUid, false), operationType, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public void removeRoleFromGroup(String groupPrincipalUid, String rolePrincipalUid) throws SecurityException {
        if (!StringUtils.isEmpty((String)this.getRoleGroupMembershipForRoleAttribute())) {
            this.modifyRoleGroupByRole(groupPrincipalUid, rolePrincipalUid, 3);
        } else {
            this.modifyRoleGroupByGroup(groupPrincipalUid, rolePrincipalUid, 3);
        }
    }

    public String[] getGroupUidsForUser(String userPrincipalUid) throws SecurityException {
        this.validateUid(userPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            if (!StringUtils.isEmpty((String)this.getUserGroupMembershipAttribute())) {
                return this.membership.searchGroupMemberShipByUser(userPrincipalUid, cons);
            }
            return this.membership.searchGroupMemberShipByGroup(userPrincipalUid, cons);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public String[] getRolesForGroup(String groupPrincipalUid) throws SecurityException {
        this.validateUid(groupPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            if (!StringUtils.isEmpty((String)this.getRoleGroupMembershipForRoleAttribute())) {
                return this.membership.searchRolesFromGroupByRole(groupPrincipalUid, cons);
            }
            return this.membership.searchRolesFromGroupByGroup(groupPrincipalUid, cons);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public String[] getRoleUidsForUser(String userPrincipalUid) throws SecurityException {
        this.validateUid(userPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            if (!StringUtils.isEmpty((String)this.getUserRoleMembershipAttribute())) {
                return this.membership.searchRoleMemberShipByUser(userPrincipalUid, cons);
            }
            return this.membership.searchRoleMemberShipByRole(userPrincipalUid, cons);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public String[] getUserUidsForGroup(String groupPrincipalUid) throws SecurityException {
        this.validateUid(groupPrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            if (!StringUtils.isEmpty((String)this.getUserGroupMembershipAttribute())) {
                return this.membership.searchUsersFromGroupByUser(groupPrincipalUid, cons);
            }
            return this.membership.searchUsersFromGroupByGroup(groupPrincipalUid, cons);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public String[] getUserUidsForRole(String rolePrincipalUid) throws SecurityException {
        this.validateUid(rolePrincipalUid);
        SearchControls cons = this.setSearchControls();
        try {
            if (!StringUtils.isEmpty((String)this.getUserRoleMembershipAttribute())) {
                return this.membership.searchUsersFromRoleByUser(rolePrincipalUid, cons);
            }
            return this.membership.searchUsersFromRoleByRole(rolePrincipalUid, cons);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    protected String[] getObjectClasses() {
        return this.getUserObjectClasses();
    }

    protected String[] getAttributes() {
        return this.getUserAttributes();
    }

    protected String getUidAttributeForPrincipal() {
        return this.getUserUidAttribute();
    }

    protected String getEntryPrefix() {
        return this.getUserIdAttribute();
    }

    protected String getSearchSuffix() {
        return this.getUserFilter();
    }

    protected String getDnSuffix() {
        return this.getUserFilterBase();
    }
}

