/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.GroupPrincipalImpl;
import org.apache.jetspeed.security.impl.RolePrincipalImpl;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.AbstractLdapDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDao;

public abstract class LdapPrincipalDaoImpl
extends AbstractLdapDao
implements LdapPrincipalDao {
    private static final Log logger = LogFactory.getLog((Class)LdapPrincipalDaoImpl.class);

    public LdapPrincipalDaoImpl() throws SecurityException {
    }

    public LdapPrincipalDaoImpl(LdapBindingConfig ldapConfig) throws SecurityException {
        super(ldapConfig);
    }

    protected abstract Principal makePrincipal(String var1);

    protected abstract Attributes defineLdapAttributes(String var1);

    public void create(String principalUid) throws SecurityException {
        Attributes attrs = this.defineLdapAttributes(principalUid);
        logger.debug((Object)("creating principal with " + attrs));
        try {
            String userDn = this.getEntryPrefix() + "=" + principalUid;
            if (!StringUtils.isEmpty((String)this.getDnSuffix())) {
                userDn = userDn + "," + this.getDnSuffix();
            }
            logger.debug((Object)("userDn = " + userDn));
            this.ctx.createSubcontext(userDn, attrs);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating user dn: " + userDn));
            }
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    protected abstract String getDnSuffix();

    protected abstract String getUidAttributeForPrincipal();

    public void delete(String principalUid) throws SecurityException {
        String dn = this.lookupByUid(principalUid);
        if (dn == null) {
            return;
        }
        try {
            String rdn = this.getSubcontextName(dn);
            this.ctx.destroySubcontext(rdn);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    public String convertUidToLdapAcceptableName(String fullPath) {
        if (logger.isErrorEnabled()) {
            logger.debug((Object)("Principal fullPath:" + fullPath));
        }
        String ldapAcceptableName = fullPath;
        if (null == fullPath) {
            return ldapAcceptableName;
        }
        if (fullPath.indexOf("/user/") >= 0) {
            ldapAcceptableName = this.convertUidWithoutSlashes(UserPrincipalImpl.getPrincipalNameFromFullPath(fullPath));
        } else if (fullPath.indexOf("/group/") >= 0) {
            ldapAcceptableName = this.convertUidWithoutSlashes(GroupPrincipalImpl.getPrincipalNameFromFullPath(fullPath));
        } else if (fullPath.indexOf("/role/") >= 0) {
            ldapAcceptableName = this.convertUidWithoutSlashes(RolePrincipalImpl.getPrincipalNameFromFullPath(fullPath));
        }
        if (logger.isErrorEnabled()) {
            logger.debug((Object)("Ldap acceptable name:" + ldapAcceptableName));
        }
        return ldapAcceptableName;
    }

    private String convertUidWithoutSlashes(String uid) {
        String uidWithSlashed = uid.replaceAll("/", "&");
        return uidWithSlashed;
    }

    public Principal[] find(String principalUid, String principalType) throws SecurityException {
        try {
            SearchControls cons = this.setSearchControls();
            NamingEnumeration searchResults = this.searchByWildcardedUid(this.convertUidToLdapAcceptableName(principalUid), cons);
            ArrayList principals = new ArrayList();
            this.enumerateOverSearchResults(searchResults, principals);
            return this.convertPrincipalListToArray(principals);
        }
        catch (NamingException e) {
            throw new SecurityException((Throwable)e);
        }
    }

    private Principal[] convertPrincipalListToArray(Collection principals) {
        return principals.toArray(new Principal[principals.size()]);
    }

    private void enumerateOverSearchResults(NamingEnumeration searchResults, Collection principals) throws NamingException {
        while (searchResults.hasMore()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            this.buildPrincipal(principals, searchResult);
        }
    }

    private void buildPrincipal(Collection principals, SearchResult searchResult) throws NamingException {
        if (searchResult.getObject() instanceof DirContext) {
            Attributes atts = searchResult.getAttributes();
            String uid = (String)this.getAttribute(this.getUidAttributeForPrincipal(), atts).getAll().next();
            Principal principal = this.makePrincipal(uid);
            principals.add(principal);
        }
    }

    protected Attribute getAttribute(String attributeName, Attributes userAttributes) throws NamingException {
        NamingEnumeration<? extends Attribute> ae = userAttributes.getAll();
        while (ae.hasMore()) {
            Attribute attr = ae.next();
            if (!attr.getID().equalsIgnoreCase(attributeName)) continue;
            return attr;
        }
        return null;
    }

    protected String getSearchDomain() {
        return this.getUserFilterBase();
    }

    protected String[] parseAttr(String attr, String replace) {
        int index = (attr = StringUtils.replace((String)attr, (String)"{u}", (String)replace)).indexOf(61);
        if (index != -1) {
            return new String[]{attr.substring(0, index), index < attr.length() - 1 ? attr.substring(index + 1) : null};
        }
        return new String[]{attr, null};
    }

    protected String getGroupDN(String groupPrincipalUid) {
        return this.getGroupDN(groupPrincipalUid, true);
    }

    protected String getGroupDN(String groupPrincipalUid, boolean includeBaseDN) {
        String groupDN = this.getGroupIdAttribute() + "=" + groupPrincipalUid;
        if (!StringUtils.isEmpty((String)this.getGroupFilterBase())) {
            groupDN = groupDN + "," + this.getGroupFilterBase();
        }
        if (includeBaseDN && !StringUtils.isEmpty((String)this.getRootContext())) {
            groupDN = groupDN + "," + this.getRootContext();
        }
        return groupDN;
    }

    protected String getRoleDN(String rolePrincipalUid) {
        return this.getRoleDN(rolePrincipalUid, true);
    }

    protected String getRoleDN(String rolePrincipalUid, boolean includeBaseDN) {
        String roleDN = this.getRoleIdAttribute() + "=" + rolePrincipalUid;
        if (!StringUtils.isEmpty((String)this.getRoleFilterBase())) {
            roleDN = roleDN + "," + this.getRoleFilterBase();
        }
        if (includeBaseDN && !StringUtils.isEmpty((String)this.getRootContext())) {
            roleDN = roleDN + "," + this.getRootContext();
        }
        return roleDN;
    }

    protected String getUserDN(String userPrincipalUid) {
        return this.getUserDN(userPrincipalUid, true);
    }

    protected String getUserDN(String userPrincipalUid, boolean includeBaseDN) {
        String userDN = this.getUserIdAttribute() + "=" + userPrincipalUid;
        if (!StringUtils.isEmpty((String)this.getUserFilterBase())) {
            userDN = userDN + "," + this.getUserFilterBase();
        }
        if (includeBaseDN && !StringUtils.isEmpty((String)this.getRootContext())) {
            userDN = userDN + "," + this.getRootContext();
        }
        return userDN;
    }
}

