/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl.ldap;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.impl.UserPrincipalImpl;
import org.apache.jetspeed.security.spi.impl.ldap.LdapBindingConfig;
import org.apache.jetspeed.security.spi.impl.ldap.LdapMembershipDao;
import org.apache.jetspeed.security.spi.impl.ldap.LdapPrincipalDaoImpl;

public class LdapMemberShipDaoImpl
extends LdapPrincipalDaoImpl
implements LdapMembershipDao {
    private static final Log logger = LogFactory.getLog((Class)LdapMemberShipDaoImpl.class);

    public LdapMemberShipDaoImpl() throws SecurityException {
    }

    public LdapMemberShipDaoImpl(LdapBindingConfig config) throws SecurityException {
        super(config);
    }

    public String[] searchGroupMemberShipByGroup(String userPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getGroupMembershipAttribute() + "=" + this.getUserDN(userPrincipalUid) + ")" + this.getGroupFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        cons.setSearchScope(this.getSearchScope());
        String groupFilterBase = this.getGroupFilterBase();
        NamingEnumeration<SearchResult> searchResults = this.ctx.search(groupFilterBase, query, cons);
        ArrayList groupPrincipalUids = new ArrayList();
        while (searchResults.hasMore()) {
            SearchResult result = searchResults.next();
            Attributes answer = result.getAttributes();
            groupPrincipalUids.addAll(this.getAttributes(this.getAttribute(this.getGroupIdAttribute(), answer)));
        }
        return groupPrincipalUids.toArray(new String[groupPrincipalUids.size()]);
    }

    public String[] searchGroupMemberShipByUser(String userPrincipalUid, SearchControls cons) throws NamingException {
        NamingEnumeration searchResults = this.searchByWildcardedUid(userPrincipalUid, cons);
        if (!searchResults.hasMore()) {
            throw new NamingException("Could not find any user with uid[" + userPrincipalUid + "]");
        }
        Attributes userAttributes = this.getFirstUser(searchResults);
        ArrayList<String> groupUids = new ArrayList<String>();
        Attribute attr = this.getAttribute(this.getUserGroupMembershipAttribute(), userAttributes);
        List attrs = this.getAttributes(attr);
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String cn;
            String cnfull = (String)it.next();
            if (cnfull.toLowerCase().indexOf(this.getGroupFilterBase().toLowerCase()) == -1 || (cn = this.extractLdapAttr(cnfull, this.getRoleUidAttribute())) == null) continue;
            groupUids.add(cn);
        }
        return groupUids.toArray(new String[groupUids.size()]);
    }

    public String[] searchRoleMemberShipByRole(String userPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getRoleMembershipAttribute() + "=" + this.getUserDN(userPrincipalUid) + ")" + this.getRoleFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> searchResults = this.ctx.search(this.getRoleFilterBase(), query, cons);
        ArrayList rolePrincipalUids = new ArrayList();
        while (searchResults.hasMore()) {
            SearchResult result = searchResults.next();
            Attributes answer = result.getAttributes();
            rolePrincipalUids.addAll(this.getAttributes(this.getAttribute(this.getRoleIdAttribute(), answer)));
        }
        return rolePrincipalUids.toArray(new String[rolePrincipalUids.size()]);
    }

    public String[] searchRoleMemberShipByUser(String userPrincipalUid, SearchControls cons) throws NamingException {
        NamingEnumeration results = this.searchByWildcardedUid(userPrincipalUid, cons);
        if (!results.hasMore()) {
            throw new NamingException("Could not find any user with uid[" + userPrincipalUid + "]");
        }
        Attributes userAttributes = this.getFirstUser(results);
        ArrayList<String> newAttrs = new ArrayList<String>();
        Attribute attr = this.getAttribute(this.getUserRoleMembershipAttribute(), userAttributes);
        List attrs = this.getAttributes(attr);
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String cn;
            String cnfull = (String)it.next();
            if (cnfull.toLowerCase().indexOf(this.getRoleFilterBase().toLowerCase()) != -1) {
                cn = this.extractLdapAttr(cnfull, this.getRoleUidAttribute());
                if (cn == null) continue;
                newAttrs.add(cn);
                continue;
            }
            cn = cnfull;
            newAttrs.add(cn);
        }
        return newAttrs.toArray(new String[newAttrs.size()]);
    }

    public String[] searchUsersFromGroupByGroup(String groupPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getGroupIdAttribute() + "=" + groupPrincipalUid + ")" + this.getGroupFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        ArrayList userPrincipalUids = new ArrayList();
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(this.getGroupFilterBase(), query, cons);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes answer = result.getAttributes();
            ArrayList<String> newAttrs = new ArrayList<String>();
            Attribute userPrincipalUid = this.getAttribute(this.getGroupMembershipAttribute(), answer);
            List attrs = this.getAttributes(userPrincipalUid);
            Iterator it = attrs.iterator();
            while (it.hasNext()) {
                String uid;
                String uidfull = (String)it.next();
                if (StringUtils.isEmpty((String)uidfull) || uidfull.toLowerCase().indexOf(this.getUserFilterBase().toLowerCase()) == -1 || (uid = this.extractLdapAttr(uidfull, this.getUserIdAttribute())) == null) continue;
                newAttrs.add(uid);
            }
            userPrincipalUids.addAll(newAttrs);
        }
        return userPrincipalUids.toArray(new String[userPrincipalUids.size()]);
    }

    public String[] searchUsersFromGroupByUser(String groupPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getUserGroupMembershipAttribute() + "=" + this.getGroupDN(groupPrincipalUid) + ")" + this.getUserFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(this.getUserFilterBase(), query, cons);
        ArrayList userPrincipalUids = new ArrayList();
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes answer = result.getAttributes();
            userPrincipalUids.addAll(this.getAttributes(this.getAttribute(this.getUserIdAttribute(), answer)));
        }
        return userPrincipalUids.toArray(new String[userPrincipalUids.size()]);
    }

    public String[] searchRolesFromGroupByGroup(String groupPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getGroupIdAttribute() + "=" + groupPrincipalUid + ")" + this.getGroupFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        ArrayList<String> rolePrincipalUids = new ArrayList<String>();
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> groups = this.ctx.search(this.getGroupFilterBase(), query, cons);
        while (groups.hasMore()) {
            SearchResult group = groups.next();
            Attributes groupAttributes = group.getAttributes();
            Attribute rolesFromGroup = this.getAttribute(this.getGroupMembershipForRoleAttribute(), groupAttributes);
            List roleDNs = this.getAttributes(rolesFromGroup, this.getRoleFilterBase());
            Iterator it = roleDNs.iterator();
            while (it.hasNext()) {
                NamingEnumeration rolesResults;
                String roleId;
                String roleDN = (String)it.next();
                if (StringUtils.isEmpty((String)roleDN) || (roleId = this.extractLdapAttr(roleDN, this.getRoleUidAttribute())) == null || !(rolesResults = this.searchRoleByWildcardedUid(roleId, cons)).hasMore() || rolesResults.nextElement() == null) continue;
                rolePrincipalUids.add(roleId);
            }
        }
        return rolePrincipalUids.toArray(new String[rolePrincipalUids.size()]);
    }

    public String[] searchRolesFromGroupByRole(String groupPrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getRoleGroupMembershipForRoleAttribute() + "=" + this.getGroupDN(groupPrincipalUid) + ")" + this.getRoleFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(this.getRoleFilterBase(), query, cons);
        ArrayList rolePrincipalUids = new ArrayList();
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes answer = result.getAttributes();
            rolePrincipalUids.addAll(this.getAttributes(this.getAttribute(this.getRoleIdAttribute(), answer)));
        }
        return rolePrincipalUids.toArray(new String[rolePrincipalUids.size()]);
    }

    public String[] searchUsersFromRoleByRole(String rolePrincipalUid, SearchControls cons) throws NamingException {
        String query = "(&(" + this.getRoleIdAttribute() + "=" + rolePrincipalUid + ")" + this.getRoleFilter() + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        ArrayList<String> userPrincipalUids = new ArrayList<String>();
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(this.getRoleFilterBase(), query, cons);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes answer = result.getAttributes();
            Attribute userPrincipalUid = this.getAttribute(this.getRoleMembershipAttribute(), answer);
            List attrs = this.getAttributes(userPrincipalUid);
            Iterator it = attrs.iterator();
            while (it.hasNext()) {
                String uid;
                String uidfull = (String)it.next();
                if (StringUtils.isEmpty((String)uidfull) || (uid = this.extractLdapAttr(uidfull, this.getUserIdAttribute())) == null) continue;
                userPrincipalUids.add(uid);
            }
        }
        return userPrincipalUids.toArray(new String[userPrincipalUids.size()]);
    }

    public String[] searchUsersFromRoleByUser(String rolePrincipalUid, SearchControls cons) throws NamingException {
        String roleMemberAttr = this.getUserRoleMembershipAttribute();
        StringBuffer byRolePrincipalUidMatch = new StringBuffer("(").append(roleMemberAttr).append("=").append(rolePrincipalUid).append(")");
        StringBuffer byRoleDNMatch = new StringBuffer("(").append(roleMemberAttr).append("=").append(this.getRoleDN(rolePrincipalUid, true)).append(")");
        StringBuffer completeRoleAttrMatch = new StringBuffer("(|").append(byRolePrincipalUidMatch).append(byRoleDNMatch).append(")");
        StringBuffer query = new StringBuffer("(&").append(completeRoleAttrMatch).append("(").append(this.getUserFilter()).append("))");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("query[" + query + "]"));
        }
        cons.setSearchScope(this.getSearchScope());
        NamingEnumeration<SearchResult> results = this.ctx.search(this.getUserFilterBase(), query.toString(), cons);
        ArrayList userPrincipalUids = new ArrayList();
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes answer = result.getAttributes();
            userPrincipalUids.addAll(this.getAttributes(this.getAttribute(this.getUserIdAttribute(), answer)));
        }
        return userPrincipalUids.toArray(new String[userPrincipalUids.size()]);
    }

    protected List getAttributes(Attribute attr) throws NamingException {
        return this.getAttributes(attr, null);
    }

    protected List getAttributes(Attribute attr, String filter) throws NamingException {
        ArrayList<String> uids = new ArrayList<String>();
        if (attr != null) {
            NamingEnumeration<?> groupUidEnum = attr.getAll();
            while (groupUidEnum.hasMoreElements()) {
                String groupDN = (String)groupUidEnum.nextElement();
                if (filter == null) {
                    uids.add(groupDN);
                    continue;
                }
                if (filter == null || groupDN.toLowerCase().indexOf(filter.toLowerCase()) == -1) continue;
                uids.add(groupDN);
            }
        }
        return uids;
    }

    private Attributes getFirstUser(NamingEnumeration results) throws NamingException {
        SearchResult result = (SearchResult)results.next();
        Attributes answer = result.getAttributes();
        return answer;
    }

    protected Attributes defineLdapAttributes(String principalUid) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute classes = new BasicAttribute("objectclass");
        classes.add("top");
        classes.add("person");
        classes.add("organizationalPerson");
        classes.add("inetorgperson");
        attrs.put(classes);
        attrs.put("cn", principalUid);
        attrs.put("sn", principalUid);
        return attrs;
    }

    protected String getDnSuffix() {
        return this.getUserFilterBase();
    }

    protected Principal makePrincipal(String principalUid) {
        return new UserPrincipalImpl(principalUid);
    }

    private String extractLdapAttr(String dn, String ldapAttrName) {
        String ldapAttrNameLowerCase;
        String dnLowerCase = dn.toLowerCase();
        if (dnLowerCase.indexOf((ldapAttrNameLowerCase = ldapAttrName.toLowerCase()) + "=") == -1) {
            return null;
        }
        if (dn.indexOf(",") != -1 && dnLowerCase.indexOf(ldapAttrNameLowerCase + "=") != -1) {
            return dn.substring(dnLowerCase.indexOf(ldapAttrNameLowerCase) + ldapAttrName.length() + 1, dn.indexOf(","));
        }
        return dn.substring(dnLowerCase.indexOf(ldapAttrNameLowerCase) + ldapAttrName.length() + 1, dn.length());
    }

    protected String[] getObjectClasses() {
        return this.getUserObjectClasses();
    }

    protected String getUidAttributeForPrincipal() {
        return this.getUserUidAttribute();
    }

    protected String[] getAttributes() {
        return this.getUserAttributes();
    }

    protected String getEntryPrefix() {
        return this.getUidAttribute();
    }

    protected String getSearchSuffix() {
        return this.getUserFilter();
    }
}

