/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Collection;
import java.util.Date;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;
import org.apache.jetspeed.security.spi.impl.AbstractInternalPasswordCredentialInterceptorImpl;

public class PasswordExpirationInterceptor
extends AbstractInternalPasswordCredentialInterceptorImpl {
    private long maxLifeSpanInMillis;

    public PasswordExpirationInterceptor(int maxLifeSpanInDays) {
        this.maxLifeSpanInMillis = (long)maxLifeSpanInDays * 1000L * 60L * 60L * 24L;
    }

    public boolean afterAuthenticated(InternalUserPrincipal internalUser, String userName, InternalCredential credential, boolean authenticated) throws SecurityException {
        long currentTime;
        long expirationTime;
        boolean update = false;
        if (!credential.isExpired() && (expirationTime = credential.getExpirationDate().getTime()) <= (currentTime = new Date().getTime())) {
            credential.setExpired(true);
            update = true;
        }
        return update;
    }

    public boolean afterLoad(PasswordCredentialProvider pcProvider, String userName, InternalCredential credential) throws SecurityException {
        boolean update = false;
        if (credential.getExpirationDate() == null) {
            credential.setExpirationDate(new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis));
            update = true;
        }
        return update;
    }

    public void beforeCreate(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password) throws SecurityException {
        this.setExpiration(credential);
    }

    public void beforeSetPassword(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password, boolean authenticated) throws SecurityException {
        this.setExpiration(credential);
    }

    protected void setExpiration(InternalCredential credential) {
        java.sql.Date nextExpirationDate = new java.sql.Date(new Date().getTime() + this.maxLifeSpanInMillis);
        if (credential.getExpirationDate() == null || credential.getExpirationDate().before(nextExpirationDate)) {
            credential.setExpirationDate(nextExpirationDate);
        }
        credential.setExpired(false);
    }
}

