/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.spi.impl;

import java.util.Collection;
import java.util.List;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.om.InternalCredential;
import org.apache.jetspeed.security.om.InternalUserPrincipal;
import org.apache.jetspeed.security.spi.InternalPasswordCredentialInterceptor;
import org.apache.jetspeed.security.spi.PasswordCredentialProvider;

public class InternalPasswordCredentialInterceptorsProxy
implements InternalPasswordCredentialInterceptor {
    private InternalPasswordCredentialInterceptor[] interceptors;

    public InternalPasswordCredentialInterceptorsProxy(List interceptors) {
        this.interceptors = interceptors.toArray(new InternalPasswordCredentialInterceptor[interceptors.size()]);
    }

    public boolean afterLoad(PasswordCredentialProvider pcProvider, String userName, InternalCredential credential) throws SecurityException {
        boolean updated = false;
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null || !this.interceptors[i].afterLoad(pcProvider, userName, credential)) continue;
            updated = true;
        }
        return updated;
    }

    public boolean afterAuthenticated(InternalUserPrincipal internalUser, String userName, InternalCredential credential, boolean authenticated) throws SecurityException {
        boolean updated = false;
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null || !this.interceptors[i].afterAuthenticated(internalUser, userName, credential, authenticated)) continue;
            updated = true;
        }
        return updated;
    }

    public void beforeCreate(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password) throws SecurityException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null) continue;
            this.interceptors[i].beforeCreate(internalUser, credentials, userName, credential, password);
        }
    }

    public void beforeSetPassword(InternalUserPrincipal internalUser, Collection credentials, String userName, InternalCredential credential, String password, boolean authenticated) throws SecurityException {
        for (int i = 0; i < this.interceptors.length; ++i) {
            if (this.interceptors[i] == null) continue;
            this.interceptors[i].beforeSetPassword(internalUser, credentials, userName, credential, password, authenticated);
        }
    }
}

