/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.impl;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.security.PermissionManager;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.SecurityPolicies;

public class RdbmsPolicy
extends Policy {
    private static final Log log = LogFactory.getLog((Class)RdbmsPolicy.class);
    private PermissionManager pms = null;

    public RdbmsPolicy(PermissionManager pms) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RdbmsPolicy constructed.");
        }
        this.pms = pms;
    }

    public void refresh() {
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        Principal[] principals = protectionDomain.getPrincipals();
        Permissions perms = new Permissions();
        boolean permImplied = false;
        if (null != principals && principals.length > 0) {
            if (permission.getClass().getName().startsWith("java")) {
                ((PermissionCollection)perms).add(new AllPermission());
            } else {
                perms = this.pms.getPermissions(Arrays.asList(principals));
            }
        } else {
            ((PermissionCollection)perms).add(new AllPermission());
        }
        if (null != perms) {
            permImplied = ((PermissionCollection)perms).implies(permission);
        }
        return permImplied;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection otherPerms = new Permissions();
        if (null != domain) {
            otherPerms = this.getPermissions(domain.getCodeSource());
        }
        return otherPerms;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection otherPerms = this.getOtherPoliciesPermissions(codeSource);
        return otherPerms;
    }

    private PermissionCollection getOtherPoliciesPermissions(CodeSource codeSource) {
        log.debug((Object)("CodeSource: " + codeSource.getLocation().getPath()));
        List securityPolicies = SecurityPolicies.getInstance().getUsedPolicies();
        Permissions otherPerms = new Permissions();
        for (int i = 0; i < securityPolicies.size(); ++i) {
            Policy currPolicy = (Policy)securityPolicies.get(i);
            if (currPolicy.getClass().equals(this.getClass())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking policy: " + currPolicy.getClass().getName()));
            }
            PermissionCollection currPerms = currPolicy.getPermissions(codeSource);
            SecurityHelper.addPermissions(otherPerms, currPerms);
        }
        return otherPerms;
    }
}

