/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.handlers.pam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.search.AbstractObjectHandler;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.util.JetspeedLocale;

public class PortletDefinitionHandler
extends AbstractObjectHandler {
    private static final String KEY_PREFIX = "PortletDefinition::";
    private static final String PORTLET_APPLICATION = "portlet_application";

    public PortletDefinitionHandler() {
        this.fields.add("ID");
        this.fields.add(PORTLET_APPLICATION);
    }

    public ParsedObject parseObject(Object o) {
        BaseParsedObject result = null;
        if (o instanceof PortletDefinition) {
            result = new BaseParsedObject();
            PortletDefinition pd = (PortletDefinition)o;
            String displayNameText = pd.getDisplayNameText(JetspeedLocale.getDefaultLocale());
            result.setTitle(displayNameText);
            String description = pd.getDescriptionText(JetspeedLocale.getDefaultLocale());
            result.setDescription(description);
            result.setClassName(pd.getClass().getName());
            result.setKey(KEY_PREFIX + pd.getUniqueName());
            result.setType("portlet");
            MultiHashMap fieldMap = new MultiHashMap();
            fieldMap.put((Object)"ID", (Object)pd.getPortletName());
            PortletApplication pa = pd.getApplication();
            fieldMap.put((Object)PORTLET_APPLICATION, (Object)pa.getName());
            Collection mdFields = pd.getMetadata().getFields();
            for (LocalizedField field : mdFields) {
                fieldMap.put((Object)field.getName(), (Object)field.getValue());
            }
            for (Description d : pd.getDescriptions()) {
                fieldMap.put((Object)"fieldname.description", (Object)d.getDescription());
            }
            for (Description d : pd.getDisplayNames()) {
                fieldMap.put((Object)"fieldname.title", (Object)d.getDisplayName());
            }
            HashSet<String> keywordSet = new HashSet<String>();
            for (Language lang : pd.getLanguages()) {
                fieldMap.put((Object)"fieldname.title", (Object)lang.getTitle());
                fieldMap.put((Object)"fieldname.title", (Object)lang.getShortTitle());
                for (String keyword : lang.getKeywordList()) {
                    keywordSet.add(keyword);
                }
            }
            String[] temp = new String[keywordSet.size()];
            result.setKeywords(keywordSet.toArray(temp));
            result.setFields((Map)fieldMap);
        }
        return result;
    }
}

