/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.jetspeed.search.AbstractObjectHandler;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.ParsedObject;

public class URLToDocHandler
extends AbstractObjectHandler {
    public ParsedObject parseObject(Object o) {
        BaseParsedObject result = new BaseParsedObject();
        if (!(o instanceof URL)) {
            return null;
        }
        URL pageToAdd = (URL)o;
        String content = this.getContentFromURL(pageToAdd);
        if (content != null) {
            try {
                result.setKey(URLEncoder.encode(pageToAdd.toString(), "UTF-8"));
                result.setType("url");
                result.setTitle(pageToAdd.toString());
                result.setContent(content);
                result.setDescription("");
                result.setLanguage("");
                result.setURL(pageToAdd);
                result.setClassName(o.getClass().getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            return this.readContentFromURL(url);
        }
        String content = null;
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url.toString());
        method.setFollowRedirects(true);
        int statusCode = -1;
        int attempt = 0;
        try {
            while (statusCode == -1 && attempt < 3) {
                try {
                    client.executeMethod((HttpMethod)method);
                    statusCode = method.getStatusCode();
                }
                catch (HttpException e) {
                    ++attempt;
                }
                catch (IOException e) {
                    String string = null;
                    method.releaseConnection();
                    return string;
                }
            }
            if (statusCode != -1) {
                try {
                    content = method.getResponseBodyAsString();
                }
                catch (Exception ioe) {
                    // empty catch block
                }
            }
        }
        finally {
            method.releaseConnection();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContentFromURL(URL url) {
        String content = null;
        InputStream input = null;
        try {
            input = url.openStream();
            content = IOUtils.toString((InputStream)input);
        }
        catch (Exception e) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ce) {}
            }
        }
        return content;
    }
}

