/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.lucene;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.search.BaseParsedObject;
import org.apache.jetspeed.search.HandlerFactory;
import org.apache.jetspeed.search.ObjectHandler;
import org.apache.jetspeed.search.ParsedObject;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.search.SearchResults;
import org.apache.jetspeed.search.SearchResultsImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchEngineImpl
implements SearchEngine {
    protected static final Logger log = LoggerFactory.getLogger(SearchEngineImpl.class);
    private Directory directory;
    private Analyzer analyzer;
    private boolean optimizeAfterUpdate = true;
    private HandlerFactory handlerFactory;
    private static final int KEYWORD = 0;
    private static final int TEXT = 1;
    private int defaultTopHitsCount = 1000;

    public SearchEngineImpl(Directory directory, Analyzer analyzer, boolean optimzeAfterUpdate, HandlerFactory handlerFactory) throws Exception {
        this(directory, analyzer, optimzeAfterUpdate, handlerFactory, 0);
    }

    public SearchEngineImpl(Directory directory, Analyzer analyzer, boolean optimzeAfterUpdate, HandlerFactory handlerFactory, int defaultTopHitsCount) throws Exception {
        this.directory = directory;
        this.analyzer = analyzer;
        this.optimizeAfterUpdate = optimzeAfterUpdate;
        this.handlerFactory = handlerFactory;
        if (defaultTopHitsCount > 0) {
            this.defaultTopHitsCount = defaultTopHitsCount;
        }
        this.validateIndexDirectory();
    }

    public SearchEngineImpl(String indexRoot, String analyzerClassName, boolean optimzeAfterUpdate, HandlerFactory handlerFactory) throws Exception {
        this(indexRoot, analyzerClassName, optimzeAfterUpdate, handlerFactory, 0);
    }

    public SearchEngineImpl(String indexRoot, String analyzerClassName, boolean optimzeAfterUpdate, HandlerFactory handlerFactory, int defaultTopHitsCount) throws Exception {
        File rootIndexDir;
        if (analyzerClassName != null) {
            try {
                Class<?> analyzerClass = Class.forName(analyzerClassName);
                this.analyzer = (Analyzer)analyzerClass.newInstance();
            }
            catch (InstantiationException ce) {
            }
            catch (ClassNotFoundException ce) {
            }
            catch (IllegalAccessException ce) {
                // empty catch block
            }
        }
        if (this.analyzer == null) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_30);
        }
        this.optimizeAfterUpdate = optimzeAfterUpdate;
        this.handlerFactory = handlerFactory;
        if (defaultTopHitsCount > 0) {
            this.defaultTopHitsCount = defaultTopHitsCount;
        }
        if (!(rootIndexDir = new File(indexRoot)).isDirectory()) {
            rootIndexDir.mkdirs();
        }
        this.directory = FSDirectory.open((File)rootIndexDir);
        this.validateIndexDirectory();
    }

    public boolean add(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.add(c);
    }

    public boolean add(Collection objects) {
        return this.removeIfExistsAndAdd(objects);
    }

    public boolean remove(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.remove(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(Collection objects) {
        IndexReader indexReader = null;
        int deleteCount = 0;
        try {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                if (indexReader == null) {
                    indexReader = IndexReader.open((Directory)this.directory, (boolean)false);
                }
                Object o = it.next();
                ObjectHandler handler = this.handlerFactory.getHandler(o);
                ParsedObject parsedObject = handler.parseObject(o);
                Term term = null;
                if (parsedObject.getKey() == null) continue;
                term = new Term("fieldname.key", parsedObject.getKey());
                deleteCount += indexReader.deleteDocuments(term);
            }
            if (indexReader != null) {
                indexReader.close();
                indexReader = null;
            }
            if (deleteCount > 0 && this.optimizeAfterUpdate) {
                this.optimizeIndex();
            }
        }
        catch (Exception e) {
            log.error("Exception during removing documents in the search index.", (Throwable)e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException ce) {}
            }
        }
        return deleteCount > 0;
    }

    public boolean update(Object o) {
        ArrayList<Object> c = new ArrayList<Object>(1);
        c.add(o);
        return this.update(c);
    }

    public boolean update(Collection objects) {
        return this.removeIfExistsAndAdd(objects);
    }

    public synchronized boolean optimize() {
        return this.optimizeIndex();
    }

    private boolean optimizeIndex() {
        boolean result = false;
        try {
            IndexWriter indexWriter = new IndexWriter(this.directory, this.analyzer, false, IndexWriter.MaxFieldLength.UNLIMITED);
            indexWriter.optimize();
            indexWriter.close();
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public SearchResults search(String queryString) {
        return this.search(queryString, "fieldname.synthetic");
    }

    public SearchResults search(String queryString, String defaultFieldName) {
        return this.search(queryString, defaultFieldName, this.defaultTopHitsCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResults search(String queryString, String defaultFieldName, int topHitsCount) {
        SearchResultsImpl results = null;
        IndexReader indexReader = null;
        IndexSearcher searcher = null;
        try {
            indexReader = IndexReader.open((Directory)this.directory);
            searcher = new IndexSearcher(indexReader);
            QueryParser queryParser = new QueryParser(Version.LUCENE_30, defaultFieldName, this.analyzer);
            Query query = queryParser.parse(queryString);
            TopDocs topDocs = searcher.search(query, topHitsCount);
            int count = Math.min(topHitsCount, topDocs.totalHits);
            ArrayList<BaseParsedObject> resultList = new ArrayList<BaseParsedObject>(count);
            for (int i = 0; i < count; ++i) {
                Field[] keywords;
                Field url;
                Field classname;
                Field language;
                Field content;
                Field title;
                Field description;
                Field key;
                BaseParsedObject result = new BaseParsedObject();
                Document doc = searcher.doc(topDocs.scoreDocs[i].doc);
                this.addFieldsToParsedObject(doc, result);
                result.setScore(topDocs.scoreDocs[i].score);
                Field type = doc.getField("fieldname.type");
                if (type != null) {
                    result.setType(type.stringValue());
                }
                if ((key = doc.getField("fieldname.key")) != null) {
                    result.setKey(key.stringValue());
                }
                if ((description = doc.getField("fieldname.description")) != null) {
                    result.setDescription(description.stringValue());
                }
                if ((title = doc.getField("fieldname.title")) != null) {
                    result.setTitle(title.stringValue());
                }
                if ((content = doc.getField("fieldname.content")) != null) {
                    result.setContent(content.stringValue());
                }
                if ((language = doc.getField("fieldname.language")) != null) {
                    result.setLanguage(language.stringValue());
                }
                if ((classname = doc.getField("fieldname.className")) != null) {
                    result.setClassName(classname.stringValue());
                }
                if ((url = doc.getField("fieldname.url")) != null) {
                    result.setURL(new URL(url.stringValue()));
                }
                if ((keywords = doc.getFields("fieldname.keywords")) != null) {
                    String[] keywordArray = new String[keywords.length];
                    for (int j = 0; j < keywords.length; ++j) {
                        Field keyword = keywords[j];
                        keywordArray[j] = keyword.stringValue();
                    }
                    result.setKeywords(keywordArray);
                }
                resultList.add(i, result);
            }
            results = new SearchResultsImpl(resultList);
        }
        catch (Exception e) {
            log.error("Failed to search. ", (Throwable)e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException ioe) {}
            }
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException ioe) {}
            }
        }
        return results != null ? results : new SearchResultsImpl(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean removeIfExistsAndAdd(Collection objects) {
        IndexWriter indexWriter = null;
        IndexReader indexReader = null;
        IndexSearcher searcher = null;
        try {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                String[] keywordArray;
                if (indexWriter == null) {
                    indexWriter = new IndexWriter(this.directory, this.analyzer, false, IndexWriter.MaxFieldLength.UNLIMITED);
                    indexReader = indexWriter.getReader();
                    searcher = new IndexSearcher(indexReader);
                }
                Object o = it.next();
                ObjectHandler handler = null;
                try {
                    handler = this.handlerFactory.getHandler(o);
                }
                catch (Exception e) {
                    log.error("Failed to create hanlder for object " + o.getClass().getName());
                    continue;
                }
                ParsedObject parsedObject = handler.parseObject(o);
                String key = parsedObject.getKey();
                if (parsedObject.getKey() != null) {
                    Term keyTerm = new Term("fieldname.key", key);
                    TopDocs topDocs = searcher.search((Query)new TermQuery(keyTerm), 1);
                    if (topDocs.totalHits > 0) {
                        indexWriter.deleteDocuments(keyTerm);
                    }
                }
                String type = parsedObject.getType();
                String title = parsedObject.getTitle();
                String description = parsedObject.getDescription();
                String content = parsedObject.getContent();
                String language = parsedObject.getLanguage();
                URL url = parsedObject.getURL();
                String className = parsedObject.getClassName();
                Document doc = new Document();
                if (key != null) {
                    doc.add((Fieldable)new Field("fieldname.key", key, Field.Store.YES, Field.Index.NOT_ANALYZED));
                }
                if (type != null) {
                    doc.add((Fieldable)new Field("fieldname.type", type, Field.Store.YES, Field.Index.ANALYZED));
                }
                if (title != null) {
                    doc.add((Fieldable)new Field("fieldname.title", title, Field.Store.YES, Field.Index.ANALYZED));
                }
                if (description != null) {
                    doc.add((Fieldable)new Field("fieldname.description", description, Field.Store.YES, Field.Index.ANALYZED));
                }
                if (content != null) {
                    doc.add((Fieldable)new Field("fieldname.content", content, Field.Store.NO, Field.Index.ANALYZED));
                }
                if (language != null) {
                    doc.add((Fieldable)new Field("fieldname.language", language, Field.Store.YES, Field.Index.ANALYZED));
                }
                if (url != null) {
                    String urlString = url.toString();
                    doc.add((Fieldable)new Field("fieldname.url", urlString, Field.Store.YES, Field.Index.ANALYZED));
                }
                if (className != null) {
                    doc.add((Fieldable)new Field("fieldname.className", className, Field.Store.YES, Field.Index.ANALYZED));
                }
                if ((keywordArray = parsedObject.getKeywords()) != null) {
                    for (int i = 0; i < keywordArray.length; ++i) {
                        String keyword = keywordArray[i];
                        doc.add((Fieldable)new Field("fieldname.keywords", keyword, Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                }
                Map keywords = parsedObject.getKeywordsMap();
                this.addFieldsToDocument(doc, keywords, 0);
                Map fields = parsedObject.getFields();
                this.addFieldsToDocument(doc, fields, 1);
                ArrayList<String> syntheticField = new ArrayList<String>();
                for (Fieldable fieldable : doc.getFields()) {
                    String value = fieldable.stringValue();
                    if (value == null) continue;
                    syntheticField.add(value);
                }
                doc.add((Fieldable)new Field("fieldname.synthetic", StringUtils.join(syntheticField, (char)' '), Field.Store.NO, Field.Index.ANALYZED));
                indexWriter.addDocument(doc);
            }
            if (objects.size() > 0 && this.optimizeAfterUpdate && indexWriter != null) {
                try {
                    indexWriter.optimize();
                }
                catch (IOException e) {
                    log.error("Error while trying to optimize index.", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while writing index.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException ce) {}
            }
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException ce) {}
            }
            if (indexWriter != null) {
                try {
                    indexWriter.close();
                }
                catch (IOException ce) {}
            }
        }
        return true;
    }

    private void addFieldsToDocument(Document doc, Map fields, int type) {
        if (fields != null) {
            for (Object key : fields.keySet()) {
                Object values;
                if (key == null || (values = fields.get(key)) == null) continue;
                if (values instanceof Collection) {
                    for (Object value : (Collection)values) {
                        if (value == null) continue;
                        if (type == 1) {
                            doc.add((Fieldable)new Field(key.toString(), value.toString(), Field.Store.YES, Field.Index.ANALYZED));
                            continue;
                        }
                        doc.add((Fieldable)new Field(key.toString(), value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                    }
                    continue;
                }
                if (type == 1) {
                    doc.add((Fieldable)new Field(key.toString(), values.toString(), Field.Store.YES, Field.Index.ANALYZED));
                    continue;
                }
                doc.add((Fieldable)new Field(key.toString(), values.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
    }

    private void addFieldsToParsedObject(Document doc, ParsedObject o) {
        try {
            MultiValueMap multiKeywords = new MultiValueMap();
            MultiValueMap multiFields = new MultiValueMap();
            HashMap fieldMap = new HashMap();
            Field classNameField = doc.getField("fieldname.className");
            if (classNameField != null) {
                String className = classNameField.stringValue();
                o.setClassName(className);
                ObjectHandler handler = this.handlerFactory.getHandler(className);
                Set fields = handler.getFields();
                this.addFieldsToMap(doc, fields, (Map)multiFields);
                this.addFieldsToMap(doc, fields, fieldMap);
                Set keywords = handler.getKeywords();
                this.addFieldsToMap(doc, keywords, (Map)multiKeywords);
            }
            o.setKeywordsMap((Map)multiKeywords);
            o.setFields((Map)multiFields);
            o.setFields(fieldMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addFieldsToMap(Document doc, Set fieldNames, Map fields) {
        for (String fieldName : fieldNames) {
            Field[] docFields = doc.getFields(fieldName);
            if (docFields == null) continue;
            for (int i = 0; i < docFields.length; ++i) {
                Field field = docFields[i];
                if (field == null) continue;
                String value = field.stringValue();
                fields.put(fieldName, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIndexDirectory() throws Exception {
        boolean recreateIndex = false;
        IndexReader indexReader = null;
        IndexSearcher searcher = null;
        try {
            indexReader = IndexReader.open((Directory)this.directory);
            searcher = new IndexSearcher(indexReader);
            searcher.close();
            searcher = null;
            indexReader.close();
            indexReader = null;
        }
        catch (Exception e) {
            recreateIndex = true;
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (Exception ce) {}
            }
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (Exception ce) {}
            }
        }
        if (recreateIndex) {
            IndexWriter indexWriter = null;
            try {
                indexWriter = new IndexWriter(this.directory, this.analyzer, true, IndexWriter.MaxFieldLength.UNLIMITED);
                indexWriter.close();
                indexWriter = null;
            }
            catch (Exception e1) {
                String message = "Cannot RECREATE Portlet Registry indexes in " + this.directory;
                log.error(message, (Throwable)e1);
                throw new Exception(message);
            }
            finally {
                if (indexWriter != null) {
                    try {
                        indexWriter.close();
                    }
                    catch (Exception ce) {}
                }
            }
        }
    }
}

