/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.search.handlers;

import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.search.HandlerFactory;
import org.apache.jetspeed.search.ObjectHandler;

public class HandlerFactoryImpl
implements HandlerFactory {
    private final Map handlerCache = new HashMap();
    private Map classNameMapping = new HashMap();

    public HandlerFactoryImpl(Map classNameMapping) {
        this.classNameMapping = classNameMapping;
    }

    public void addClassNameMapping(String className, String handlerClassName) {
        this.classNameMapping.put(className, handlerClassName);
    }

    public ObjectHandler getHandler(Object obj) throws Exception {
        return this.getHandler(obj.getClass().getName());
    }

    public ObjectHandler getHandler(String className) throws Exception {
        ObjectHandler handler = null;
        if (this.handlerCache.containsKey(className)) {
            handler = (ObjectHandler)this.handlerCache.get(className);
        } else {
            String handlerClass = (String)this.classNameMapping.get(className);
            if (handlerClass == null) {
                throw new Exception("No handler was found for document type: " + className);
            }
            handler = (ObjectHandler)Class.forName(handlerClass).newInstance();
            this.handlerCache.put(className, handler);
        }
        return handler;
    }
}

