/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.transform.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.apache.portals.applications.util.Streams;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TransformDTDEntityResolver
implements EntityResolver {
    private Map dtds;

    public TransformDTDEntityResolver(Map dtds) {
        this.dtds = dtds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        try {
            byte[] dtd = (byte[])this.dtds.get(systemId);
            if (dtd == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                URL url = new URL(systemId);
                Streams.drain(url.openStream(), (OutputStream)baos);
                dtd = baos.toByteArray();
                Map map = this.dtds;
                synchronized (map) {
                    this.dtds.put(systemId, dtd);
                }
            }
            if (dtd != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(dtd);
                InputSource is = new InputSource(bais);
                is.setPublicId(publicId);
                is.setSystemId(systemId);
                return is;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }
}

