/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.MutableAttributes;
import org.apache.jetspeed.rewriter.ParserAdaptor;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RewriterException;
import org.apache.jetspeed.util.Streams;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxParserAdaptor
implements ParserAdaptor {
    protected static final Log log = LogFactory.getLog((Class)SaxParserAdaptor.class);
    private String lineSeparator = System.getProperty("line.separator", "\r\n");
    private Rewriter rewriter;
    private static Map dtds = new HashMap();

    public void parse(Rewriter rewriter, Reader reader) throws RewriterException {
        try {
            this.rewriter = rewriter;
            SAXParser sp = this.getParser();
            sp.parse(new InputSource(reader), (DefaultHandler)new SaxFormatHandler(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RewriterException(e);
        }
    }

    public void rewrite(Rewriter rewriter, Reader reader, Writer writer) throws RewriterException {
    }

    protected SAXParser getParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        return spf.newSAXParser();
    }

    public static Map getDtds() {
        return dtds;
    }

    public static void clearDtdCache() {
        dtds.clear();
    }

    public class SaxFormatHandler
    extends DefaultHandler {
        private int elementCount = 0;
        private boolean emit = true;
        private Writer writer = null;

        public SaxFormatHandler(Writer writer) {
            this.writer = writer;
        }

        private void write(String text) throws IOException {
            if (this.writer != null) {
                this.writer.write(text);
            }
        }

        public void characters(char[] values, int start, int length) {
            if (!this.emit) {
                return;
            }
            if (!SaxParserAdaptor.this.rewriter.enterText(values, start)) {
                return;
            }
            if (this.writer != null) {
                try {
                    this.writer.write(values);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }

        public void startElement(String uri, String localName, String qName, MutableAttributes attributes) throws SAXException {
            String tag = qName;
            if (!SaxParserAdaptor.this.rewriter.enterStartTagEvent(tag.toString(), attributes)) {
                return;
            }
            try {
                this.appendTagToResult(tag, attributes);
                this.write(SaxParserAdaptor.this.lineSeparator);
                String appended = SaxParserAdaptor.this.rewriter.exitStartTagEvent(tag.toString(), attributes);
                if (null != appended) {
                    this.write(appended);
                }
            }
            catch (Exception e) {
                log.error((Object)"Start tag parsing error", (Throwable)e);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            String tag = qName;
            ++this.elementCount;
            if (!SaxParserAdaptor.this.rewriter.enterEndTagEvent(tag.toString())) {
                return;
            }
            try {
                this.addToResult("</").addToResult(tag).addToResult(">");
                this.write(SaxParserAdaptor.this.lineSeparator);
                String appended = SaxParserAdaptor.this.rewriter.exitEndTagEvent(tag.toString());
                if (null != appended) {
                    this.write(appended);
                }
            }
            catch (Exception e) {
                log.error((Object)"End tag parsing error", (Throwable)e);
            }
        }

        private void appendTagToResult(String tag, MutableAttributes attrs) {
            this.convertURLS(tag, attrs);
            this.addToResult("<").addToResult(tag);
            for (int ix = 0; ix < attrs.getLength(); ++ix) {
                String value = attrs.getValue(ix);
                this.addToResult(" ").addToResult(value).addToResult("=\"").addToResult(value).addToResult("\"");
            }
            this.addToResult(">");
        }

        private SaxFormatHandler addToResult(Object txt) {
            try {
                this.write(txt.toString());
            }
            catch (Exception e) {
                System.err.println("Error parsing:" + e);
            }
            return this;
        }

        private void convertURLS(String tag, MutableAttributes attrs) {
            SaxParserAdaptor.this.rewriter.enterConvertTagEvent(tag.toString(), attrs);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            try {
                Map dtds = SaxParserAdaptor.getDtds();
                byte[] dtd = (byte[])dtds.get(systemId);
                if (dtd == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    URL url = new URL(systemId);
                    Streams.drain(url.openStream(), (OutputStream)baos);
                    dtd = baos.toByteArray();
                    dtds.put(systemId, dtd);
                }
                if (dtd != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(dtd);
                    InputSource is = new InputSource(bais);
                    is.setPublicId(publicId);
                    is.setSystemId(systemId);
                    return is;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error((Object)"failed to get URL input source", t);
            }
            return null;
        }
    }
}

