/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter;

import java.util.StringTokenizer;
import javax.portlet.PortletURL;
import org.apache.jetspeed.rewriter.MutableAttributes;
import org.apache.jetspeed.rewriter.Rewriter;
import org.apache.jetspeed.rewriter.RulesetRewriterImpl;

public class WebContentRewriter
extends RulesetRewriterImpl
implements Rewriter {
    public static final String ACTION_PARAMETER_URL = "_AP_URL";
    public static final String ACTION_PARAMETER_METHOD = "_AP_METHOD";
    private PortletURL actionURL = null;

    public void enterConvertTagEvent(String tagid, MutableAttributes attributes) {
        super.enterConvertTagEvent(tagid, attributes);
    }

    public void setActionURL(PortletURL action) {
        this.actionURL = action;
    }

    public PortletURL getActionURL() {
        return this.actionURL;
    }

    public String rewriteUrl(String url, String tag, String attribute, MutableAttributes otherAttributes) {
        String modifiedURL = url;
        modifiedURL = this.getModifiedURL(url);
        if ((tag.equalsIgnoreCase("A") && attribute.equalsIgnoreCase("href") || tag.equalsIgnoreCase("FORM") && attribute.equalsIgnoreCase("action")) && this.actionURL != null) {
            String httpMethod;
            this.actionURL.setParameter(ACTION_PARAMETER_URL, modifiedURL);
            if (tag.equalsIgnoreCase("FORM") && (httpMethod = otherAttributes.getValue("method")) != null) {
                this.actionURL.setParameter(ACTION_PARAMETER_METHOD, httpMethod);
            }
            modifiedURL = this.actionURL.toString();
        }
        if (attribute.equalsIgnoreCase("onclick")) {
            for (int i = 0; i < otherAttributes.getLength(); ++i) {
                String value;
                int index;
                String name = otherAttributes.getQName(i);
                if (!name.equalsIgnoreCase("onclick") || (index = (value = otherAttributes.getValue(i)).indexOf(".location=")) < 0) continue;
                String oldLocation = value.substring(index + ".location=".length());
                StringTokenizer tokenizer = new StringTokenizer(oldLocation, "'\"");
                modifiedURL = oldLocation = tokenizer.nextToken();
                url = oldLocation;
                modifiedURL = this.getModifiedURL(url);
                if (this.actionURL != null) {
                    this.actionURL.setParameter(ACTION_PARAMETER_URL, modifiedURL);
                    modifiedURL = this.actionURL.toString();
                }
                modifiedURL = value.replaceAll(oldLocation, modifiedURL);
            }
        }
        return modifiedURL;
    }

    private String getModifiedURL(String url) {
        String modifiedURL = url;
        if (url.startsWith("/") || !url.startsWith("http:") && !url.startsWith("https:")) {
            modifiedURL = this.getBaseUrl() != null ? this.getBaseRelativeUrl(url) : url;
        }
        return modifiedURL;
    }
}

