/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.rewriter;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.rewriter.BasicRewriter;
import org.apache.jetspeed.rewriter.MutableAttributes;
import org.apache.jetspeed.rewriter.RulesetRewriter;
import org.apache.jetspeed.rewriter.rules.Attribute;
import org.apache.jetspeed.rewriter.rules.Rule;
import org.apache.jetspeed.rewriter.rules.Ruleset;
import org.apache.jetspeed.rewriter.rules.Tag;

public class RulesetRewriterImpl
extends BasicRewriter
implements RulesetRewriter {
    protected static final Log log = LogFactory.getLog((Class)RulesetRewriterImpl.class);
    private Ruleset ruleset = null;
    private boolean removeComments = false;

    public boolean shouldStripTag(String tagid) {
        if (null == this.ruleset) {
            return false;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return false;
        }
        return tag.getStrip();
    }

    public boolean shouldRemoveTag(String tagid) {
        if (null == this.ruleset) {
            return false;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return false;
        }
        return tag.getRemove();
    }

    public void setRuleset(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }

    public boolean shouldRemoveComments() {
        if (null == this.ruleset) {
            return false;
        }
        return this.ruleset.getRemoveComments();
    }

    public void enterConvertTagEvent(String tagid, MutableAttributes attributes) {
        if (null == this.ruleset) {
            return;
        }
        Tag tag = this.ruleset.getTag(tagid.toUpperCase());
        if (null == tag) {
            return;
        }
        Iterator attribRules = tag.getAttributes().iterator();
        while (attribRules.hasNext()) {
            String rewritten;
            Rule rule;
            Attribute attribute = (Attribute)attribRules.next();
            String name = attribute.getId();
            String value = attributes.getValue(name);
            if (value == null || null == (rule = attribute.getRule()) || !rule.shouldRewrite(value) || null == (rewritten = this.rewriteUrl(value, tag.getId(), name, attributes))) continue;
            if (rule.getSuffix() != null) {
                rewritten = rewritten.concat(rule.getSuffix());
            }
            attributes.addAttribute(name, rewritten);
            if (!rule.getPopup()) continue;
            attributes.addAttribute("TARGET", "_BLANK");
        }
    }

    public String rewriteUrl(String url, String tag, String attribute, MutableAttributes otherAttributes) {
        return this.getBaseRelativeUrl(url);
    }
}

