/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.EventDefinitionReference;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.PortletInfo;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.Preferences;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.om.portlet.SupportedPublicRenderParameter;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.om.portlet.impl.DisplayNameImpl;
import org.apache.jetspeed.om.portlet.impl.InitParamImpl;
import org.apache.jetspeed.om.portlet.impl.LanguageImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionMetadataImpl;
import org.apache.jetspeed.om.portlet.impl.PreferencesImpl;
import org.apache.jetspeed.om.portlet.impl.ProcessingEventReferenceImpl;
import org.apache.jetspeed.om.portlet.impl.PublishingEventReferenceImpl;
import org.apache.jetspeed.om.portlet.impl.SecurityRoleRefImpl;
import org.apache.jetspeed.om.portlet.impl.SupportedPublicRenderParameterImpl;
import org.apache.jetspeed.om.portlet.impl.SupportsImpl;
import org.apache.jetspeed.util.HashCodeBuilder;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.ojb.CollectionUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.pluto.container.PortletPreference;

public class PortletDefinitionImpl
implements PortletDefinition,
Serializable,
Support,
PersistenceBrokerAware {
    private static final long serialVersionUID = 1L;
    private static PortletPreferencesProvider portletPreferencesProvider;
    private PortletApplication app;
    private Long id;
    protected String portletName;
    protected String portletClass;
    protected String resourceBundle;
    protected String preferenceValidatorClassname;
    private Integer expirationCache;
    private String cacheScope;
    private String cloneParent = null;
    private Collection<LocalizedField> metadataFields = null;
    private String jetspeedSecurityConstraint;
    private List<Description> descriptions;
    private List<DisplayName> displayNames;
    private List<InitParam> initParams;
    private List<EventDefinitionReference> supportedProcessingEvents;
    private List<EventDefinitionReference> supportedPublishingEvents;
    private List<SecurityRoleRef> securityRoleRefs;
    private List<Supports> supports;
    private List<Language> languages;
    private List<ContainerRuntimeOption> containerRuntimeOptions;
    private List<SupportedPublicRenderParameter> supportedPublicRenderParameters;
    private Preferences descriptorPreferences = new PreferencesImpl();

    public static void setPortletPreferencesProvider(PortletPreferencesProvider portletPreferencesProvider) {
        PortletDefinitionImpl.portletPreferencesProvider = portletPreferencesProvider;
    }

    public PortletDefinitionImpl() {
    }

    public PortletDefinitionImpl(String cloneParent) {
        this.cloneParent = cloneParent;
    }

    public PortletApplication getApplication() {
        return this.app;
    }

    public void setApplication(PortletApplication app) {
        this.app = app;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String name) {
        this.portletName = name;
    }

    public String getPortletClass() {
        return this.portletClass;
    }

    public void setPortletClass(String portletClass) {
        this.portletClass = portletClass;
    }

    public void setDescriptorPreferences(Preferences descriptorPreferences) {
        this.descriptorPreferences = descriptorPreferences;
    }

    public Preferences getDescriptorPreferences() {
        return this.descriptorPreferences;
    }

    public Preferences getPortletPreferences() {
        if (portletPreferencesProvider == null) {
            return new PreferencesImpl();
        }
        Map prefMap = portletPreferencesProvider.retrieveDefaultPreferences((PortletDefinition)this);
        PreferencesImpl preferences = new PreferencesImpl();
        List list = preferences.getPortletPreferences();
        for (PortletPreference pref : prefMap.values()) {
            Preference p = preferences.addPreference(pref.getName());
            p.setReadOnly(pref.isReadOnly());
            String[] values = pref.getValues();
            if (values == null) continue;
            for (String s : values) {
                p.addValue(s);
            }
        }
        return preferences;
    }

    public Preference addDescriptorPreference(String name) {
        return this.descriptorPreferences.addPreference(name);
    }

    public Language getLanguage(Locale locale) {
        Language lang = null;
        Language fallback = null;
        Language defaultLanguage = null;
        boolean defaultLocale = locale.equals(JetspeedLocale.getDefaultLocale());
        for (Language l : this.getLanguages()) {
            if (locale.equals(l.getLocale())) {
                lang = l;
                break;
            }
            if (locale.getLanguage().equals(l.getLocale().getLanguage())) {
                fallback = l;
            }
            if (defaultLanguage != null || defaultLocale || !l.getLocale().equals(JetspeedLocale.getDefaultLocale())) continue;
            defaultLanguage = l;
        }
        if (lang == null) {
            LanguageImpl l = new LanguageImpl();
            l.setLocale(locale);
            if (fallback == null && defaultLanguage != null) {
                fallback = defaultLanguage;
            }
            if (fallback != null) {
                l.setTitle(fallback.getTitle());
                l.setShortTitle(fallback.getShortTitle());
                l.setKeywords(fallback.getKeywords());
            }
            lang = l;
        }
        return lang;
    }

    public List<Language> getLanguages() {
        if (this.languages == null) {
            this.languages = CollectionUtils.createList();
        }
        return this.languages;
    }

    public Language addLanguage(Locale locale) {
        if (this.languages == null) {
            this.languages = CollectionUtils.createList();
        }
        for (Language l : this.languages) {
            if (!locale.equals(l.getLocale())) continue;
            return l;
        }
        LanguageImpl l = new LanguageImpl();
        l.setLocale(locale);
        this.languages.add(l);
        return l;
    }

    public String getUniqueName() {
        if (this.app != null && this.app.getName() != null && this.portletName != null) {
            return this.app.getName() + "::" + this.portletName;
        }
        throw new IllegalStateException("Cannot generate a unique portlet name until the application and portlet name have been set");
    }

    public String getDescriptionText(Locale locale) {
        Description desc = this.getDescription(locale);
        return desc != null ? desc.getDescription() : null;
    }

    public String getDisplayNameText(Locale locale) {
        DisplayName dn = this.getDisplayName(locale);
        return dn != null ? dn.getDisplayName() : null;
    }

    public String getPreferenceValidatorClassname() {
        return this.preferenceValidatorClassname;
    }

    public void setPreferenceValidatorClassname(String string) {
        this.preferenceValidatorClassname = string;
    }

    public GenericMetadata getMetadata() {
        if (this.metadataFields == null) {
            this.metadataFields = CollectionUtils.createCollection();
        }
        PortletDefinitionMetadataImpl metadata = new PortletDefinitionMetadataImpl();
        metadata.setFields(this.metadataFields);
        return metadata;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String string) {
        this.resourceBundle = string;
    }

    public String getJetspeedSecurityConstraint() {
        return this.jetspeedSecurityConstraint;
    }

    public void setJetspeedSecurityConstraint(String constraint) {
        this.jetspeedSecurityConstraint = constraint;
    }

    public boolean isSameIdentity(PortletDefinition other) {
        Long otherId = null;
        if (other != null && other instanceof PortletDefinitionImpl) {
            otherId = ((PortletDefinitionImpl)other).id;
        }
        return this.id != null && otherId != null && this.id.equals(otherId);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            boolean sameId;
            PortletDefinitionImpl pd = (PortletDefinitionImpl)obj;
            boolean bl = sameId = this.id != null && pd.id != null && this.id.equals(pd.id);
            if (sameId) {
                return true;
            }
            String otherAppName = pd.getApplication() != null ? pd.getApplication().getName() : null;
            boolean sameAppName = this.app != null && this.app.getName() != null && otherAppName != null && this.app.getName().equals(otherAppName);
            return sameAppName && pd.getPortletName() != null && this.portletName != null && pd.getPortletName().equals(this.portletName);
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hasher = new HashCodeBuilder(1, 3);
        hasher.append((Object)this.portletName);
        if (this.id != null) {
            hasher.append((Object)this.id.toString());
        }
        if (this.app != null) {
            hasher.append((Object)this.app.getName());
        }
        return hasher.toHashCode();
    }

    public void storeChildren() {
    }

    public void postLoad(Object parameter) throws Exception {
    }

    public void afterDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.storeChildren();
    }

    public void afterLookup(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.storeChildren();
    }

    public void beforeDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeInsert(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String name) {
        for (ContainerRuntimeOption cro : this.getContainerRuntimeOptions()) {
            if (!cro.getName().equals(name)) continue;
            return cro;
        }
        return null;
    }

    public List<ContainerRuntimeOption> getContainerRuntimeOptions() {
        if (this.containerRuntimeOptions == null) {
            this.containerRuntimeOptions = CollectionUtils.createList();
        }
        return this.containerRuntimeOptions;
    }

    public ContainerRuntimeOption addContainerRuntimeOption(String name) {
        if (this.getContainerRuntimeOption(name) != null) {
            throw new IllegalArgumentException("Container runtime option with name: " + name + " already defined");
        }
        ContainerRuntimeOptionImpl cro = new ContainerRuntimeOptionImpl(this, name);
        this.containerRuntimeOptions.add(cro);
        return cro;
    }

    public SecurityRoleRef getSecurityRoleRef(String roleName) {
        for (SecurityRoleRef ref : this.getSecurityRoleRefs()) {
            if (!ref.getRoleName().equals(roleName)) continue;
            return ref;
        }
        return null;
    }

    public List<SecurityRoleRef> getSecurityRoleRefs() {
        if (this.securityRoleRefs == null) {
            this.securityRoleRefs = CollectionUtils.createList();
        }
        return this.securityRoleRefs;
    }

    public SecurityRoleRef addSecurityRoleRef(String roleName) {
        if (this.getSecurityRoleRef(roleName) != null) {
            throw new IllegalArgumentException("Security role reference for role: " + roleName + " already defined");
        }
        SecurityRoleRefImpl srr = new SecurityRoleRefImpl();
        srr.setRoleName(roleName);
        this.securityRoleRefs.add(srr);
        return srr;
    }

    public PortletInfo getPortletInfo() {
        return this.getLanguage(JetspeedLocale.getDefaultLocale());
    }

    public Supports getSupports(String mimeType) {
        for (Supports s : this.getSupports()) {
            if (!s.getMimeType().equals(mimeType)) continue;
            return s;
        }
        return null;
    }

    public List<Supports> getSupports() {
        if (this.supports == null) {
            this.supports = CollectionUtils.createList();
        }
        return this.supports;
    }

    public Supports addSupports(String mimeType) {
        if (this.getSupports(mimeType) != null) {
            throw new IllegalArgumentException("Supports for mime type: " + mimeType + " already defined");
        }
        SupportsImpl s = new SupportsImpl();
        s.setMimeType(mimeType);
        this.supports.add(s);
        return s;
    }

    public List<String> getSupportedLocales() {
        List<Language> languages = this.getLanguages();
        ArrayList<String> locales = new ArrayList<String>();
        for (Language l : languages) {
            if (!l.isSupportedLocale()) continue;
            locales.add(l.getLocale().toString());
        }
        return locales;
    }

    public void addSupportedLocale(String lang) {
    }

    public List<String> getSupportedPublicRenderParameters() {
        if (this.supportedPublicRenderParameters == null) {
            this.supportedPublicRenderParameters = CollectionUtils.createList();
        }
        ArrayList<String> params = new ArrayList<String>();
        for (SupportedPublicRenderParameter param : this.supportedPublicRenderParameters) {
            params.add(param.toString());
        }
        return params;
    }

    public void addSupportedPublicRenderParameter(String identifier) {
        if (this.supportedPublicRenderParameters == null) {
            this.supportedPublicRenderParameters = CollectionUtils.createList();
        }
        for (SupportedPublicRenderParameter param : this.supportedPublicRenderParameters) {
            if (!param.equals(identifier)) continue;
            throw new IllegalArgumentException("Support for public render parameter with identifier: " + identifier + " already defined");
        }
        this.supportedPublicRenderParameters.add(new SupportedPublicRenderParameterImpl(identifier));
    }

    public String getCacheScope() {
        return this.cacheScope != null ? this.cacheScope : "private";
    }

    public void setCacheScope(String cacheScope) {
        this.cacheScope = cacheScope;
    }

    public int getExpirationCache() {
        return this.expirationCache != null ? this.expirationCache : 0;
    }

    public void setExpirationCache(int value) {
        this.expirationCache = new Integer(value);
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = CollectionUtils.createList();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.getDescriptions();
        this.descriptions.add(d);
        return d;
    }

    public DisplayName getDisplayName(Locale locale) {
        return (DisplayName)JetspeedLocale.getBestLocalizedObject(this.getDisplayNames(), (Locale)locale);
    }

    public List<DisplayName> getDisplayNames() {
        if (this.displayNames == null) {
            this.displayNames = CollectionUtils.createList();
        }
        return this.displayNames;
    }

    public DisplayName addDisplayName(String lang) {
        DisplayNameImpl d = new DisplayNameImpl(this, lang);
        for (DisplayName dn : this.getDisplayNames()) {
            if (!dn.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("DisplayName for language: " + d.getLocale() + " already defined");
        }
        this.displayNames.add(d);
        return d;
    }

    public InitParam getInitParam(String name) {
        for (InitParam param : this.getInitParams()) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public List<InitParam> getInitParams() {
        if (this.initParams == null) {
            this.initParams = CollectionUtils.createList();
        }
        return this.initParams;
    }

    public InitParam addInitParam(String paramName) {
        if (this.getInitParam(paramName) != null) {
            throw new IllegalArgumentException("Init parameter: " + paramName + " already defined");
        }
        InitParamImpl param = new InitParamImpl(this, paramName);
        this.getInitParams();
        this.initParams.add(param);
        return param;
    }

    public List<EventDefinitionReference> getSupportedProcessingEvents() {
        if (this.supportedProcessingEvents == null) {
            this.supportedProcessingEvents = CollectionUtils.createList();
        }
        return this.supportedProcessingEvents;
    }

    public EventDefinitionReference addSupportedProcessingEvent(QName qname) {
        List<EventDefinitionReference> refs = this.getSupportedProcessingEvents();
        for (EventDefinitionReference ref : refs) {
            if (!ref.getQName().equals(qname)) continue;
            return ref;
        }
        ProcessingEventReferenceImpl edr = new ProcessingEventReferenceImpl(qname);
        this.supportedProcessingEvents.add(edr);
        return edr;
    }

    public EventDefinitionReference addSupportedProcessingEvent(String name) {
        QName qname = new QName(this.getApplication().getDefaultNamespace(), name);
        return this.addSupportedProcessingEvent(qname);
    }

    public List<EventDefinitionReference> getSupportedPublishingEvents() {
        if (this.supportedPublishingEvents == null) {
            this.supportedPublishingEvents = CollectionUtils.createList();
        }
        return this.supportedPublishingEvents;
    }

    public EventDefinitionReference addSupportedPublishingEvent(QName qname) {
        List<EventDefinitionReference> refs = this.getSupportedPublishingEvents();
        for (EventDefinitionReference ref : refs) {
            if (!ref.getQName().equals(qname)) continue;
            return ref;
        }
        PublishingEventReferenceImpl edr = new PublishingEventReferenceImpl(qname);
        this.supportedPublishingEvents.add(edr);
        return edr;
    }

    public EventDefinitionReference addSupportedPublishingEvent(String name) {
        QName qname = new QName(this.getApplication().getDefaultNamespace(), name);
        return this.addSupportedPublishingEvent(qname);
    }

    public boolean isClone() {
        return this.cloneParent != null;
    }

    public String getCloneParent() {
        return this.cloneParent;
    }
}

