/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.portlet.impl;

import java.util.List;
import java.util.Locale;
import javax.portlet.WindowState;
import org.apache.jetspeed.om.portlet.CustomWindowState;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.impl.DescriptionImpl;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.jetspeed.util.ojb.CollectionUtils;

public class CustomWindowStateImpl
implements CustomWindowState {
    protected String customName;
    protected String mappedName;
    protected List<Description> descriptions;
    protected transient WindowState customState;
    protected transient WindowState mappedState;

    public void setWindowState(String customName) {
        this.customName = customName.toLowerCase();
    }

    public void setMappedName(String mappedName) {
        if (this.mappedName != null || this.mappedState != null) {
            throw new IllegalArgumentException("MappedName already set");
        }
        if (mappedName != null) {
            this.mappedName = mappedName.toLowerCase();
        }
    }

    public WindowState getCustomState() {
        if (this.customState == null) {
            this.customState = new WindowState(this.customName);
        }
        return this.customState;
    }

    public WindowState getMappedState() {
        if (this.mappedState == null) {
            this.mappedState = this.mappedName != null ? new WindowState(this.mappedName) : this.getCustomState();
        }
        return this.mappedState;
    }

    public int hashCode() {
        return this.customName != null ? this.customName.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CustomWindowStateImpl) {
            return this.customName.equals(((CustomWindowStateImpl)object).customName);
        }
        return false;
    }

    public Description getDescription(Locale locale) {
        return (Description)JetspeedLocale.getBestLocalizedObject(this.getDescriptions(), (Locale)locale);
    }

    public List<Description> getDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = CollectionUtils.createList();
        }
        return this.descriptions;
    }

    public Description addDescription(String lang) {
        DescriptionImpl d = new DescriptionImpl(this, lang);
        for (Description desc : this.getDescriptions()) {
            if (!desc.getLocale().equals(d.getLocale())) continue;
            throw new IllegalArgumentException("Description for language: " + d.getLocale() + " already defined");
        }
        this.descriptions.add(d);
        return d;
    }

    public String getWindowState() {
        return this.customName;
    }
}

