/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.jetspeed.descriptor.JetspeedDescriptorService;
import org.apache.jetspeed.om.portlet.CustomWindowState;
import org.apache.jetspeed.om.portlet.Filter;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.PublicRenderParameter;
import org.apache.jetspeed.om.portlet.SecurityConstraint;
import org.apache.jetspeed.om.portlet.SecurityRole;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.om.portlet.impl.CustomPortletModeImpl;
import org.apache.jetspeed.om.portlet.impl.CustomWindowStateImpl;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.CustomPortletMode;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.MetadataType;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.Portlet;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.PortletApp;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.Service;
import org.apache.jetspeed.om.portlet.jetspeed.jaxb.UserAttributeRef;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.pluto.container.PortletAppDescriptorService;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Description;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PortletInfo;
import org.apache.pluto.container.om.portlet.SecurityRoleRef;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JetspeedDescriptorServiceImpl
implements JetspeedDescriptorService {
    private static final String NAMESPACE_PREFIX = "js";
    private PortletAppDescriptorService plutoDescriptorService;
    DocumentBuilderFactory domFactory;

    public JetspeedDescriptorServiceImpl(PortletAppDescriptorService plutoDescriptorService) {
        this.plutoDescriptorService = plutoDescriptorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletApplication read(String name, String contextPath, InputStream webDescriptor, InputStream portletDescriptor, InputStream jetspeedPortletDescriptor, ClassLoader paClassLoader) throws Exception {
        PortletApplicationDefinition pad = this.plutoDescriptorService.read(name, contextPath, portletDescriptor);
        PortletApplication pa = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(paClassLoader);
            pa = this.upgrade(pad);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        this.loadWebDescriptor(pa, webDescriptor);
        if (jetspeedPortletDescriptor != null) {
            this.loadJetspeedPortletDescriptor(pa, jetspeedPortletDescriptor);
        }
        return pa;
    }

    protected void loadWebDescriptor(PortletApplication pa, InputStream webDescriptor) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        NodeList children;
        org.apache.jetspeed.om.portlet.DisplayName d;
        String lang;
        Element element;
        int i;
        int size;
        String prefix;
        if (this.domFactory == null) {
            this.domFactory = DocumentBuilderFactory.newInstance();
            this.domFactory.setNamespaceAware(true);
        }
        DocumentBuilder builder = this.domFactory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = builder.parse(webDescriptor);
        Element root = document.getDocumentElement();
        String namespace = root.getNamespaceURI();
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (namespace != null && namespace.length() > 0) {
            prefix = "js:";
            xpath.setNamespaceContext(new XPathNamespaceContext(NAMESPACE_PREFIX, namespace));
        } else {
            prefix = "";
            xpath.setNamespaceContext(new XPathNamespaceContext(""));
        }
        NodeList nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "display-name", document, XPathConstants.NODESET);
        if (nodes != null) {
            size = nodes.getLength();
            for (i = 0; i < size; ++i) {
                element = (Element)nodes.item(i);
                lang = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                if (lang == null) {
                    lang = "en";
                }
                if ((d = pa.getDisplayName(JetspeedLocale.convertStringToLocale((String)lang))) == null) {
                    d = pa.addDisplayName(lang);
                }
                d.setDisplayName(element.getTextContent().trim());
            }
        }
        if ((nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "description", document, XPathConstants.NODESET)) != null) {
            size = nodes.getLength();
            for (i = 0; i < size; ++i) {
                element = (Element)nodes.item(i);
                lang = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                if (lang == null) {
                    lang = "en";
                }
                if ((d = pa.getDescription(JetspeedLocale.convertStringToLocale((String)lang))) == null) {
                    d = pa.addDescription(lang);
                }
                d.setDescription(element.getTextContent().trim());
            }
        }
        if ((nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "security-role", document, XPathConstants.NODESET)) != null) {
            int nsize = nodes.getLength();
            for (int i2 = 0; i2 < nsize; ++i2) {
                String roleName;
                element = (Element)nodes.item(i2);
                children = element.getElementsByTagName("role-name");
                if (children == null || children.getLength() == 0 || (roleName = children.item(0).getTextContent().trim()).length() <= 0) continue;
                SecurityRole r = null;
                for (SecurityRole sr : pa.getSecurityRoles()) {
                    if (!sr.getName().equals(roleName)) continue;
                    r = sr;
                    break;
                }
                if (r == null) {
                    r = pa.addSecurityRole(roleName);
                }
                if ((children = element.getElementsByTagName("description")) == null) continue;
                int csize = children.getLength();
                for (int j = 0; j < csize; ++j) {
                    element = (Element)children.item(j);
                    String lang2 = element.getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                    if (lang2 == null) {
                        lang2 = "en";
                    }
                    if (r.getDescription(JetspeedLocale.convertStringToLocale((String)lang2)) != null) continue;
                    org.apache.jetspeed.om.portlet.Description d2 = r.addDescription(lang2);
                    d2.setDescription(element.getTextContent());
                }
            }
        }
        if ((nodes = (NodeList)xpath.evaluate("/" + prefix + "web-app/" + prefix + "locale-encoding-mapping-list/" + prefix + "locale-encoding-mapping", document, XPathConstants.NODESET)) != null) {
            int nsize = nodes.getLength();
            for (int i3 = 0; i3 < nsize; ++i3) {
                String encoding;
                String locale;
                element = (Element)nodes.item(i3);
                children = element.getElementsByTagName("locale");
                if (children == null || children.getLength() == 0 || (locale = children.item(0).getTextContent().trim()).length() <= 0 || (children = element.getElementsByTagName("encoding")) == null || children.getLength() == 0 || (encoding = children.item(0).getTextContent().trim()).length() <= 0) continue;
                pa.addLocaleEncodingMapping(JetspeedLocale.convertStringToLocale((String)locale), encoding);
            }
        }
    }

    protected PortletApplication upgrade(PortletApplicationDefinition pa) {
        org.apache.jetspeed.om.portlet.DisplayName jdn;
        Description jdesc;
        PortletApplicationDefinitionImpl jpa = new PortletApplicationDefinitionImpl();
        jpa.setDefaultNamespace(pa.getDefaultNamespace());
        jpa.setResourceBundle(pa.getResourceBundle());
        jpa.setVersion(pa.getVersion());
        for (PortletDefinition pd : pa.getPortlets()) {
            org.apache.jetspeed.om.portlet.PortletDefinition jpd = jpa.addPortlet(pd.getPortletName());
            this.upgradePortlet(jpd, pd);
        }
        for (ContainerRuntimeOption cro : pa.getContainerRuntimeOptions()) {
            org.apache.jetspeed.om.portlet.ContainerRuntimeOption jcro = jpa.addContainerRuntimeOption(cro.getName());
            for (String value : cro.getValues()) {
                jcro.addValue(value);
            }
        }
        for (org.apache.pluto.container.om.portlet.CustomPortletMode cpm : pa.getCustomPortletModes()) {
            org.apache.jetspeed.om.portlet.CustomPortletMode jcpm = jpa.addCustomPortletMode(cpm.getPortletMode());
            jcpm.setPortalManaged(cpm.isPortalManaged());
            for (Description desc : cpm.getDescriptions()) {
                jdesc = jcpm.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        for (org.apache.pluto.container.om.portlet.CustomWindowState cws : pa.getCustomWindowStates()) {
            CustomWindowState jcws = jpa.addCustomWindowState(cws.getWindowState());
            for (Description desc : cws.getDescriptions()) {
                jdesc = jcws.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        for (EventDefinition ed : pa.getEventDefinitions()) {
            org.apache.jetspeed.om.portlet.EventDefinition jed = null;
            jed = ed.getQName() != null ? jpa.addEventDefinition(ed.getQName()) : jpa.addEventDefinition(ed.getName());
            jed.setValueType(ed.getValueType());
            for (QName alias : ed.getAliases()) {
                jed.addAlias(alias);
            }
            for (Description desc : ed.getDescriptions()) {
                jdesc = jed.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        for (FilterMapping fm : pa.getFilterMappings()) {
            org.apache.jetspeed.om.portlet.FilterMapping jfm = jpa.addFilterMapping(fm.getFilterName());
            for (String portletName : fm.getPortletNames()) {
                jfm.addPortletName(portletName);
            }
        }
        for (org.apache.pluto.container.om.portlet.Filter f : pa.getFilters()) {
            Filter jf = jpa.addFilter(f.getFilterName());
            jf.setFilterClass(f.getFilterClass());
            for (Description desc : f.getDescriptions()) {
                jdesc = jf.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
            for (DisplayName dn : f.getDisplayNames()) {
                jdn = jf.addDisplayName(dn.getLang());
                jdn.setDisplayName(dn.getDisplayName());
            }
            for (org.apache.pluto.container.om.portlet.InitParam ip : f.getInitParams()) {
                InitParam jip = jf.addInitParam(ip.getParamName());
                jip.setParamValue(ip.getParamValue());
                for (Description desc : ip.getDescriptions()) {
                    org.apache.jetspeed.om.portlet.Description jdesc2 = jip.addDescription(desc.getLang());
                    jdesc2.setDescription(desc.getDescription());
                }
            }
            for (String lc : f.getLifecycles()) {
                jf.addLifecycle(lc);
            }
        }
        for (Listener l : pa.getListeners()) {
            org.apache.jetspeed.om.portlet.Listener jl = jpa.addListener(l.getListenerClass());
            for (Description desc : l.getDescriptions()) {
                jdesc = jl.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
            for (DisplayName dn : l.getDisplayNames()) {
                jdn = jl.addDisplayName(dn.getLang());
                jdn.setDisplayName(dn.getDisplayName());
            }
        }
        for (org.apache.pluto.container.om.portlet.PublicRenderParameter prd : pa.getPublicRenderParameters()) {
            PublicRenderParameter jprp = null;
            jprp = prd.getQName() != null ? jpa.addPublicRenderParameter(prd.getQName(), prd.getIdentifier()) : jpa.addPublicRenderParameter(prd.getName(), prd.getIdentifier());
            for (QName alias : prd.getAliases()) {
                jprp.addAlias(alias);
            }
            for (Description desc : prd.getDescriptions()) {
                jdesc = jprp.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        for (org.apache.pluto.container.om.portlet.SecurityConstraint sc : pa.getSecurityConstraints()) {
            SecurityConstraint jsc = jpa.addSecurityConstraint(sc.getUserDataConstraint().getTransportGuarantee());
            for (DisplayName dn : sc.getDisplayNames()) {
                jdn = jsc.addDisplayName(dn.getLang());
                jdn.setDisplayName(dn.getDisplayName());
            }
            for (String portletName : sc.getPortletNames()) {
                jsc.addPortletName(portletName);
            }
        }
        for (UserAttribute ua : pa.getUserAttributes()) {
            org.apache.jetspeed.om.portlet.UserAttribute jua = jpa.addUserAttribute(ua.getName());
            for (Description desc : ua.getDescriptions()) {
                jdesc = jua.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        return jpa;
    }

    protected void upgradePortlet(org.apache.jetspeed.om.portlet.PortletDefinition jpd, PortletDefinition pd) {
        jpd.setCacheScope(pd.getCacheScope());
        jpd.setExpirationCache(pd.getExpirationCache());
        jpd.setPortletClass(pd.getPortletClass());
        jpd.setResourceBundle(pd.getResourceBundle());
        jpd.setPreferenceValidatorClassname(pd.getPortletPreferences().getPreferencesValidator());
        for (org.apache.pluto.container.om.portlet.Preference preference : pd.getPortletPreferences().getPortletPreferences()) {
            Preference jpref = jpd.getDescriptorPreferences().addPreference(preference.getName());
            jpref.setReadOnly(preference.isReadOnly());
            for (String value : preference.getValues()) {
                jpref.addValue(value);
            }
        }
        for (ContainerRuntimeOption cro : pd.getContainerRuntimeOptions()) {
            org.apache.jetspeed.om.portlet.ContainerRuntimeOption jcro = jpd.addContainerRuntimeOption(cro.getName());
            for (String value : cro.getValues()) {
                jcro.addValue(value);
            }
        }
        for (Description desc : pd.getDescriptions()) {
            org.apache.jetspeed.om.portlet.Description jdesc = jpd.addDescription(desc.getLang());
            jdesc.setDescription(desc.getDescription());
        }
        for (DisplayName dn : pd.getDisplayNames()) {
            org.apache.jetspeed.om.portlet.DisplayName jdn = jpd.addDisplayName(dn.getLang());
            jdn.setDisplayName(dn.getDisplayName());
        }
        for (org.apache.pluto.container.om.portlet.InitParam ip : pd.getInitParams()) {
            InitParam jip = jpd.addInitParam(ip.getParamName());
            jip.setParamValue(ip.getParamValue());
            for (Description desc : ip.getDescriptions()) {
                org.apache.jetspeed.om.portlet.Description jdesc = jip.addDescription(desc.getLang());
                jdesc.setDescription(desc.getDescription());
            }
        }
        for (SecurityRoleRef srr : pd.getSecurityRoleRefs()) {
            org.apache.jetspeed.om.portlet.SecurityRoleRef jsrr = jpd.addSecurityRoleRef(srr.getRoleName());
            jsrr.setRoleLink(srr.getRoleLink());
        }
        Language defaultLanguage = this.addLanguage(jpd, pd.getPortletInfo(), JetspeedLocale.getDefaultLocale(), false);
        for (String localeString : pd.getSupportedLocales()) {
            Locale locale = JetspeedLocale.convertStringToLocale((String)localeString);
            if (locale.equals(JetspeedLocale.getDefaultLocale())) {
                defaultLanguage.setSupportedLocale(true);
                continue;
            }
            this.addLanguage(jpd, pd.getPortletInfo(), locale, true);
        }
        for (EventDefinitionReference ed : pd.getSupportedProcessingEvents()) {
            if (ed.getQName() != null) {
                jpd.addSupportedProcessingEvent(ed.getQName());
                continue;
            }
            jpd.addSupportedProcessingEvent(ed.getName());
        }
        for (String sprd : pd.getSupportedPublicRenderParameters()) {
            jpd.addSupportedPublicRenderParameter(sprd);
        }
        for (EventDefinitionReference ed : pd.getSupportedPublishingEvents()) {
            if (ed.getQName() != null) {
                jpd.addSupportedPublishingEvent(ed.getQName());
                continue;
            }
            jpd.addSupportedPublishingEvent(ed.getName());
        }
        for (org.apache.pluto.container.om.portlet.Supports supports : pd.getSupports()) {
            Supports jsupports = jpd.addSupports(supports.getMimeType());
            for (String pm : supports.getPortletModes()) {
                jsupports.addPortletMode(pm);
            }
            for (String ws : supports.getWindowStates()) {
                jsupports.addWindowState(ws);
            }
        }
    }

    protected Language addLanguage(org.apache.jetspeed.om.portlet.PortletDefinition jpd, PortletInfo info, Locale locale, boolean supportedLocale) {
        Language l = jpd.addLanguage(locale);
        l.setSupportedLocale(supportedLocale);
        l.setTitle(info.getTitle());
        l.setShortTitle(info.getShortTitle());
        l.setKeywords(info.getKeywords());
        if (locale != null && jpd.getResourceBundle() != null) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(jpd.getResourceBundle(), locale, Thread.currentThread().getContextClassLoader());
                String value = bundle.getString("javax.portlet.title");
                if (value != null && !value.equals("")) {
                    l.setTitle(value);
                }
                if ((value = bundle.getString("javax.portlet.short-title")) != null && !value.equals("")) {
                    l.setShortTitle(value);
                }
                if ((value = bundle.getString("javax.portlet.keywords")) != null && !value.equals("")) {
                    l.setKeywords(value);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return l;
    }

    protected void loadJetspeedPortletDescriptor(PortletApplication app, InputStream in) throws IOException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.apache.jetspeed.om.portlet.jetspeed.jaxb");
            Unmarshaller u = jc.createUnmarshaller();
            PortletApp pa = (PortletApp)u.unmarshal(in);
            app.setJetspeedSecurityConstraint(pa.getSecurityConstraintRef());
            for (Service s : pa.getServices()) {
                app.addJetspeedServiceReference(s.getName());
            }
            for (MetadataType m : pa.getMetadata()) {
                if (m.getContent() == null) continue;
                app.getMetadata().addField(JetspeedLocale.convertStringToLocale((String)m.getLang()), m.getMetadataName(), m.getContent());
            }
            for (Portlet p : pa.getPortlets()) {
                org.apache.jetspeed.om.portlet.PortletDefinition pd = app.getPortlet(p.getPortletName());
                if (pd == null) continue;
                pd.setJetspeedSecurityConstraint(p.getSecurityConstraintRef());
                for (MetadataType m : p.getMetadata()) {
                    if (m.getContent() == null) continue;
                    pd.getMetadata().addField(JetspeedLocale.convertStringToLocale((String)m.getLang()), m.getMetadataName(), m.getContent());
                }
            }
            for (CustomPortletMode cpm : pa.getCustomPortletModes()) {
                org.apache.jetspeed.om.portlet.CustomPortletMode jcpm;
                if (cpm.getName() == null || cpm.getMappedName() == null || cpm.getName().equals(cpm.getMappedName()) || (jcpm = app.getCustomPortletMode(cpm.getMappedName())) == null || app.getCustomPortletMode(cpm.getName()) != null) continue;
                ((CustomPortletModeImpl)jcpm).setMappedName(cpm.getMappedName());
            }
            for (org.apache.jetspeed.om.portlet.jetspeed.jaxb.CustomWindowState cws : pa.getCustomWindowStates()) {
                CustomWindowState jcws;
                if (cws.getName() == null || cws.getMappedName() == null || cws.getName().equals(cws.getMappedName()) || (jcws = app.getCustomWindowState(cws.getMappedName())) == null || app.getCustomWindowState(cws.getName()) != null) continue;
                ((CustomWindowStateImpl)jcws).setMappedName(cws.getMappedName());
            }
            for (UserAttributeRef ref : pa.getUserAttributeRefs()) {
                org.apache.jetspeed.om.portlet.UserAttributeRef jref = app.addUserAttributeRef(ref.getName());
                jref.setNameLink(ref.getNameLink());
                org.apache.jetspeed.om.portlet.Description desc = jref.addDescription("en");
                desc.setDescription(ref.getDescription());
            }
        }
        catch (JAXBException je) {
            throw new IOException(je.getMessage());
        }
    }

    private static class XPathNamespaceContext
    implements NamespaceContext {
        private String namespaceURI;
        private String prefix;

        public XPathNamespaceContext(String prefix) {
            this(prefix, "http://www.w3.org/XML/1998/namespace");
        }

        public XPathNamespaceContext(String prefix, String namespaceURI) {
            this.prefix = prefix;
            this.namespaceURI = namespaceURI;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if (this.prefix.equals(prefix)) {
                return this.namespaceURI;
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            throw new UnsupportedOperationException();
        }

        public Iterator getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException();
        }
    }
}

