/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

public class PortletRegistryHelper {
    public static String parseAppName(String uniqueName) {
        int split = PortletRegistryHelper.splitUniqueName(uniqueName);
        return uniqueName.substring(0, split);
    }

    public static String parsePortletName(String uniqueName) {
        int split = PortletRegistryHelper.splitUniqueName(uniqueName);
        return uniqueName.substring(split + 2, uniqueName.length());
    }

    private static int splitUniqueName(String uniqueName) {
        int split = 0;
        if (null != uniqueName) {
            split = uniqueName.indexOf("::");
        }
        if (split < 1) {
            throw new IllegalArgumentException("The unique portlet name, \"" + uniqueName + "\";  is not well formed.  No " + "::" + " delimiter was found.");
        }
        return split;
    }

    public static String makeUniqueName(String appName, String portletName) {
        return appName + "::" + portletName;
    }
}

