/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.portletregistry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.components.dao.InitablePersistenceBrokerDaoSupport;
import org.apache.jetspeed.components.portletpreferences.PortletPreferencesProvider;
import org.apache.jetspeed.components.portletregistry.FailedToStorePortletDefinitionException;
import org.apache.jetspeed.components.portletregistry.PortletApplicationProxyImpl;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.PortletRegistryHelper;
import org.apache.jetspeed.components.portletregistry.RegistryApplicationCache;
import org.apache.jetspeed.components.portletregistry.RegistryCacheObjectWrapper;
import org.apache.jetspeed.components.portletregistry.RegistryEventListener;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.components.portletregistry.RegistryPortletCache;
import org.apache.jetspeed.om.common.Support;
import org.apache.jetspeed.om.portlet.ContainerRuntimeOption;
import org.apache.jetspeed.om.portlet.Description;
import org.apache.jetspeed.om.portlet.DisplayName;
import org.apache.jetspeed.om.portlet.EventDefinitionReference;
import org.apache.jetspeed.om.portlet.InitParam;
import org.apache.jetspeed.om.portlet.Language;
import org.apache.jetspeed.om.portlet.LocalizedField;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Preference;
import org.apache.jetspeed.om.portlet.Preferences;
import org.apache.jetspeed.om.portlet.SecurityRoleRef;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.om.portlet.impl.PortletApplicationDefinitionImpl;
import org.apache.jetspeed.om.portlet.impl.PortletDefinitionImpl;
import org.apache.jetspeed.search.SearchEngine;
import org.apache.jetspeed.util.JetspeedLocale;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceBrokerPortletRegistry
extends InitablePersistenceBrokerDaoSupport
implements PortletRegistry,
JetspeedCacheEventListener {
    public static final String PORTLET_UNIQUE_NAME_SEPARATOR = "::";
    protected JetspeedCache applicationOidCache = null;
    protected JetspeedCache portletOidCache = null;
    protected JetspeedCache applicationNameCache = null;
    protected JetspeedCache portletNameCache = null;
    protected List<RegistryEventListener> listeners = new ArrayList<RegistryEventListener>();
    protected PortletPreferencesProvider preferenceService;
    protected SearchEngine searchEngine;

    public PersistenceBrokerPortletRegistry(String repositoryPath, PortletPreferencesProvider preferenceService) {
        this(repositoryPath, null, null, null, null, preferenceService, null);
    }

    public PersistenceBrokerPortletRegistry(String repositoryPath, JetspeedCache applicationOidCache, JetspeedCache portletOidCache, JetspeedCache applicationNameCache, JetspeedCache portletNameCache, PortletPreferencesProvider preferenceService) {
        this(repositoryPath, applicationOidCache, portletOidCache, applicationNameCache, portletNameCache, preferenceService, null);
    }

    public PersistenceBrokerPortletRegistry(String repositoryPath, JetspeedCache applicationOidCache, JetspeedCache portletOidCache, JetspeedCache applicationNameCache, JetspeedCache portletNameCache, PortletPreferencesProvider preferenceService, SearchEngine search) {
        super(repositoryPath);
        this.applicationOidCache = applicationOidCache;
        this.portletOidCache = portletOidCache;
        this.applicationNameCache = applicationNameCache;
        this.portletNameCache = portletNameCache;
        PortletApplicationProxyImpl.setRegistry(this);
        RegistryApplicationCache.cacheInit(this, applicationOidCache, applicationNameCache, this.listeners);
        RegistryPortletCache.cacheInit(this, portletOidCache, portletNameCache, this.listeners);
        this.applicationNameCache.addEventListener((JetspeedCacheEventListener)this, false);
        this.portletNameCache.addEventListener((JetspeedCacheEventListener)this, false);
        this.preferenceService = preferenceService;
        this.searchEngine = search;
    }

    public Collection<PortletDefinition> getAllPortletDefinitions() {
        Criteria c = new Criteria();
        c.addIsNull("cloneParent");
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public Collection<PortletDefinition> getAllDefinitions() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public Collection<PortletDefinition> getAllCloneDefinitions() {
        Criteria c = new Criteria();
        c.addNotNull("cloneParent");
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public PortletApplication getPortletApplication(String name) {
        return this.getPortletApplication(name, false);
    }

    public PortletApplication getPortletApplication(String name, boolean fromCache) {
        CacheElement cacheElement;
        if (fromCache && (cacheElement = this.applicationNameCache.get((Object)name)) != null && (cacheElement = this.applicationOidCache.get((Object)((RegistryCacheObjectWrapper)cacheElement.getContent()).getId())) != null) {
            return (PortletApplication)cacheElement.getContent();
        }
        Criteria c = new Criteria();
        c.addEqualTo("name", (Object)name);
        PortletApplication app = (PortletApplication)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(PortletApplicationDefinitionImpl.class, (Criteria)c));
        this.postLoad(app);
        return app;
    }

    public Collection<PortletApplication> getPortletApplications() {
        Criteria c = new Criteria();
        Collection list = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletApplicationDefinitionImpl.class, (Criteria)c));
        this.postLoadColl(list);
        return list;
    }

    public PortletDefinition getPortletDefinitionByUniqueName(String name) {
        return this.getPortletDefinitionByUniqueName(name, false);
    }

    public PortletDefinition getPortletDefinitionByUniqueName(String name, boolean fromCache) {
        CacheElement cacheElement;
        if (fromCache && (cacheElement = this.portletNameCache.get((Object)name)) != null && (cacheElement = this.portletOidCache.get((Object)((RegistryCacheObjectWrapper)cacheElement.getContent()).getId())) != null) {
            return (PortletDefinition)cacheElement.getContent();
        }
        String appName = PortletRegistryHelper.parseAppName(name);
        String portletName = PortletRegistryHelper.parsePortletName(name);
        Criteria c = new Criteria();
        c.addEqualTo("app.name", (Object)appName);
        c.addEqualTo("portletName", (Object)portletName);
        PortletDefinition def = (PortletDefinition)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        if (def != null && def.getApplication() == null) {
            String msg = "getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.";
            throw new IllegalStateException("getPortletDefinitionByIdentifier() returned a PortletDefinition that has no parent PortletApplication.");
        }
        this.postLoad(def);
        return def;
    }

    public boolean portletApplicationExists(String name) {
        return this.getPortletApplication(name, true) != null;
    }

    public boolean portletDefinitionExists(String portletName, PortletApplication app) {
        return this.getPortletDefinitionByUniqueName(app.getName() + PORTLET_UNIQUE_NAME_SEPARATOR + portletName) != null;
    }

    public void registerPortletApplication(PortletApplication newApp) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)newApp);
        this.preferenceService.storeDefaults(newApp);
        this.restoreClones(newApp);
    }

    public void removeApplication(PortletApplication app) throws RegistryException {
        this.getPersistenceBrokerTemplate().delete((Object)app);
        this.preferenceService.removeDefaults(app);
    }

    public void updatePortletApplication(PortletApplication app) throws RegistryException {
        this.getPersistenceBrokerTemplate().store((Object)app);
    }

    private void postLoad(Object obj) {
        if (obj != null && obj instanceof Support) {
            try {
                ((Support)obj).postLoad(obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void postLoadColl(Collection coll) {
        Iterator itr;
        Object test;
        if (coll != null && !coll.isEmpty() && (test = (itr = coll.iterator()).next()) instanceof Support) {
            Support testSupport = (Support)test;
            try {
                testSupport.postLoad((Object)testSupport);
            }
            catch (Exception e1) {
                // empty catch block
            }
            while (itr.hasNext()) {
                Support support = (Support)itr.next();
                try {
                    support.postLoad((Object)support);
                }
                catch (Exception e) {}
            }
        }
    }

    public void savePortletDefinition(PortletDefinition portlet) throws FailedToStorePortletDefinitionException {
        try {
            this.getPersistenceBrokerTemplate().store((Object)portlet);
            portlet.storeChildren();
        }
        catch (DataAccessException e) {
            throw new FailedToStorePortletDefinitionException(portlet, (Throwable)e);
        }
    }

    public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
    }

    public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
        block4: {
            PortletApplication pa;
            block3: {
                PortletDefinition pd;
                if (cache != this.portletNameCache) break block3;
                RegistryPortletCache.cacheRemoveQuiet((String)key, (RegistryCacheObjectWrapper)element);
                if (this.listeners == null || this.listeners.isEmpty() || (pd = this.getPortletDefinitionByUniqueName((String)key)) == null) break block4;
                for (int ix = 0; ix < this.listeners.size(); ++ix) {
                    RegistryEventListener listener = this.listeners.get(ix);
                    listener.portletRemoved(pd);
                }
                break block4;
            }
            RegistryApplicationCache.cacheRemoveQuiet((String)key, (RegistryCacheObjectWrapper)element);
            if (this.listeners != null && !this.listeners.isEmpty() && (pa = this.getPortletApplication((String)key)) != null) {
                for (int ix = 0; ix < this.listeners.size(); ++ix) {
                    RegistryEventListener listener = this.listeners.get(ix);
                    listener.applicationRemoved(pa);
                }
            }
        }
    }

    public void addRegistryListener(RegistryEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRegistryEventListener(RegistryEventListener listener) {
        this.listeners.remove(listener);
    }

    public PortletDefinition clonePortletDefinition(PortletDefinition source, String newPortletName) throws FailedToStorePortletDefinitionException {
        if (this.portletDefinitionExists(newPortletName, source.getApplication())) {
            throw new FailedToStorePortletDefinitionException("Cannot clone to portlet named " + newPortletName + ", name already exists");
        }
        PortletDefinition copy = source.getApplication().addClone(newPortletName);
        PortletApplication destApp = source.getApplication();
        DisplayName displayName = copy.addDisplayName(JetspeedLocale.getDefaultLocale().getLanguage());
        displayName.setDisplayName(newPortletName);
        copy.setPortletClass(source.getPortletClass());
        copy.setResourceBundle(source.getResourceBundle());
        copy.setPreferenceValidatorClassname(source.getPreferenceValidatorClassname());
        copy.setExpirationCache(source.getExpirationCache());
        copy.setCacheScope(source.getCacheScope());
        for (LocalizedField field : source.getMetadata().getFields()) {
            copy.getMetadata().addField(field.getLocale(), field.getName(), field.getValue());
        }
        copy.setJetspeedSecurityConstraint(source.getJetspeedSecurityConstraint());
        for (Description desc : source.getDescriptions()) {
            Description copyDesc = copy.addDescription(desc.getLang());
            copyDesc.setDescription(desc.getDescription());
        }
        for (InitParam initParam : source.getInitParams()) {
            InitParam copyInitParam = copy.addInitParam(initParam.getParamName());
            copyInitParam.setParamValue(initParam.getParamValue());
            for (Description desc : initParam.getDescriptions()) {
                Description copyDesc = copyInitParam.addDescription(desc.getLang());
                copyDesc.setDescription(desc.getDescription());
            }
        }
        InitParam parentPortlet = copy.getInitParam("cloneParentPortlet");
        if (parentPortlet == null) {
            parentPortlet = copy.addInitParam("cloneParentPortlet");
        }
        parentPortlet.setParamValue(source.getPortletName());
        for (EventDefinitionReference eventDefRef : source.getSupportedProcessingEvents()) {
            copy.addSupportedProcessingEvent(eventDefRef.getQName());
        }
        for (EventDefinitionReference eventDefRef : source.getSupportedPublishingEvents()) {
            copy.addSupportedPublishingEvent(eventDefRef.getQName());
        }
        for (SecurityRoleRef secRoleRef : source.getSecurityRoleRefs()) {
            SecurityRoleRef copySecRoleRef = copy.addSecurityRoleRef(secRoleRef.getRoleName());
            copySecRoleRef.setRoleLink(secRoleRef.getRoleLink());
            for (Description desc : secRoleRef.getDescriptions()) {
                Description copyDesc = copySecRoleRef.addDescription(desc.getLang());
                copyDesc.setDescription(desc.getDescription());
            }
        }
        for (Supports supports : source.getSupports()) {
            Supports copySupports = copy.addSupports(supports.getMimeType());
            for (String portletMode : supports.getPortletModes()) {
                copySupports.addPortletMode(portletMode);
            }
            for (String windowState : supports.getWindowStates()) {
                copySupports.addWindowState(windowState);
            }
        }
        for (Language language : source.getLanguages()) {
            Language copyLanguage = copy.addLanguage(language.getLocale());
            copyLanguage.setTitle(language.getTitle());
            copyLanguage.setShortTitle(language.getShortTitle());
            copyLanguage.setKeywords(language.getKeywords());
            copyLanguage.setSupportedLocale(language.isSupportedLocale());
        }
        for (ContainerRuntimeOption runtimeOption : source.getContainerRuntimeOptions()) {
            ContainerRuntimeOption copyRuntimeOption = copy.addContainerRuntimeOption(runtimeOption.getName());
            for (String value : runtimeOption.getValues()) {
                copyRuntimeOption.addValue(value);
            }
        }
        copy.getSupportedPublicRenderParameters().addAll(source.getSupportedPublicRenderParameters());
        try {
            this.updatePortletApplication(destApp);
        }
        catch (RegistryException e) {
            throw new FailedToStorePortletDefinitionException((Throwable)e);
        }
        for (Preference pref : source.getPortletPreferences().getPortletPreferences()) {
            Preference copyPref = copy.addDescriptorPreference(pref.getName());
            copyPref.setReadOnly(pref.isReadOnly());
            for (String value : pref.getValues()) {
                copyPref.addValue(value);
            }
        }
        try {
            this.preferenceService.storeDefaults(copy, (Preferences)null);
        }
        catch (Throwable e) {
            destApp.getClones().remove(copy);
            throw new FailedToStorePortletDefinitionException(e);
        }
        PortletDefinition pd = this.getPortletDefinitionByUniqueName(PortletRegistryHelper.makeUniqueName(source.getApplication().getName(), newPortletName));
        PortletApplication pa = pd.getApplication();
        if (this.searchEngine != null) {
            this.searchEngine.remove((Object)pa);
            this.searchEngine.remove((Collection)pa.getPortlets());
            this.searchEngine.remove((Collection)pa.getClones());
            this.searchEngine.add((Object)pa);
            this.searchEngine.add((Collection)pa.getPortlets());
            this.searchEngine.add((Collection)pa.getClones());
        }
        return pd;
    }

    public int restoreClones(PortletApplication pa) throws RegistryException {
        int count = 0;
        Criteria criteria = new Criteria();
        criteria.addEqualTo("cloneParent", (Object)pa.getName());
        Collection clones = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)criteria));
        for (PortletDefinitionImpl pd : clones) {
            if (!pd.isClone() || !pa.getName().equals(pd.getCloneParent())) continue;
            pd.setApplication(pa);
            pa.getClones().add(pd);
            ++count;
        }
        if (count > 0) {
            this.updatePortletApplication(pa);
        }
        return count;
    }

    public void removeClone(PortletDefinition clone) throws RegistryException {
        if (!clone.isClone()) {
            throw new IllegalArgumentException("The portlet is not a cloned one: " + clone.getUniqueName());
        }
        PortletApplication pa = clone.getApplication();
        this.getPersistenceBrokerTemplate().delete((Object)clone);
        pa.getClones().remove(clone);
        this.updatePortletApplication(pa);
    }

    public void removeAllClones(PortletApplication pa) throws RegistryException {
        Criteria c = new Criteria();
        c.addEqualTo("cloneParent", (Object)pa.getName());
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)QueryFactory.newQuery(PortletDefinitionImpl.class, (Criteria)c));
        pa.getClones().clear();
        this.updatePortletApplication(pa);
    }
}

