/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.ojb;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.collections.IRemovalAwareCollection;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;
import org.apache.ojb.broker.util.collections.RemovalAwareList;

public class CollectionUtils {
    public static <T> Collection<T> createCollection() {
        return new RemovalAwareCollection();
    }

    public static <T> Collection<T> createSynchronizedCollection() {
        return new SynchronizedRemovalAwareCollection();
    }

    public static <T> List<T> createList() {
        return new RemovalAwareList();
    }

    public static <T> List<T> createSynchronizedList() {
        return new SynchronizedRemovalAwareList();
    }

    public static class SynchronizedRemovalAwareList<T>
    implements List<T>,
    ManageableCollection,
    IRemovalAwareCollection {
        private static final long serialVersionUID = 1L;
        private RemovalAwareList list = new RemovalAwareList();

        @Override
        public synchronized void add(int index, T element) {
            this.list.add(index, element);
        }

        @Override
        public synchronized boolean add(T e) {
            return this.list.add(e);
        }

        @Override
        public synchronized boolean addAll(Collection<? extends T> c) {
            return this.list.addAll(c);
        }

        @Override
        public synchronized boolean addAll(int index, Collection c) {
            return this.list.addAll(index, c);
        }

        @Override
        public synchronized void clear() {
            this.list.clear();
        }

        @Override
        public synchronized boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public synchronized boolean containsAll(Collection c) {
            return this.list.containsAll(c);
        }

        @Override
        public synchronized T get(int index) {
            return (T)this.list.get(index);
        }

        @Override
        public synchronized int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public synchronized Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public synchronized int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public synchronized ListIterator<T> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public synchronized ListIterator<T> listIterator(int index) {
            return this.list.listIterator(index);
        }

        @Override
        public synchronized T remove(int index) {
            return (T)this.list.remove(index);
        }

        @Override
        public synchronized boolean remove(Object o) {
            return this.list.remove(o);
        }

        @Override
        public synchronized boolean removeAll(Collection c) {
            return this.list.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(Collection c) {
            return this.list.retainAll(c);
        }

        @Override
        public synchronized T set(int index, T element) {
            return (T)this.list.set(index, element);
        }

        @Override
        public synchronized int size() {
            return this.list.size();
        }

        @Override
        public synchronized List<T> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        @Override
        public synchronized T[] toArray() {
            return this.list.toArray();
        }

        @Override
        public synchronized <A> A[] toArray(A[] a) {
            return this.list.toArray((Object[])a);
        }

        public synchronized void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
            this.list.afterStore(broker);
        }

        public synchronized void ojbAdd(Object anObject) {
            this.list.ojbAdd(anObject);
        }

        public synchronized void ojbAddAll(ManageableCollection otherCollection) {
            this.list.ojbAddAll(otherCollection);
        }

        public synchronized Iterator ojbIterator() {
            return this.list.ojbIterator();
        }
    }

    public static class SynchronizedRemovalAwareCollection<T>
    implements Collection<T>,
    ManageableCollection,
    IRemovalAwareCollection {
        private static final long serialVersionUID = 1L;
        private RemovalAwareCollection collection = new RemovalAwareCollection();

        @Override
        public synchronized boolean add(T e) {
            return this.collection.add(e);
        }

        @Override
        public synchronized boolean addAll(Collection<? extends T> c) {
            return this.collection.addAll(c);
        }

        @Override
        public synchronized void clear() {
            this.collection.clear();
        }

        @Override
        public synchronized boolean contains(Object o) {
            return this.collection.contains(o);
        }

        @Override
        public synchronized boolean containsAll(Collection c) {
            return this.collection.containsAll(c);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public synchronized Iterator<T> iterator() {
            return this.collection.iterator();
        }

        @Override
        public synchronized boolean remove(Object o) {
            return this.collection.remove(o);
        }

        @Override
        public synchronized boolean removeAll(Collection c) {
            return this.collection.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(Collection c) {
            return this.collection.retainAll(c);
        }

        @Override
        public synchronized int size() {
            return this.collection.size();
        }

        @Override
        public synchronized T[] toArray() {
            return this.collection.toArray();
        }

        @Override
        public synchronized <A> A[] toArray(A[] a) {
            return this.collection.toArray((Object[])a);
        }

        public synchronized void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
            this.collection.afterStore(broker);
        }

        public synchronized void ojbAdd(Object anObject) {
            this.collection.ojbAdd(anObject);
        }

        public synchronized void ojbAddAll(ManageableCollection otherCollection) {
            this.collection.ojbAddAll(otherCollection);
        }

        public synchronized Iterator ojbIterator() {
            return this.collection.ojbIterator();
        }
    }
}

