/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.rdbms.ojb;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryManagedImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.ConnectionPoolDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcMetadataUtils;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.util.ClassHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class ConnectionRepositoryEntry
extends BasicDataSource
implements BeanNameAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ConnectionRepositoryEntry.class);
    private String jcdAlias = null;
    private String platform = null;
    private String connectionFactoryClass = null;
    private String jndiName = null;
    private String driverClassName = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private boolean jetspeedEngineScoped = true;
    private DataSource externalDs;

    public void setBeanName(String beanName) {
        if (this.jcdAlias == null) {
            this.jcdAlias = beanName;
        }
    }

    public String getJcdAlias() {
        return this.jcdAlias;
    }

    public void setJcdAlias(String jcdAlias) {
        this.jcdAlias = jcdAlias;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        super.setDriverClassName(driverClassName);
        this.driverClassName = driverClassName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        super.setPassword(password);
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        super.setUrl(url);
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        super.setUsername(username);
        this.username = username;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean isJetspeedEngineScoped() {
        return this.jetspeedEngineScoped;
    }

    public void setJetspeedEngineScoped(boolean jetspeedEngineScoped) {
        this.jetspeedEngineScoped = jetspeedEngineScoped;
    }

    public void afterPropertiesSet() throws Exception {
        ConnectionRepository cr = MetadataManager.getInstance().connectionRepository();
        JdbcConnectionDescriptor jcd = cr.getDescriptor(new PBKey(this.jcdAlias));
        if (jcd == null) {
            jcd = new JdbcConnectionDescriptor();
            jcd.setJcdAlias(this.jcdAlias);
            cr.addDescriptor(jcd);
        }
        if (this.platform != null && this.platform.length() == 0) {
            this.platform = null;
        }
        Object ds = null;
        JdbcMetadataUtils jdbcMetadataUtils = new JdbcMetadataUtils();
        if (this.jndiName != null) {
            if (this.connectionFactoryClass == null) {
                this.connectionFactoryClass = ConnectionFactoryManagedImpl.class.getName();
            }
            InitialContext initialContext = new InitialContext();
            this.externalDs = ds = (DataSource)initialContext.lookup(this.jndiName);
            jcd.setDatasourceName(this.jndiName);
        } else {
            if (this.connectionFactoryClass == null) {
                this.connectionFactoryClass = ConnectionFactoryDBCPImpl.class.getName();
            }
            jcd.setDriver(this.driverClassName);
            HashMap conData = jdbcMetadataUtils.parseConnectionUrl(this.url);
            jcd.setDbms(this.platform);
            jcd.setProtocol((String)conData.get("protocol"));
            jcd.setSubProtocol((String)conData.get("subprotocol"));
            jcd.setDbAlias((String)conData.get("dbAlias"));
            jcd.setUserName(this.username);
            jcd.setPassWord(this.password);
            ds = this;
        }
        ConnectionPoolDescriptor cpd = jcd.getConnectionPoolDescriptor();
        if (cpd == null) {
            cpd = new ConnectionPoolDescriptor();
            jcd.setConnectionPoolDescriptor(cpd);
        }
        Class conFacCls = ClassHelper.getClass((String)this.connectionFactoryClass);
        cpd.setConnectionFactory(conFacCls);
        jdbcMetadataUtils.fillJCDFromDataSource(jcd, ds, null, null);
        if (this.platform == null && "Oracle".equals(jcd.getDbms())) {
            this.updateOraclePlatform(jcd, (DataSource)ds);
        }
        if (this.platform != null) {
            if (!this.platform.equals(jcd.getDbms())) {
                log.warn("Automatically derived RDBMS platform \"" + jcd.getDbms() + "\" differs from explicitly set platform \"" + this.platform + "\"");
            }
            jcd.setDbms(this.platform);
        } else {
            this.platform = jcd.getDbms();
        }
        jcd.addAttribute("org.apache.jetspeed.engineScoped", Boolean.toString(this.jetspeedEngineScoped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateOraclePlatform(JdbcConnectionDescriptor jcd, DataSource ds) throws LookupException, IllegalAccessException, InstantiationException, SQLException {
        con = null;
        try {
            con = ds.getConnection();
            metaData = con.getMetaData();
            rdbmsVersion = 0;
            try {
                rdbmsVersion = metaData.getDatabaseMajorVersion();
                ** GOTO lbl36
            }
            catch (Throwable t) {
                dbVersion = metaData.getDatabaseProductVersion();
                relKey = "Release";
                major = dbVersion;
                startPos = dbVersion.indexOf(relKey);
                if (startPos < 0) {
                    ConnectionRepositoryEntry.log.warn("Cannot determine Oracle version, no \"Release\" in procuct version: \"" + dbVersion + "\"");
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                dotPos = dbVersion.indexOf(46, startPos += relKey.length());
                if (dotPos > 0) {
                    major = dbVersion.substring(startPos, dotPos).trim();
                }
                try {
                    rdbmsVersion = Integer.parseInt(major);
                }
                catch (NumberFormatException e) {
                    ConnectionRepositoryEntry.log.warn("Cannot determine Oracle version, product version \"" + dbVersion + "\" not layed out as \"... Release N.M.....\"");
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                if (ConnectionRepositoryEntry.log.isDebugEnabled()) {
                    ConnectionRepositoryEntry.log.debug("Extracted Oracle major version " + rdbmsVersion + " from product version \"" + dbVersion + "\"");
                }
lbl36:
                // 4 sources

                if (rdbmsVersion >= 9) {
                    jcd.setDbms("Oracle9i");
                }
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.externalDs != null) {
            return this.externalDs.getConnection();
        }
        return super.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.externalDs != null) {
            return this.externalDs.getConnection(username, password);
        }
        return super.getConnection(username, password);
    }

    public class MinimalDataSource
    implements DataSource {
        private JdbcConnectionDescriptor jcd = null;

        public MinimalDataSource(JdbcConnectionDescriptor jcd) {
            this.jcd = jcd;
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.getConnection().isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.getConnection().unwrap(iface);
        }

        @Override
        public Connection getConnection() throws SQLException {
            try {
                ClassHelper.getClass((String)this.jcd.getDriver(), (boolean)true);
                String url = this.jcd.getProtocol() + ":" + this.jcd.getSubProtocol() + ":" + this.jcd.getDbAlias();
                if (this.jcd.getUserName() == null) {
                    return DriverManager.getConnection(url);
                }
                return DriverManager.getConnection(url, this.jcd.getUserName(), this.jcd.getPassWord());
            }
            catch (ClassNotFoundException e) {
                throw (IllegalStateException)new IllegalStateException(e.getMessage()).initCause(e);
            }
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.getConnection();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }
    }
}

