/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util.ojb;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVtoCollectionFieldConversion
implements FieldConversion {
    private static final String DELIM = ",";
    private static final String QUOTE = "\"";
    private static final Logger log = LoggerFactory.getLogger(CSVtoCollectionFieldConversion.class);

    public Object javaToSql(Object arg0) throws ConversionException {
        if (arg0 instanceof Collection) {
            Collection col = (Collection)arg0;
            if (col.size() == 0) {
                return "";
            }
            Iterator itr = col.iterator();
            StringBuffer buffer = new StringBuffer(col.size() * 5);
            while (itr.hasNext()) {
                buffer.append(QUOTE);
                String value = this.getNext(itr);
                if (value != null && value.toString().indexOf(QUOTE) >= 0) {
                    log.warn("In CSVtoCollectionFieldConversion() - The string '" + value + "' contains embeded '\"'.  It will not be converted to a CSV correctly.");
                }
                buffer.append(value);
                buffer.append(QUOTE);
                if (!itr.hasNext()) continue;
                buffer.append(DELIM);
            }
            return buffer.toString();
        }
        return arg0;
    }

    public Object sqlToJava(Object arg0) throws ConversionException {
        if (arg0 instanceof String) {
            StringReader sr = new StringReader((String)arg0);
            StreamTokenizer st = new StreamTokenizer(sr);
            st.resetSyntax();
            st.whitespaceChars(44, 44);
            st.quoteChar(34);
            st.eolIsSignificant(false);
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                while (st.nextToken() != -1) {
                    list.add(this.createObject(st.sval));
                }
            }
            catch (IOException e) {
                String message = "CSV parsing failed during field conversion.";
                log.error(message, (Throwable)e);
                throw new ConversionException("CSV parsing failed during field conversion.", (Throwable)e);
            }
            return list;
        }
        return arg0;
    }

    protected Object createObject(String name) {
        return name;
    }

    protected String getNext(Iterator iterator) {
        return (String)iterator.next();
    }
}

