/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jetspeed.components.jndi.JNDIComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tyrex.naming.MemoryContext;
import tyrex.tm.RuntimeContext;

public class TyrexJNDIComponent
implements JNDIComponent {
    private static final Logger log = LoggerFactory.getLogger(TyrexJNDIComponent.class);
    private MemoryContext rootJNDIContext;

    public TyrexJNDIComponent() throws NamingException {
        Context ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "tyrex.naming.MemoryContextFactory");
        this.rootJNDIContext = new MemoryContext(null);
        this.rootJNDIContext.createSubcontext("jdbc");
        ctx = this.rootJNDIContext.createSubcontext("comp");
        ctx = ctx.createSubcontext("env");
        ctx = ctx.createSubcontext("jdbc");
        this.bindToCurrentThread();
        log.info("JNDI successfully initiallized");
    }

    public Context getRootContext() {
        return this.rootJNDIContext;
    }

    public void bindToCurrentThread() throws NamingException {
        RuntimeContext runCtx = RuntimeContext.newRuntimeContext((Context)this.rootJNDIContext, null);
        RuntimeContext.setRuntimeContext((RuntimeContext)runCtx);
    }

    public void bindObject(String bindToName, Object obj) throws NamingException {
        log.debug("Binding " + obj + " to name " + bindToName);
        Context ctx = this.getRootContext();
        ctx.bind(bindToName, obj);
    }

    public void unbindFromCurrentThread() throws NamingException {
        RuntimeContext.unsetRuntimeContext();
        RuntimeContext.cleanup((Thread)Thread.currentThread());
    }

    public void unbindObject(String name) throws NamingException {
        log.debug("Unbinding name " + name);
        Context ctx = this.getRootContext();
        ctx.unbind(name);
    }
}

