/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;

public class HostnameCriterionResolver
extends StandardResolver
implements RuleCriterionResolver {
    private static final long serialVersionUID = 1L;
    private boolean useDotPrefix;
    private List<Rule> hostnameMappingRules;

    public HostnameCriterionResolver(boolean usePrefix) {
        this.useDotPrefix = usePrefix;
    }

    public HostnameCriterionResolver(List<Rule> hostnameMappingRules) {
        this.hostnameMappingRules = hostnameMappingRules;
    }

    @Override
    public boolean isControl(RuleCriterion criterion) {
        return true;
    }

    @Override
    public boolean isNavigation(RuleCriterion criterion) {
        return false;
    }

    @Override
    public String resolve(RequestContext context, RuleCriterion criterion) {
        String serverName = context.getRequest().getServerName();
        if (this.useDotPrefix) {
            int idx = serverName.indexOf(".");
            if (idx != -1) {
                serverName = serverName.substring(0, idx);
            }
        } else if (this.hostnameMappingRules != null) {
            for (Rule rule : this.hostnameMappingRules) {
                serverName = rule.map(serverName);
            }
        }
        return serverName;
    }

    public static class Rule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String replacement;
        private Pattern compiledPattern;

        public Rule(String pattern, String replacement) {
            this.replacement = replacement;
            this.compiledPattern = Pattern.compile(pattern);
        }

        public String map(String hostname) {
            Matcher patternMatcher = this.compiledPattern.matcher(hostname);
            if (patternMatcher.find()) {
                return patternMatcher.replaceAll(this.replacement);
            }
            return hostname;
        }
    }
}

