/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import javax.security.auth.Subject;
import org.apache.jetspeed.profiler.rules.FallbackCriterionResolver;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.JetspeedPrincipal;
import org.apache.jetspeed.security.SubjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalCriterionResolver
extends StandardResolver
implements FallbackCriterionResolver {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(PrincipalCriterionResolver.class);

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String value = super.resolve(context, criterion);
        if (value != null) {
            return value;
        }
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error(msg);
            return null;
        }
        return this.resolvePrincipals(context, criterion, subject, criterion.getName());
    }

    public boolean isControl(RuleCriterion criterion) {
        return true;
    }

    protected String resolvePrincipals(RequestContext context, RuleCriterion criterion, Subject subject, String jptName) {
        StringBuffer result = new StringBuffer();
        int count = 0;
        for (JetspeedPrincipal principal : SubjectHelper.getPrincipals((Subject)subject, (String)jptName)) {
            if (count > 0) {
                result.append(",");
            }
            result.append(principal.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }

    protected String combinePrincipals(RequestContext context, RuleCriterion criterion, Subject subject, String jptName) {
        StringBuffer result = new StringBuffer();
        int count = 0;
        for (JetspeedPrincipal principal : SubjectHelper.getPrincipals((Subject)subject, (String)jptName)) {
            if (count > 0) {
                result.append("-");
            }
            result.append(principal.getName());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return result.toString();
    }
}

