/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SubjectHelper;
import org.apache.jetspeed.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCriterionResolver
extends StandardResolver
implements RuleCriterionResolver {
    protected static final Logger log = LoggerFactory.getLogger(UserCriterionResolver.class);

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String value = super.resolve(context, criterion);
        if (value != null) {
            return value;
        }
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error(msg);
            return null;
        }
        Principal principal = SubjectHelper.getPrincipal((Subject)subject, User.class);
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public boolean isControl(RuleCriterion criterion) {
        return true;
    }
}

