/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityHelper;
import org.apache.jetspeed.security.UserPrincipal;

public class UserCriterionResolver
extends StandardResolver
implements RuleCriterionResolver {
    protected static final Log log = LogFactory.getLog((Class)UserCriterionResolver.class);

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String value = super.resolve(context, criterion);
        if (value != null) {
            return value;
        }
        Subject subject = context.getSubject();
        if (subject == null) {
            String msg = "Invalid (null) Subject in request pipeline";
            log.error((Object)msg);
            return null;
        }
        Principal principal = SecurityHelper.getPrincipal((Subject)subject, (Class)UserPrincipal.class);
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public boolean isControl(RuleCriterion criterion) {
        return true;
    }
}

