/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.request.RequestContext;

public class PathSessionResolver
implements RuleCriterionResolver {
    static String[][] REGEX_MAP = new String[][]{{".*\\.(...|....)", "/Public/content.psml"}};

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String key;
        String path = null;
        ContentPage page = context.getPage();
        if (page != null) {
            path = page.getId();
        } else {
            path = context.getPath();
            if (path != null) {
                path = this.mapPath(context, path);
            }
        }
        if ((path == null || path.equals("/")) && (path = (String)context.getSessionAttribute(key = this.getClass() + "." + criterion.getName())) == null) {
            path = criterion.getValue();
        }
        return path;
    }

    private String mapPath(RequestContext context, String originalPath) {
        String path = originalPath;
        if (path.endsWith(".psml")) {
            return originalPath;
        }
        for (int ix = 0; ix < REGEX_MAP.length; ++ix) {
            if (!path.matches(REGEX_MAP[ix][0])) continue;
            path = REGEX_MAP[ix][1];
            context.setPath(path);
            context.setAttribute("org.apache.jetspeed.Path", (Object)originalPath);
            break;
        }
        return path;
    }

    public boolean isControl(RuleCriterion criterion) {
        return false;
    }

    public boolean isNavigation(RuleCriterion criterion) {
        return false;
    }
}

