/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.profiler.rules.impl;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jetspeed.profiler.rules.RuleCriterion;
import org.apache.jetspeed.profiler.rules.RuleCriterionResolver;
import org.apache.jetspeed.profiler.rules.impl.StandardResolver;
import org.apache.jetspeed.request.RequestContext;

public class HostnameCriterionResolver
extends StandardResolver
implements RuleCriterionResolver {
    private boolean useDotPrefix;
    private List hostnameMappingRules;

    public HostnameCriterionResolver(boolean usePrefix) {
        this.useDotPrefix = usePrefix;
    }

    public HostnameCriterionResolver(List hostnameMappingRules) {
        this.hostnameMappingRules = hostnameMappingRules;
    }

    public boolean isControl(RuleCriterion criterion) {
        return true;
    }

    public boolean isNavigation(RuleCriterion criterion) {
        return false;
    }

    public String resolve(RequestContext context, RuleCriterion criterion) {
        String serverName = context.getRequest().getServerName();
        if (this.useDotPrefix) {
            int idx = serverName.indexOf(".");
            if (idx != -1) {
                serverName = serverName.substring(0, idx);
            }
        } else if (this.hostnameMappingRules != null) {
            Iterator rulesIter = this.hostnameMappingRules.iterator();
            while (rulesIter.hasNext()) {
                Rule rule = (Rule)rulesIter.next();
                serverName = rule.map(serverName);
            }
        }
        return serverName;
    }

    public static class Rule {
        private String pattern;
        private String replacement;
        private Pattern compiledPattern;

        public Rule(String pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.compiledPattern = Pattern.compile(pattern);
        }

        public String map(String hostname) {
            Matcher patternMatcher = this.compiledPattern.matcher(hostname);
            if (patternMatcher.find()) {
                return patternMatcher.replaceAll(this.replacement);
            }
            return hostname;
        }
    }
}

