/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.AbstractList;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.impl.SecurityConstraintsImpl;

class SecurityConstraintList
extends AbstractList {
    private SecurityConstraintsImpl constraints;

    SecurityConstraintList(SecurityConstraintsImpl constraints) {
        this.constraints = constraints;
    }

    private SecurityConstraintImpl validateConstraintForAdd(SecurityConstraintImpl constraint) {
        if (constraint == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        if (this.constraints.getSecurityConstraintClass() != null && !this.constraints.getSecurityConstraintClass().isInstance(constraint)) {
            throw new ClassCastException("Unable to add list element instance: expected " + this.constraints.getSecurityConstraintClass().getName() + ", got " + constraint.getClass().getName() + ".");
        }
        return constraint;
    }

    public void add(int index, Object element) {
        SecurityConstraintImpl nextConstraint;
        if (index < 0 || index > this.constraints.accessConstraints().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        SecurityConstraintImpl constraint = this.validateConstraintForAdd((SecurityConstraintImpl)element);
        this.constraints.accessConstraints().add(index, constraint);
        if (index > 0) {
            constraint.setApplyOrder(((SecurityConstraintImpl)this.constraints.accessConstraints().get(index - 1)).getApplyOrder() + 1);
        } else {
            constraint.setApplyOrder(0);
        }
        int limit = this.constraints.accessConstraints().size() - 1;
        for (int i = index; i < limit && (nextConstraint = (SecurityConstraintImpl)this.constraints.accessConstraints().get(i + 1)).getApplyOrder() <= constraint.getApplyOrder(); ++i) {
            nextConstraint.setApplyOrder(constraint.getApplyOrder() + 1);
            constraint = nextConstraint;
        }
        this.constraints.clearAllSecurityConstraints();
    }

    public Object get(int index) {
        return this.constraints.accessConstraints().get(index);
    }

    public Object remove(int index) {
        Object removed = this.constraints.accessConstraints().remove(index);
        if (removed != null) {
            this.constraints.clearAllSecurityConstraints();
        }
        return removed;
    }

    public Object set(int index, Object element) {
        SecurityConstraintImpl newConstraint = this.validateConstraintForAdd((SecurityConstraintImpl)element);
        SecurityConstraintImpl constraint = this.constraints.accessConstraints().set(index, newConstraint);
        newConstraint.setApplyOrder(constraint.getApplyOrder());
        this.constraints.clearAllSecurityConstraints();
        return constraint;
    }

    public int size() {
        return this.constraints.accessConstraints().size();
    }
}

