/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.BaseFragmentsElementImpl;
import org.apache.jetspeed.om.page.impl.FilteredFragmentList;
import org.apache.jetspeed.om.page.impl.FragmentList;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class FragmentImpl
extends BaseFragmentElementImpl
implements Fragment {
    private List fragments;
    private String type;
    private FragmentList fragmentsList;

    List accessFragments() {
        if (this.fragments == null) {
            this.fragments = DatabasePageManagerUtils.createList();
        }
        return this.fragments;
    }

    void setBaseFragmentsElement(BaseFragmentsElementImpl baseFragmentsElement) {
        super.setBaseFragmentsElement(baseFragmentsElement);
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                ((BaseFragmentElementImpl)fragmentsIter.next()).setBaseFragmentsElement(baseFragmentsElement);
            }
        }
    }

    public BaseFragmentElement getFragmentById(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                BaseFragmentElement matchedFragment = ((BaseFragmentElementImpl)fragmentsIter.next()).getFragmentById(id);
                if (matchedFragment == null) continue;
                return matchedFragment;
            }
        }
        return null;
    }

    public BaseFragmentElement removeFragmentById(String id) {
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                BaseFragmentElementImpl fragment = (BaseFragmentElementImpl)fragmentsIter.next();
                if (!fragment.getId().equals(id)) {
                    BaseFragmentElement removed;
                    if (!(fragment instanceof FragmentImpl) || (removed = ((FragmentImpl)fragment).removeFragmentById(id)) == null) continue;
                    return removed;
                }
                try {
                    fragment.checkAccess(JetspeedActions.EDIT);
                    fragmentsIter.remove();
                    return fragment;
                }
                catch (SecurityException se) {
                }
            }
        }
        return null;
    }

    List getFragmentsByName(String name) {
        List matchedFragments = super.getFragmentsByName(name);
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                List matchedChildFragments = ((BaseFragmentElementImpl)fragmentsIter.next()).getFragmentsByName(name);
                if (matchedChildFragments == null) continue;
                if (matchedFragments == null) {
                    matchedFragments = matchedChildFragments;
                    continue;
                }
                matchedFragments.addAll(matchedChildFragments);
            }
        }
        return matchedFragments;
    }

    List getFragmentsByInterface(Class interfaceFilter) {
        List matchedFragments = super.getFragmentsByInterface(interfaceFilter);
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                List matchedChildFragments = ((BaseFragmentElementImpl)fragmentsIter.next()).getFragmentsByInterface(interfaceFilter);
                if (matchedChildFragments == null) continue;
                if (matchedFragments == null) {
                    matchedFragments = matchedChildFragments;
                    continue;
                }
                matchedFragments.addAll(matchedChildFragments);
            }
        }
        return matchedFragments;
    }

    public void resetCachedSecurityConstraints() {
        super.resetCachedSecurityConstraints();
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                ((BaseFragmentElementImpl)fragmentsIter.next()).resetCachedSecurityConstraints();
            }
        }
    }

    public String getLogicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getLogicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public String getPhysicalPermissionPath() {
        if (this.getBaseFragmentsElement() != null && this.getName() != null) {
            return this.getBaseFragmentsElement().getPhysicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List getFragments() {
        if (this.fragmentsList == null) {
            this.fragmentsList = new FragmentList(this);
        }
        return this.filterFragmentsByAccess(this.fragmentsList, true);
    }

    protected boolean validateFragments(BaseFragmentValidationListener validationListener) {
        if (!validationListener.validate(this)) {
            return false;
        }
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                if (((BaseFragmentElementImpl)fragmentsIter.next()).validateFragments(validationListener)) continue;
                return false;
            }
        }
        return true;
    }

    List filterFragmentsByAccess(List fragments, boolean mutable) {
        if (fragments != null && !fragments.isEmpty()) {
            List filteredFragments = null;
            for (BaseFragmentElement fragment : fragments) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                    if (filteredFragments == null) continue;
                    filteredFragments.add(fragment);
                }
                catch (SecurityException se) {
                    BaseFragmentElement copyFragment;
                    if (filteredFragments != null) continue;
                    filteredFragments = DatabasePageManagerUtils.createList();
                    Iterator copyIter = fragments.iterator();
                    while (copyIter.hasNext() && (copyFragment = (BaseFragmentElement)copyIter.next()) != fragment) {
                        filteredFragments.add(copyFragment);
                    }
                }
            }
            if (filteredFragments != null) {
                if (!filteredFragments.isEmpty()) {
                    if (mutable) {
                        return new FilteredFragmentList(this, filteredFragments);
                    }
                    return filteredFragments;
                }
                return new FilteredFragmentList(this, filteredFragments);
            }
        }
        return fragments;
    }
}

