/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentValidationListener;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.PageMetadataImpl;
import org.apache.jetspeed.om.page.impl.BaseFragmentElementImpl;
import org.apache.jetspeed.om.page.impl.FragmentImpl;
import org.apache.jetspeed.om.page.impl.PageMetadataLocalizedFieldImpl;
import org.apache.jetspeed.om.page.impl.PageSecurityConstraintsImpl;
import org.apache.jetspeed.page.document.impl.DocumentImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public abstract class BaseFragmentsElementImpl
extends DocumentImpl
implements BaseFragmentsElement {
    private String ojbConcreteClass = this.getClass().getName();
    private Collection fragment;

    public BaseFragmentsElementImpl() {
        super(new PageSecurityConstraintsImpl());
    }

    public PageMetadataImpl newPageMetadata(Collection fields) {
        PageMetadataImpl pageMetadata = new PageMetadataImpl(PageMetadataLocalizedFieldImpl.class);
        pageMetadata.setFields(fields);
        return pageMetadata;
    }

    public BaseFragmentElement getRootFragment() {
        if (this.fragment != null && !this.fragment.isEmpty()) {
            BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.fragment.iterator().next();
            if (rootFragment.getBaseFragmentsElement() != this) {
                rootFragment.setBaseFragmentsElement(this);
            }
            return rootFragment;
        }
        return null;
    }

    public void setRootFragment(BaseFragmentElement fragment) {
        if (fragment instanceof BaseFragmentElementImpl) {
            BaseFragmentElementImpl baseFragmentImpl = (BaseFragmentElementImpl)fragment;
            if (this.fragment == null) {
                this.fragment = DatabasePageManagerUtils.createList();
            } else if (!this.fragment.isEmpty()) {
                this.fragment.clear();
            }
            BaseFragmentElementImpl addFragment = (BaseFragmentElementImpl)fragment;
            Object reuseFragment = null;
            this.fragment.add(addFragment);
            addFragment.setBaseFragmentsElement(this);
        } else if (fragment == null && this.fragment != null && !this.fragment.isEmpty()) {
            this.fragment.clear();
        }
    }

    public BaseFragmentElement getFragmentById(String id) {
        BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.getRootFragment();
        if (rootFragment != null) {
            BaseFragmentElementImpl fragment = (BaseFragmentElementImpl)rootFragment.getFragmentById(id);
            if (fragment != null) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                }
                catch (SecurityException se) {
                    fragment = null;
                }
            }
            return fragment;
        }
        return null;
    }

    public BaseFragmentElement removeFragmentById(String id) {
        BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.getRootFragment();
        if (rootFragment != null) {
            if (!rootFragment.getId().equals(id)) {
                if (rootFragment instanceof FragmentImpl) {
                    return ((FragmentImpl)rootFragment).removeFragmentById(id);
                }
            } else {
                try {
                    rootFragment.checkAccess(JetspeedActions.EDIT);
                    this.setRootFragment(null);
                    return rootFragment;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public List getFragmentsByName(String name) {
        BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.getRootFragment();
        if (rootFragment != null && rootFragment instanceof FragmentImpl) {
            FragmentImpl rootFragmentImpl = (FragmentImpl)rootFragment;
            return rootFragmentImpl.filterFragmentsByAccess(rootFragmentImpl.getFragmentsByName(name), false);
        }
        return null;
    }

    public List getFragmentsByInterface(Class interfaceFilter) {
        BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.getRootFragment();
        if (rootFragment != null) {
            if (rootFragment instanceof FragmentImpl) {
                FragmentImpl rootFragmentImpl = (FragmentImpl)rootFragment;
                return rootFragmentImpl.filterFragmentsByAccess(rootFragmentImpl.getFragmentsByInterface(interfaceFilter), false);
            }
            if (interfaceFilter == null || interfaceFilter.isInstance(rootFragment)) {
                try {
                    rootFragment.checkAccess(JetspeedActions.VIEW);
                    ArrayList<BaseFragmentElementImpl> fragmentsList = new ArrayList<BaseFragmentElementImpl>();
                    fragmentsList.add(rootFragment);
                    return fragmentsList;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean validateFragments() {
        BaseFragmentElementImpl rootFragment = (BaseFragmentElementImpl)this.getRootFragment();
        if (rootFragment != null) {
            BaseFragmentValidationListener validationListener = this.newBaseFragmentValidationListener();
            return rootFragment.validateFragments(validationListener) && validationListener.validate();
        }
        return false;
    }

    protected abstract BaseFragmentValidationListener newBaseFragmentValidationListener();
}

