/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

public class SecurityConstraintImpl
implements SecurityConstraint {
    private int id;
    private int applyOrder;
    private List usersList;
    private List rolesList;
    private List groupsList;
    private List permissionsList;
    private String users;
    private String roles;
    private String groups;
    private String permissions;

    public int getApplyOrder() {
        return this.applyOrder;
    }

    public void setApplyOrder(int order) {
        this.applyOrder = order;
    }

    public String getUsersAsString() {
        if (this.users == null && this.usersList != null && !this.usersList.isEmpty()) {
            this.users = SecurityConstraintImpl.formatCSVList(this.usersList);
        }
        return this.users;
    }

    public void setUsersAsString(String users) {
        this.users = users;
        this.usersList = SecurityConstraintImpl.parseCSVList(users);
    }

    public String getRolesAsString() {
        if (this.roles == null && this.rolesList != null && !this.rolesList.isEmpty()) {
            this.roles = SecurityConstraintImpl.formatCSVList(this.rolesList);
        }
        return this.roles;
    }

    public void setRolesAsString(String roles) {
        this.roles = roles;
        this.rolesList = SecurityConstraintImpl.parseCSVList(roles);
    }

    public String getGroupsAsString() {
        if (this.groups == null && this.groupsList != null && !this.groupsList.isEmpty()) {
            this.groups = SecurityConstraintImpl.formatCSVList(this.groupsList);
        }
        return this.groups;
    }

    public void setGroupsAsString(String groups) {
        this.groups = groups;
        this.groupsList = SecurityConstraintImpl.parseCSVList(groups);
    }

    public String getPermissionsAsString() {
        if (this.permissions == null && this.permissionsList != null && !this.permissionsList.isEmpty()) {
            this.permissions = SecurityConstraintImpl.formatCSVList(this.permissionsList);
        }
        return this.permissions;
    }

    public void setPermissionsAsString(String permissions) {
        this.permissions = permissions;
        this.permissionsList = SecurityConstraintImpl.parseCSVList(permissions);
    }

    public List getUsers() {
        return this.usersList;
    }

    public void setUsers(List users) {
        this.usersList = users;
        this.users = null;
    }

    public List getRoles() {
        return this.rolesList;
    }

    public void setRoles(List roles) {
        this.rolesList = roles;
        this.roles = null;
    }

    public List getGroups() {
        return this.groupsList;
    }

    public void setGroups(List groups) {
        this.groupsList = groups;
        this.groups = null;
    }

    public List getPermissions() {
        return this.permissionsList;
    }

    public void setPermissions(List permissions) {
        this.permissionsList = permissions;
        this.permissions = null;
    }

    public boolean principalsMatch(List userPrincipals, List rolePrincipals, List groupPrincipals, boolean allowDefault) {
        return allowDefault && this.usersList == null && this.rolesList == null && this.groupsList == null || this.usersList != null && userPrincipals != null && (SecurityConstraintImpl.containsAny(this.usersList, userPrincipals) || this.usersList.contains("*")) || this.rolesList != null && rolePrincipals != null && (SecurityConstraintImpl.containsAny(this.rolesList, rolePrincipals) || this.rolesList.contains("*")) || this.groupsList != null && groupPrincipals != null && (SecurityConstraintImpl.containsAny(this.groupsList, groupPrincipals) || this.groupsList.contains("*"));
    }

    public boolean actionMatch(String action) {
        return this.permissionsList != null && (this.permissionsList.contains(action) || this.permissionsList.contains("*"));
    }

    public static List parseCSVList(String csv) {
        if (csv != null) {
            List csvList = DatabasePageManagerUtils.createList();
            if (csv.indexOf(44) != -1) {
                StringTokenizer csvTokens = new StringTokenizer(csv, ",");
                while (csvTokens.hasMoreTokens()) {
                    csvList.add(csvTokens.nextToken().trim());
                }
            } else {
                csvList.add(csv);
            }
            return csvList;
        }
        return null;
    }

    public static String formatCSVList(List list) {
        if (list != null && !list.isEmpty()) {
            StringBuffer csv = new StringBuffer();
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                if (csv.length() > 0) {
                    csv.append(",");
                }
                csv.append((String)listIter.next());
            }
            return csv.toString();
        }
        return null;
    }

    public static boolean containsAny(Collection collection0, Collection collection1) {
        if (collection0 != null && collection1 != null) {
            Iterator containsIter = collection1.iterator();
            while (containsIter.hasNext()) {
                if (!collection0.contains(containsIter.next())) continue;
                return true;
            }
        }
        return false;
    }
}

