/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page.psml;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.cache.file.FileCache;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.apache.jetspeed.idgenerator.IdGenerator;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.folder.FolderNotFoundException;
import org.apache.jetspeed.om.folder.InvalidFolderException;
import org.apache.jetspeed.om.folder.psml.FolderImpl;
import org.apache.jetspeed.om.folder.psml.MenuDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuExcludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuIncludeDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuOptionsDefinitionImpl;
import org.apache.jetspeed.om.folder.psml.MenuSeparatorDefinitionImpl;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.ContentPageImpl;
import org.apache.jetspeed.om.page.Document;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.SecurityConstraintImpl;
import org.apache.jetspeed.om.page.SecurityConstraintsDef;
import org.apache.jetspeed.om.page.psml.FragmentImpl;
import org.apache.jetspeed.om.page.psml.FragmentPreferenceImpl;
import org.apache.jetspeed.om.page.psml.LinkImpl;
import org.apache.jetspeed.om.page.psml.PageImpl;
import org.apache.jetspeed.om.page.psml.PageSecurityImpl;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsDefImpl;
import org.apache.jetspeed.om.page.psml.SecurityConstraintsImpl;
import org.apache.jetspeed.page.AbstractPageManager;
import org.apache.jetspeed.page.FolderNotUpdatedException;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageManagerSecurityUtils;
import org.apache.jetspeed.page.PageNotFoundException;
import org.apache.jetspeed.page.document.DocumentException;
import org.apache.jetspeed.page.document.DocumentHandlerFactory;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.page.document.FailedToDeleteDocumentException;
import org.apache.jetspeed.page.document.FailedToUpdateDocumentException;
import org.apache.jetspeed.page.document.FolderHandler;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.page.document.NodeException;
import org.apache.jetspeed.page.document.NodeSet;
import org.apache.jetspeed.page.document.UnsupportedDocumentTypeException;
import org.apache.jetspeed.page.document.psml.NodeSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastorXmlPageManager
extends AbstractPageManager
implements PageManager,
FileCacheEventListener {
    private static final Logger log = LoggerFactory.getLogger(CastorXmlPageManager.class);
    private static Map modelClasses = new HashMap();
    private IdGenerator generator = null;
    private DocumentHandlerFactory handlerFactory;
    private FolderHandler folderHandler;
    private FileCache fileCache;

    public CastorXmlPageManager(IdGenerator generator, DocumentHandlerFactory handlerFactory, FolderHandler folderHandler, FileCache fileCache, boolean permissionsEnabled, boolean constraintsEnabled) throws FileNotFoundException {
        super(permissionsEnabled, constraintsEnabled, modelClasses);
        this.generator = generator;
        handlerFactory.setPermissionsEnabled(permissionsEnabled);
        handlerFactory.setConstraintsEnabled(constraintsEnabled);
        this.handlerFactory = handlerFactory;
        this.folderHandler = folderHandler;
        this.fileCache = fileCache;
        this.fileCache.addListener((FileCacheEventListener)this);
    }

    public Fragment newFragment() {
        FragmentImpl fragment = (FragmentImpl)super.newFragment();
        fragment.setId(this.generator.getNextPeid());
        return fragment;
    }

    public Fragment newPortletFragment() {
        FragmentImpl fragment = (FragmentImpl)super.newFragment();
        fragment.setType("portlet");
        fragment.setId(this.generator.getNextPeid());
        return fragment;
    }

    public Page getPage(String path) throws PageNotFoundException, NodeException {
        try {
            FolderImpl folder = this.getNodeFolder(path);
            return folder.getPage(this.getNodeName(path));
        }
        catch (FolderNotFoundException fnfe) {
            throw new PageNotFoundException(fnfe.getMessage());
        }
    }

    public void updatePage(Page page) throws NodeException {
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        if (page.getPath() != null) {
            if (!page.getPath().equals(page.getId())) {
                log.error("Page paths and ids must match!");
                return;
            }
        } else {
            log.error("Page paths and ids must be set!");
            return;
        }
        try {
            boolean newPage = false;
            FolderImpl parentFolder = this.getNodeFolder(page.getPath());
            if (page.getParent() == null) {
                page.setParent((Node)parentFolder);
                newPage = true;
            }
            PageImpl pageImpl = (PageImpl)page;
            pageImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            pageImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            page.checkAccess(JetspeedActions.EDIT);
            this.handlerFactory.getDocumentHandler(".psml").updateDocument((Document)page);
            if (parentFolder != null) {
                NodeSetImpl parentAllNodes = (NodeSetImpl)parentFolder.getAllNodes();
                if (!parentAllNodes.contains((Node)page)) {
                    parentAllNodes.add((Node)page);
                    newPage = true;
                } else if (parentAllNodes.get(page.getPath()) != page) {
                    parentAllNodes.remove((Node)page);
                    parentAllNodes.add((Node)page);
                }
            }
            if (newPage) {
                this.notifyNewNode((Node)page);
            } else {
                this.notifyUpdatedNode((Node)page);
            }
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
    }

    public void removePage(Page page) throws NodeException {
        if (page instanceof ContentPageImpl) {
            page = ((ContentPageImpl)page).getPage();
        }
        page.checkAccess(JetspeedActions.EDIT);
        try {
            FolderImpl folder = this.getNodeFolder(page.getPath());
            this.handlerFactory.getDocumentHandler(".psml").removeDocument((Document)page);
            ((NodeSetImpl)folder.getAllNodes()).remove((Node)page);
            this.notifyRemovedNode((Node)page);
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
        catch (DocumentNotFoundException dnfe) {
            throw new NodeException(dnfe.getMessage());
        }
    }

    public Link getLink(String path) throws DocumentNotFoundException, UnsupportedDocumentTypeException, NodeException {
        try {
            FolderImpl folder = this.getNodeFolder(path);
            return folder.getLink(this.getNodeName(path));
        }
        catch (FolderNotFoundException fnfe) {
            throw new DocumentNotFoundException(fnfe.getMessage());
        }
    }

    public void updateLink(Link link) throws NodeException {
        if (link.getPath() != null) {
            if (!link.getPath().equals(link.getId())) {
                log.error("Link paths and ids must match!");
                return;
            }
        } else {
            log.error("Link paths and ids must be set!");
            return;
        }
        try {
            boolean newLink = false;
            FolderImpl parentFolder = this.getNodeFolder(link.getPath());
            if (link.getParent() == null) {
                link.setParent((Node)parentFolder);
                newLink = true;
            }
            LinkImpl linkImpl = (LinkImpl)link;
            linkImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            linkImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            link.checkAccess(JetspeedActions.EDIT);
            this.handlerFactory.getDocumentHandler(".link").updateDocument((Document)link);
            if (parentFolder != null) {
                NodeSetImpl parentAllNodes = (NodeSetImpl)parentFolder.getAllNodes();
                if (!parentAllNodes.contains((Node)link)) {
                    parentAllNodes.add((Node)link);
                    newLink = true;
                } else if (parentAllNodes.get(link.getPath()) != link) {
                    parentAllNodes.remove((Node)link);
                    parentAllNodes.add((Node)link);
                }
            }
            if (newLink) {
                this.notifyNewNode((Node)link);
            } else {
                this.notifyUpdatedNode((Node)link);
            }
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
    }

    public void removeLink(Link link) throws NodeException {
        link.checkAccess(JetspeedActions.EDIT);
        try {
            FolderImpl folder = this.getNodeFolder(link.getPath());
            this.handlerFactory.getDocumentHandler(".link").removeDocument((Document)link);
            ((NodeSetImpl)folder.getAllNodes()).remove((Node)link);
            this.notifyRemovedNode((Node)link);
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
        catch (DocumentNotFoundException dnfe) {
            throw new NodeException(dnfe.getMessage());
        }
    }

    public boolean checkConstraint(String securityConstraintName, String actions) {
        try {
            PageSecurity security = this.getPageSecurity();
            SecurityConstraintsDef def = security.getSecurityConstraintsDef(securityConstraintName);
            if (def != null) {
                return PageManagerSecurityUtils.checkConstraint(def, actions);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public PageSecurity getPageSecurity() throws DocumentNotFoundException, UnsupportedDocumentTypeException, NodeException {
        try {
            FolderImpl folder = this.getNodeFolder("/");
            return folder.getPageSecurity();
        }
        catch (FolderNotFoundException fnfe) {
            throw new DocumentNotFoundException(fnfe.getMessage());
        }
    }

    public void updatePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToUpdateDocumentException {
        if (pageSecurity.getPath() != null) {
            if (!pageSecurity.getPath().equals("/page.security")) {
                log.error("PageSecurity path must be: /page.security");
                return;
            }
            if (!pageSecurity.getPath().equals(pageSecurity.getId())) {
                log.error("PageSecurity paths and ids must match!");
                return;
            }
        } else {
            log.error("PageSecurity paths and ids must be set!");
            return;
        }
        try {
            boolean newPageSecurity = false;
            FolderImpl parentFolder = this.getNodeFolder("/");
            if (pageSecurity.getParent() == null) {
                pageSecurity.setParent((Node)parentFolder);
                newPageSecurity = true;
            }
            PageSecurityImpl pageSecurityImpl = (PageSecurityImpl)pageSecurity;
            pageSecurityImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            pageSecurityImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            pageSecurity.checkAccess(JetspeedActions.EDIT);
            this.handlerFactory.getDocumentHandler("page.security").updateDocument((Document)pageSecurity);
            if (parentFolder != null) {
                NodeSetImpl parentAllNodes = (NodeSetImpl)parentFolder.getAllNodes();
                if (!parentAllNodes.contains((Node)pageSecurity)) {
                    parentAllNodes.add((Node)pageSecurity);
                    newPageSecurity = true;
                } else if (parentAllNodes.get(pageSecurity.getPath()) != pageSecurity) {
                    parentAllNodes.remove((Node)pageSecurity);
                    parentAllNodes.add((Node)pageSecurity);
                }
            }
            if (newPageSecurity) {
                this.notifyNewNode((Node)pageSecurity);
            } else {
                this.notifyUpdatedNode((Node)pageSecurity);
            }
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
    }

    public void removePageSecurity(PageSecurity pageSecurity) throws NodeException, FailedToDeleteDocumentException {
        pageSecurity.checkAccess(JetspeedActions.EDIT);
        try {
            FolderImpl folder = this.getNodeFolder("/");
            this.handlerFactory.getDocumentHandler("page.security").removeDocument((Document)pageSecurity);
            ((NodeSetImpl)folder.getAllNodes()).remove((Node)pageSecurity);
            this.notifyRemovedNode((Node)pageSecurity);
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
        catch (DocumentNotFoundException dnfe) {
            throw new NodeException(dnfe.getMessage());
        }
    }

    public Folder getFolder(String folderPath) throws FolderNotFoundException, InvalidFolderException, NodeException {
        Folder folder = this.folderHandler.getFolder(folderPath);
        folder.checkAccess(JetspeedActions.VIEW);
        return folder;
    }

    public NodeSet getFolders(Folder folder) throws DocumentException {
        return folder.getFolders();
    }

    public Folder getFolder(Folder folder, String name) throws FolderNotFoundException, DocumentException {
        return folder.getFolder(name);
    }

    public NodeSet getPages(Folder folder) throws NodeException {
        return folder.getPages();
    }

    public Page getPage(Folder folder, String name) throws PageNotFoundException, NodeException {
        return folder.getPage(name);
    }

    public NodeSet getLinks(Folder folder) throws NodeException {
        return folder.getLinks();
    }

    public Link getLink(Folder folder, String name) throws DocumentNotFoundException, NodeException {
        return folder.getLink(name);
    }

    public PageSecurity getPageSecurity(Folder folder) throws DocumentNotFoundException, NodeException {
        return folder.getPageSecurity();
    }

    public NodeSet getAll(Folder folder) throws DocumentException {
        return folder.getAll();
    }

    public void updateFolder(Folder folder) throws NodeException, FolderNotUpdatedException {
        this.updateFolder(folder, false);
    }

    public void updateFolder(Folder folder, boolean deep) throws NodeException, FolderNotUpdatedException {
        if (folder.getPath() != null) {
            if (!folder.getPath().equals(folder.getId())) {
                log.error("Folder paths and ids must match!");
                return;
            }
        } else {
            log.error("Folder paths and ids must be set!");
            return;
        }
        try {
            boolean newFolder = false;
            FolderImpl parentFolder = null;
            if (!folder.getPath().equals("/")) {
                parentFolder = this.getNodeFolder(folder.getPath());
                if (folder.getParent() == null) {
                    folder.setParent((Node)parentFolder);
                    newFolder = true;
                }
            } else {
                folder.setParent(null);
            }
            FolderImpl folderImpl = (FolderImpl)folder;
            folderImpl.setPermissionsEnabled(this.handlerFactory.getPermissionsEnabled());
            folderImpl.setConstraintsEnabled(this.handlerFactory.getConstraintsEnabled());
            folderImpl.setFolderHandler(this.folderHandler);
            folder.checkAccess(JetspeedActions.EDIT);
            this.folderHandler.updateFolder(folder);
            if (parentFolder != null) {
                NodeSetImpl parentAllNodes = (NodeSetImpl)parentFolder.getAllNodes();
                if (!parentAllNodes.contains((Node)folder)) {
                    parentAllNodes.add((Node)folder);
                    newFolder = true;
                } else if (parentAllNodes.get(folder.getPath()) != folder) {
                    parentAllNodes.remove((Node)folder);
                    parentAllNodes.add((Node)folder);
                }
            }
            if (deep) {
                this.updateFolderNodes(folderImpl);
            }
            if (newFolder) {
                this.notifyNewNode((Node)folder);
            } else {
                this.notifyUpdatedNode((Node)folder);
            }
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
    }

    private void updateFolderNodes(FolderImpl folderImpl) throws FolderNotUpdatedException {
        try {
            NodeSet nodes = folderImpl.getAllNodes();
            for (Node node : nodes) {
                if (node instanceof Page) {
                    this.updatePage((Page)node);
                    continue;
                }
                if (node instanceof Link) {
                    this.updateLink((Link)node);
                    continue;
                }
                if (!(node instanceof PageSecurity)) continue;
                this.updatePageSecurity((PageSecurity)node);
            }
            for (Node node : nodes) {
                if (!(node instanceof Folder)) continue;
                this.updateFolder((Folder)node, true);
            }
        }
        catch (FolderNotUpdatedException fnue) {
            throw fnue;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw new FolderNotUpdatedException("Folder " + folderImpl.getPath() + " not updated.", (Throwable)e);
        }
    }

    public void removeFolder(Folder folder) throws NodeException {
        folder.checkAccess(JetspeedActions.EDIT);
        try {
            FolderImpl parentFolder = null;
            if (!folder.getPath().equals("/")) {
                parentFolder = this.getNodeFolder(folder.getPath());
            }
            this.folderHandler.removeFolder(folder);
            if (parentFolder != null) {
                ((NodeSetImpl)parentFolder.getAllNodes()).remove((Node)folder);
            }
            this.notifyRemovedNode((Node)folder);
        }
        catch (FolderNotFoundException fnfe) {
            throw new NodeException(fnfe.getMessage());
        }
    }

    public void reset() {
        super.reset();
        this.fileCache.evictAll();
    }

    public void shutdown() {
        super.shutdown();
        this.fileCache.removeListener((FileCacheEventListener)this);
        this.handlerFactory.shutdown();
        this.folderHandler.shutdown();
    }

    private FolderImpl getNodeFolder(String nodePath) throws NodeException, InvalidFolderException, FolderNotFoundException {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > 0) {
            return (FolderImpl)this.folderHandler.getFolder(nodePath.substring(0, folderIndex));
        }
        return (FolderImpl)this.folderHandler.getFolder("/");
    }

    private String getNodeName(String nodePath) {
        int folderIndex = nodePath.lastIndexOf("/");
        if (folderIndex > -1) {
            return nodePath.substring(folderIndex + 1);
        }
        return nodePath;
    }

    public void refresh(FileCacheEntry entry) throws Exception {
        Node refreshedNode = null;
        if (entry.getDocument() instanceof Node) {
            refreshedNode = (Node)entry.getDocument();
        }
        if (entry.getFile().exists()) {
            this.notifyUpdatedNode(refreshedNode);
        } else {
            this.notifyRemovedNode(refreshedNode);
        }
    }

    public void evict(FileCacheEntry entry) throws Exception {
    }

    public ContentPage getContentPage(String path) throws PageNotFoundException, NodeException {
        return new ContentPageImpl(this.getPage(path));
    }

    public Page copy(Page source) {
        return null;
    }

    public int addPages(Page[] pages) throws NodeException {
        this.updatePage(pages[0]);
        this.updatePage(pages[1]);
        throw new NodeException("Its gonna blow captain!");
    }

    static {
        modelClasses.put("FragmentImpl", FragmentImpl.class);
        modelClasses.put("PageImpl", PageImpl.class);
        modelClasses.put("FolderImpl", FolderImpl.class);
        modelClasses.put("LinkImpl", LinkImpl.class);
        modelClasses.put("PageSecurityImpl", PageSecurityImpl.class);
        modelClasses.put("FolderMenuDefinitionImpl", MenuDefinitionImpl.class);
        modelClasses.put("FolderMenuExcludeDefinitionImpl", MenuExcludeDefinitionImpl.class);
        modelClasses.put("FolderMenuIncludeDefinitionImpl", MenuIncludeDefinitionImpl.class);
        modelClasses.put("FolderMenuOptionsDefinitionImpl", MenuOptionsDefinitionImpl.class);
        modelClasses.put("FolderMenuSeparatorDefinitionImpl", MenuSeparatorDefinitionImpl.class);
        modelClasses.put("PageMenuDefinitionImpl", MenuDefinitionImpl.class);
        modelClasses.put("PageMenuExcludeDefinitionImpl", MenuExcludeDefinitionImpl.class);
        modelClasses.put("PageMenuIncludeDefinitionImpl", MenuIncludeDefinitionImpl.class);
        modelClasses.put("PageMenuOptionsDefinitionImpl", MenuOptionsDefinitionImpl.class);
        modelClasses.put("PageMenuSeparatorDefinitionImpl", MenuSeparatorDefinitionImpl.class);
        modelClasses.put("SecurityConstraintsImpl", SecurityConstraintsImpl.class);
        modelClasses.put("FolderSecurityConstraintImpl", SecurityConstraintImpl.class);
        modelClasses.put("PageSecurityConstraintImpl", SecurityConstraintImpl.class);
        modelClasses.put("FragmentSecurityConstraintImpl", SecurityConstraintImpl.class);
        modelClasses.put("LinkSecurityConstraintImpl", SecurityConstraintImpl.class);
        modelClasses.put("PageSecuritySecurityConstraintImpl", SecurityConstraintImpl.class);
        modelClasses.put("SecurityConstraintsDefImpl", SecurityConstraintsDefImpl.class);
        modelClasses.put("FragmentPreferenceImpl", FragmentPreferenceImpl.class);
    }
}

