/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.page;

import org.apache.jetspeed.exception.JetspeedException;
import org.apache.jetspeed.om.folder.Folder;
import org.apache.jetspeed.om.page.Link;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.PageSerializer;
import org.apache.jetspeed.page.document.DocumentNotFoundException;
import org.apache.jetspeed.tools.ToolsLogger;

public class PageSerializerImpl
implements PageSerializer {
    private PageManager sourceManager;
    private PageManager destManager;
    private Boolean defaultOverwriteFolders = Boolean.TRUE;
    private Boolean defaultOverwritePages = Boolean.TRUE;
    private Boolean defaultAll = Boolean.TRUE;

    public PageSerializerImpl(PageManager sourceManager, PageManager destManager) {
        this.sourceManager = sourceManager;
        this.destManager = destManager;
    }

    public PageSerializerImpl(PageManager sourceManager, PageManager destManager, boolean defaultOverwriteFolders, boolean defaultOverwritePages, boolean defaultAll) {
        this.sourceManager = sourceManager;
        this.destManager = destManager;
        this.defaultOverwriteFolders = new Boolean(defaultOverwriteFolders);
        this.defaultOverwritePages = new Boolean(defaultOverwritePages);
        this.defaultAll = new Boolean(defaultAll);
    }

    private boolean boolValue(Boolean bool, Boolean defaultValue) {
        return bool != null ? bool.booleanValue() : defaultValue.booleanValue();
    }

    public PageSerializer.Result importPages(ToolsLogger logger, String rootFolder) throws JetspeedException {
        return this.importPages(logger, rootFolder, this.defaultOverwriteFolders, this.defaultOverwritePages, this.defaultAll);
    }

    public PageSerializer.Result exportPages(ToolsLogger logger, String rootFolder) throws JetspeedException {
        return this.exportPages(logger, rootFolder, this.defaultOverwriteFolders, this.defaultOverwritePages, this.defaultAll);
    }

    public PageSerializer.Result importPages(ToolsLogger logger, String rootFolder, Boolean overwriteFolders, Boolean overwritePages, Boolean all) throws JetspeedException {
        return this.execute(this.sourceManager, this.destManager, new Context(rootFolder, this.boolValue(overwritePages, this.defaultOverwritePages), this.boolValue(overwriteFolders, this.defaultOverwriteFolders), this.boolValue(all, this.defaultAll), logger), true);
    }

    public PageSerializer.Result exportPages(ToolsLogger logger, String rootFolder, Boolean overwriteFolders, Boolean overwritePages, Boolean all) throws JetspeedException {
        return this.execute(this.destManager, this.sourceManager, new Context(rootFolder, this.boolValue(overwritePages, this.defaultOverwritePages), this.boolValue(overwriteFolders, this.defaultOverwriteFolders), this.boolValue(all, this.defaultAll), logger), false);
    }

    private PageSerializer.Result execute(PageManager src, PageManager dest, Context context, boolean importing) throws JetspeedException {
        context.logger.info((CharSequence)("Starting " + (context.all ? "complete" : "") + " " + (importing ? "import" : "export") + " of folder: " + context.folder + " (overwriting folders: " + context.overwriteFolders + ", pages: " + context.overwritePages + ")"));
        this.processFolder(src.getFolder(context.folder), dest, context);
        if (context.all) {
            PageSecurity sourcePageSecurity = null;
            try {
                sourcePageSecurity = src.getPageSecurity();
            }
            catch (DocumentNotFoundException e) {
                // empty catch block
            }
            if (sourcePageSecurity != null) {
                context.logger.info((CharSequence)((importing ? "Importing" : "Exporting") + " page security"));
                PageSecurity rootSecurity = dest.copyPageSecurity(sourcePageSecurity);
                dest.updatePageSecurity(rootSecurity);
            } else {
                context.logger.info((CharSequence)"Skipping page security: not found");
            }
        }
        context.logger.info((CharSequence)((importing ? "Import" : "Export") + " finished: processed " + context.folderCount + " folder(s), " + context.pageCount + " page(s), " + context.linkCount + " link(s)."));
        context.logger = null;
        return context;
    }

    private Folder processFolder(Folder srcFolder, PageManager dest, Context context) throws JetspeedException {
        Folder dstFolder = PageSerializerImpl.lookupFolder(dest, srcFolder.getPath());
        if (null != dstFolder) {
            if (context.overwriteFolders) {
                context.logger.info((CharSequence)("overwriting folder " + srcFolder.getPath()));
                dest.removeFolder(dstFolder);
                dstFolder = dest.copyFolder(srcFolder, srcFolder.getPath());
                dest.updateFolder(dstFolder);
                ++context.folderCount;
            } else {
                context.logger.info((CharSequence)("skipping folder " + srcFolder.getPath()));
            }
        } else {
            context.logger.info((CharSequence)("processing new folder " + srcFolder.getPath()));
            dstFolder = dest.copyFolder(srcFolder, srcFolder.getPath());
            dest.updateFolder(dstFolder);
            ++context.folderCount;
        }
        for (Page srcPage : srcFolder.getPages()) {
            Page dstPage = PageSerializerImpl.lookupPage(dest, srcPage.getPath());
            if (null != dstPage) {
                if (context.overwritePages) {
                    context.logger.info((CharSequence)("overwriting page " + srcPage.getPath()));
                    dest.removePage(dstPage);
                    dstPage = dest.copyPage(srcPage, srcPage.getPath());
                    dest.updatePage(dstPage);
                    ++context.pageCount;
                    continue;
                }
                context.logger.info((CharSequence)("skipping page " + srcPage.getPath()));
                continue;
            }
            context.logger.info((CharSequence)("processing new page " + srcPage.getPath()));
            dstPage = dest.copyPage(srcPage, srcPage.getPath());
            dest.updatePage(dstPage);
            ++context.pageCount;
        }
        for (Link srcLink : srcFolder.getLinks()) {
            Link dstLink = PageSerializerImpl.lookupLink(dest, srcLink.getPath());
            if (null != dstLink) {
                if (context.overwritePages) {
                    context.logger.info((CharSequence)("overwriting link " + srcLink.getPath()));
                    dest.removeLink(dstLink);
                    dstLink = dest.copyLink(srcLink, srcLink.getPath());
                    dest.updateLink(dstLink);
                    ++context.linkCount;
                    continue;
                }
                context.logger.info((CharSequence)("skipping link " + srcLink.getPath()));
                continue;
            }
            context.logger.info((CharSequence)("processing new link " + srcLink.getPath()));
            dstLink = dest.copyLink(srcLink, srcLink.getPath());
            dest.updateLink(dstLink);
            ++context.linkCount;
        }
        for (Folder folder : srcFolder.getFolders()) {
            this.processFolder(folder, dest, context);
        }
        return dstFolder;
    }

    private static Page lookupPage(PageManager mgr, String path) {
        try {
            return mgr.getPage(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Link lookupLink(PageManager mgr, String path) {
        try {
            return mgr.getLink(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Folder lookupFolder(PageManager mgr, String path) {
        try {
            return mgr.getFolder(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class Context
    implements PageSerializer.Result {
        protected String folder;
        protected int folderCount;
        protected int pageCount;
        protected int linkCount;
        protected boolean overwritePages;
        protected boolean overwriteFolders;
        protected boolean all;
        protected transient ToolsLogger logger;

        public String getFolder() {
            return this.folder;
        }

        public int getFolderCount() {
            return this.folderCount;
        }

        public int getPageCount() {
            return this.pageCount;
        }

        public int getLinkCount() {
            return this.linkCount;
        }

        public boolean isOverwritePages() {
            return this.overwritePages;
        }

        public boolean isOverwriteFolders() {
            return this.overwriteFolders;
        }

        public boolean isSerializeAll() {
            return this.all;
        }

        public Context(String folder, boolean overwritePages, boolean overwriteFolders, boolean all, ToolsLogger logger) {
            this.folder = folder;
            this.overwritePages = overwritePages;
            this.overwriteFolders = overwriteFolders;
            this.all = all;
            this.logger = logger;
        }
    }
}

