/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.psml;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.psml.AbstractBaseElement;
import org.apache.jetspeed.om.page.psml.FilteredFragmentList;
import org.apache.jetspeed.om.page.psml.FragmentList;
import org.apache.jetspeed.om.page.psml.PageImpl;
import org.apache.jetspeed.om.page.psml.PropertyImpl;
import org.apache.jetspeed.security.PermissionFactory;

public class FragmentImpl
extends AbstractBaseElement
implements Fragment,
Serializable {
    private static int fragment_id_counter = 0;
    private String type = null;
    private String state = null;
    private String mode = null;
    private String decorator = null;
    private String skin = null;
    private List fragments = new ArrayList();
    private List propertiesList = new ArrayList();
    private List preferences = new ArrayList();
    private Map propertiesMap = new HashMap();
    private String name;
    private FragmentList fragmentsList;
    private PageImpl page;
    private boolean dirty = false;
    private static PermissionFactory pf;

    public static void setPermissionsFactory(PermissionFactory pf) {
        FragmentImpl.pf = pf;
    }

    public FragmentImpl() {
    }

    public FragmentImpl(String id) {
        if (id == null || id.length() == 0) {
            this.setId(FragmentImpl.generateId());
            this.dirty = true;
        } else {
            this.setId(id);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decoratorName) {
        this.decorator = decoratorName;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public boolean isReference() {
        return false;
    }

    List accessFragments() {
        return this.fragments;
    }

    public List getFragments() {
        if (this.fragmentsList == null) {
            this.fragmentsList = new FragmentList(this);
        }
        return this.filterFragmentsByAccess(this.fragmentsList);
    }

    public List getPropertiesList() {
        return this.propertiesList;
    }

    public String getProperty(String propName) {
        return (String)this.propertiesMap.get(propName);
    }

    public int getIntProperty(String propName) {
        String prop = (String)this.propertiesMap.get(propName);
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        return -1;
    }

    public float getFloatProperty(String propName) {
        String prop = (String)this.propertiesMap.get(propName);
        if (prop != null) {
            return Float.parseFloat(prop);
        }
        return -1.0f;
    }

    public Map getProperties() {
        return this.propertiesMap;
    }

    public int getLayoutRow() {
        return this.getIntProperty("row");
    }

    public void setLayoutRow(int row) {
        if (row >= 0) {
            this.propertiesMap.put("row", String.valueOf(row));
        } else {
            this.propertiesMap.remove("row");
        }
    }

    public int getLayoutColumn() {
        return this.getIntProperty("column");
    }

    public void setLayoutColumn(int column) {
        if (column >= 0) {
            this.propertiesMap.put("column", String.valueOf(column));
        } else {
            this.propertiesMap.remove("column");
        }
    }

    public String getLayoutSizes() {
        return (String)this.propertiesMap.get("sizes");
    }

    public void setLayoutSizes(String sizes) {
        if (sizes != null) {
            this.propertiesMap.put("sizes", sizes);
        } else {
            this.propertiesMap.remove("sizes");
        }
    }

    public float getLayoutX() {
        return this.getFloatProperty("x");
    }

    public void setLayoutX(float x) {
        if (x >= 0.0f) {
            this.propertiesMap.put("x", String.valueOf(x));
        } else {
            this.propertiesMap.remove("x");
        }
    }

    public float getLayoutY() {
        return this.getFloatProperty("y");
    }

    public void setLayoutY(float y) {
        if (y >= 0.0f) {
            this.propertiesMap.put("y", String.valueOf(y));
        } else {
            this.propertiesMap.remove("y");
        }
    }

    public float getLayoutZ() {
        return this.getFloatProperty("z");
    }

    public void setLayoutZ(float z) {
        if (z >= 0.0f) {
            this.propertiesMap.put("z", String.valueOf(z));
        } else {
            this.propertiesMap.remove("z");
        }
    }

    public float getLayoutWidth() {
        return this.getFloatProperty("width");
    }

    public void setLayoutWidth(float width) {
        if (width >= 0.0f) {
            this.propertiesMap.put("width", String.valueOf(width));
        } else {
            this.propertiesMap.remove("width");
        }
    }

    public float getLayoutHeight() {
        return this.getFloatProperty("height");
    }

    public void setLayoutHeight(float height) {
        if (height >= 0.0f) {
            this.propertiesMap.put("height", String.valueOf(height));
        } else {
            this.propertiesMap.remove("height");
        }
    }

    public boolean equals(Object obj) {
        Fragment aFragment;
        boolean isEqual = false;
        if (obj != null && obj instanceof Fragment && null != (aFragment = (Fragment)obj).getId() && null != this.getId() && this.getId().equals(aFragment.getId())) {
            isEqual = true;
        }
        return isEqual;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return (Fragment.class.getName() + ":" + this.getId()).hashCode();
        }
        return super.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getPreferences() {
        return this.preferences;
    }

    public void setPreferences(List preferences) {
        this.preferences = preferences;
    }

    PageImpl getPage() {
        return this.page;
    }

    void setPage(PageImpl page) {
        this.page = page;
        if (this.dirty) {
            page.setDirty(this.dirty);
        }
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                ((FragmentImpl)fragmentsIter.next()).setPage(page);
            }
        }
    }

    public PageSecurity getEffectivePageSecurity() {
        if (this.page != null) {
            return this.page.getEffectivePageSecurity();
        }
        return null;
    }

    public String getLogicalPermissionPath() {
        if (this.page != null && this.getName() != null) {
            return this.page.getLogicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public String getPhysicalPermissionPath() {
        if (this.page != null && this.getName() != null) {
            return this.page.getPhysicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        AccessController.checkPermission((Permission)pf.newPermission("fragment", path, mask));
    }

    public boolean getConstraintsEnabled() {
        if (this.page != null) {
            return this.page.getConstraintsEnabled();
        }
        return false;
    }

    public boolean getPermissionsEnabled() {
        if (this.page != null) {
            return this.page.getPermissionsEnabled();
        }
        return false;
    }

    public void unmarshalled() {
        super.unmarshalled();
        Iterator fragmentIter = this.fragments.iterator();
        while (fragmentIter.hasNext()) {
            ((FragmentImpl)fragmentIter.next()).unmarshalled();
        }
        this.propertiesMap.clear();
        for (PropertyImpl prop : this.propertiesList) {
            this.propertiesMap.put(prop.getName(), prop.getValue());
        }
    }

    public void marshalling() {
        boolean changed;
        boolean bl = changed = this.propertiesMap.size() != this.propertiesList.size();
        if (!changed) {
            Iterator<Object> propsIter = this.propertiesList.iterator();
            while (!changed && propsIter.hasNext()) {
                PropertyImpl propertyImpl = (PropertyImpl)propsIter.next();
                changed = propertyImpl.getValue() != this.propertiesMap.get(propertyImpl.getName());
            }
        }
        if (changed) {
            this.propertiesList.clear();
            for (Map.Entry entry : this.propertiesMap.entrySet()) {
                PropertyImpl listProp = new PropertyImpl();
                listProp.setName((String)entry.getKey());
                listProp.setValue((String)entry.getValue());
                this.propertiesList.add(listProp);
            }
        }
        Iterator fragmentIter = this.fragments.iterator();
        while (fragmentIter.hasNext()) {
            ((FragmentImpl)fragmentIter.next()).marshalling();
        }
        super.marshalling();
    }

    List filterFragmentsByAccess(List fragments) {
        if (fragments != null && !fragments.isEmpty()) {
            ArrayList<Fragment> filteredFragments = null;
            for (Fragment fragment : fragments) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                    if (filteredFragments == null) continue;
                    filteredFragments.add(fragment);
                }
                catch (SecurityException se) {
                    Fragment copyFragment;
                    if (filteredFragments != null) continue;
                    filteredFragments = new ArrayList<Fragment>(fragments.size());
                    Iterator copyIter = fragments.iterator();
                    while (copyIter.hasNext() && (copyFragment = (Fragment)copyIter.next()) != fragment) {
                        filteredFragments.add(copyFragment);
                    }
                }
            }
            if (filteredFragments != null) {
                return new FilteredFragmentList(this, filteredFragments);
            }
        }
        return fragments;
    }

    private static synchronized String generateId() {
        return new StringBuffer("F.").append(Long.toHexString(System.currentTimeMillis())).append(".").append(fragment_id_counter++).toString();
    }
}

