/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.security.AccessController;
import java.security.Permission;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.PageSecurity;
import org.apache.jetspeed.om.page.impl.BaseElementImpl;
import org.apache.jetspeed.om.page.impl.FilteredFragmentList;
import org.apache.jetspeed.om.page.impl.FragmentList;
import org.apache.jetspeed.om.page.impl.FragmentPreferenceList;
import org.apache.jetspeed.om.page.impl.FragmentPropertyMap;
import org.apache.jetspeed.om.page.impl.FragmentSecurityConstraintsImpl;
import org.apache.jetspeed.om.page.impl.PageImpl;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;
import org.apache.jetspeed.security.PermissionFactory;

public class FragmentImpl
extends BaseElementImpl
implements Fragment {
    private List fragments;
    private String type;
    private String skin;
    private String decorator;
    private String state;
    private String mode;
    private int layoutRowProperty = -1;
    private int layoutColumnProperty = -1;
    private String layoutSizesProperty;
    private float layoutXProperty = -1.0f;
    private float layoutYProperty = -1.0f;
    private float layoutZProperty = -1.0f;
    private float layoutWidthProperty = -1.0f;
    private float layoutHeightProperty = -1.0f;
    private String extendedPropertyName1;
    private String extendedPropertyValue1;
    private String extendedPropertyName2;
    private String extendedPropertyValue2;
    private List preferences;
    private FragmentList fragmentsList;
    private FragmentPropertyMap propertiesMap;
    private FragmentPreferenceList fragmentPreferences;
    private PageImpl page;
    private static PermissionFactory pf;

    public static void setPermissionsFactory(PermissionFactory pf) {
        FragmentImpl.pf = pf;
    }

    public FragmentImpl() {
        super(new FragmentSecurityConstraintsImpl());
    }

    List accessFragments() {
        if (this.fragments == null) {
            this.fragments = DatabasePageManagerUtils.createList();
        }
        return this.fragments;
    }

    List accessPreferences() {
        if (this.preferences == null) {
            this.preferences = DatabasePageManagerUtils.createList();
        }
        return this.preferences;
    }

    PageImpl getPage() {
        return this.page;
    }

    void setPage(PageImpl page) {
        this.page = page;
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                ((FragmentImpl)fragmentsIter.next()).setPage(page);
            }
        }
    }

    Fragment getFragmentById(String id) {
        if (this.getId().equals(id)) {
            return this;
        }
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                Fragment matchedFragment = ((FragmentImpl)fragmentsIter.next()).getFragmentById(id);
                if (matchedFragment == null) continue;
                return matchedFragment;
            }
        }
        return null;
    }

    Fragment removeFragmentById(String id) {
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                FragmentImpl fragment = (FragmentImpl)fragmentsIter.next();
                if (!fragment.getId().equals(id)) {
                    Fragment removed = fragment.removeFragmentById(id);
                    if (removed == null) continue;
                    return removed;
                }
                fragmentsIter.remove();
                return fragment;
            }
        }
        return null;
    }

    List getFragmentsByName(String name) {
        List matchedFragments = null;
        if (this.getName() != null && this.getName().equals(name)) {
            if (matchedFragments == null) {
                matchedFragments = DatabasePageManagerUtils.createList();
            }
            matchedFragments.add(this);
        }
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                List matchedChildFragments = ((FragmentImpl)fragmentsIter.next()).getFragmentsByName(name);
                if (matchedChildFragments == null) continue;
                if (matchedFragments == null) {
                    matchedFragments = matchedChildFragments;
                    continue;
                }
                matchedFragments.addAll(matchedChildFragments);
            }
        }
        return matchedFragments;
    }

    List getPropertyMemberKeys() {
        List keys = DatabasePageManagerUtils.createList();
        if (this.layoutRowProperty >= 0) {
            keys.add("row");
        }
        if (this.layoutColumnProperty >= 0) {
            keys.add("column");
        }
        if (this.layoutSizesProperty != null) {
            keys.add("sizes");
        }
        if (this.layoutXProperty >= 0.0f) {
            keys.add("x");
        }
        if (this.layoutYProperty >= 0.0f) {
            keys.add("y");
        }
        if (this.layoutZProperty >= 0.0f) {
            keys.add("z");
        }
        if (this.layoutWidthProperty >= 0.0f) {
            keys.add("width");
        }
        if (this.layoutHeightProperty >= 0.0f) {
            keys.add("height");
        }
        if (this.extendedPropertyName1 != null && this.extendedPropertyValue1 != null) {
            keys.add(this.extendedPropertyName1);
        }
        if (this.extendedPropertyName2 != null && this.extendedPropertyValue2 != null) {
            keys.add(this.extendedPropertyName2);
        }
        return keys;
    }

    String getPropertyMember(String key) {
        if (key.equals("row")) {
            if (this.layoutRowProperty >= 0) {
                return String.valueOf(this.layoutRowProperty);
            }
        } else if (key.equals("column")) {
            if (this.layoutColumnProperty >= 0) {
                return String.valueOf(this.layoutColumnProperty);
            }
        } else {
            if (key.equals("sizes")) {
                return this.layoutSizesProperty;
            }
            if (key.equals("x")) {
                if (this.layoutXProperty >= 0.0f) {
                    return String.valueOf(this.layoutXProperty);
                }
            } else if (key.equals("y")) {
                if (this.layoutYProperty >= 0.0f) {
                    return String.valueOf(this.layoutYProperty);
                }
            } else if (key.equals("z")) {
                if (this.layoutZProperty >= 0.0f) {
                    return String.valueOf(this.layoutZProperty);
                }
            } else if (key.equals("width")) {
                if (this.layoutWidthProperty >= 0.0f) {
                    return String.valueOf(this.layoutWidthProperty);
                }
            } else if (key.equals("height")) {
                if (this.layoutHeightProperty >= 0.0f) {
                    return String.valueOf(this.layoutHeightProperty);
                }
            } else {
                if (key.equals(this.extendedPropertyName1)) {
                    return this.extendedPropertyValue1;
                }
                if (key.equals(this.extendedPropertyName2)) {
                    return this.extendedPropertyValue2;
                }
            }
        }
        return null;
    }

    void setPropertyMember(String key, String value) {
        if (key.equals("row")) {
            this.layoutRowProperty = Integer.parseInt(value);
        } else if (key.equals("column")) {
            this.layoutColumnProperty = Integer.parseInt(value);
        } else if (key.equals("sizes")) {
            this.layoutSizesProperty = value;
        } else if (key.equals("x")) {
            this.layoutXProperty = Float.parseFloat(value);
        } else if (key.equals("y")) {
            this.layoutYProperty = Float.parseFloat(value);
        } else if (key.equals("z")) {
            this.layoutZProperty = Float.parseFloat(value);
        } else if (key.equals("width")) {
            this.layoutWidthProperty = Float.parseFloat(value);
        } else if (key.equals("height")) {
            this.layoutHeightProperty = Float.parseFloat(value);
        } else if (key.equals(this.extendedPropertyName1)) {
            this.extendedPropertyValue1 = value;
        } else if (key.equals(this.extendedPropertyName2)) {
            this.extendedPropertyValue2 = value;
        } else if (this.extendedPropertyName1 == null) {
            this.extendedPropertyName1 = key;
            this.extendedPropertyValue1 = value;
        } else if (this.extendedPropertyName2 == null) {
            this.extendedPropertyName2 = key;
            this.extendedPropertyValue2 = value;
        } else {
            throw new RuntimeException("Unable to set fragment property " + key + ", extended properties already used.");
        }
    }

    void clearPropertyMember(String key) {
        if (key.equals("row")) {
            this.layoutRowProperty = -1;
        } else if (key.equals("column")) {
            this.layoutColumnProperty = -1;
        } else if (key.equals("sizes")) {
            this.layoutSizesProperty = null;
        } else if (key.equals("x")) {
            this.layoutXProperty = -1.0f;
        } else if (key.equals("y")) {
            this.layoutYProperty = -1.0f;
        } else if (key.equals("z")) {
            this.layoutZProperty = -1.0f;
        } else if (key.equals("width")) {
            this.layoutWidthProperty = -1.0f;
        } else if (key.equals("height")) {
            this.layoutHeightProperty = -1.0f;
        } else if (key.equals(this.extendedPropertyName1)) {
            this.extendedPropertyName1 = null;
            this.extendedPropertyValue1 = null;
        } else if (key.equals(this.extendedPropertyName2)) {
            this.extendedPropertyName2 = null;
            this.extendedPropertyValue2 = null;
        }
    }

    public PageSecurity getEffectivePageSecurity() {
        if (this.page != null) {
            return this.page.getEffectivePageSecurity();
        }
        return null;
    }

    public String getLogicalPermissionPath() {
        if (this.page != null && this.getName() != null) {
            return this.page.getLogicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public String getPhysicalPermissionPath() {
        if (this.page != null && this.getName() != null) {
            return this.page.getPhysicalPermissionPath() + "/" + this.getName();
        }
        return null;
    }

    public void resetCachedSecurityConstraints() {
        super.resetCachedSecurityConstraints();
        if (this.fragments != null) {
            Iterator fragmentsIter = this.fragments.iterator();
            while (fragmentsIter.hasNext()) {
                ((FragmentImpl)fragmentsIter.next()).resetCachedSecurityConstraints();
            }
        }
    }

    public void checkPermissions(String path, int mask, boolean checkNodeOnly, boolean checkParentsOnly) throws SecurityException {
        AccessController.checkPermission((Permission)pf.newPermission("fragment", path, mask));
    }

    public boolean getConstraintsEnabled() {
        if (this.page != null) {
            return this.page.getConstraintsEnabled();
        }
        return false;
    }

    public boolean getPermissionsEnabled() {
        if (this.page != null) {
            return this.page.getPermissionsEnabled();
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String skinName) {
        this.skin = skinName;
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decoratorName) {
        this.decorator = decoratorName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List getFragments() {
        if (this.fragmentsList == null) {
            this.fragmentsList = new FragmentList(this);
        }
        return this.filterFragmentsByAccess(this.fragmentsList, true);
    }

    public String getProperty(String propName) {
        return (String)this.getProperties().get(propName);
    }

    public int getIntProperty(String propName) {
        String propValue = (String)this.getProperties().get(propName);
        if (propValue != null) {
            return Integer.parseInt(propValue);
        }
        return -1;
    }

    public float getFloatProperty(String propName) {
        String propValue = (String)this.getProperties().get(propName);
        if (propValue != null) {
            return Float.parseFloat(propValue);
        }
        return -1.0f;
    }

    public Map getProperties() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new FragmentPropertyMap(this);
        }
        return this.propertiesMap;
    }

    public int getLayoutRow() {
        return this.getIntProperty("row");
    }

    public void setLayoutRow(int row) {
        if (row >= 0) {
            this.getProperties().put("row", String.valueOf(row));
        } else {
            this.getProperties().remove("row");
        }
    }

    public int getLayoutColumn() {
        return this.getIntProperty("column");
    }

    public void setLayoutColumn(int column) {
        if (column >= 0) {
            this.getProperties().put("column", String.valueOf(column));
        } else {
            this.getProperties().remove("column");
        }
    }

    public String getLayoutSizes() {
        return this.getProperty("sizes");
    }

    public void setLayoutSizes(String sizes) {
        if (sizes != null) {
            this.getProperties().put("sizes", sizes);
        } else {
            this.getProperties().remove("sizes");
        }
    }

    public float getLayoutX() {
        return this.getFloatProperty("x");
    }

    public void setLayoutX(float x) {
        if (x >= 0.0f) {
            this.getProperties().put("x", String.valueOf(x));
        } else {
            this.getProperties().remove("x");
        }
    }

    public float getLayoutY() {
        return this.getFloatProperty("y");
    }

    public void setLayoutY(float y) {
        if (y >= 0.0f) {
            this.getProperties().put("y", String.valueOf(y));
        } else {
            this.getProperties().remove("y");
        }
    }

    public float getLayoutZ() {
        return this.getFloatProperty("z");
    }

    public void setLayoutZ(float z) {
        if (z >= 0.0f) {
            this.getProperties().put("z", String.valueOf(z));
        } else {
            this.getProperties().remove("z");
        }
    }

    public float getLayoutWidth() {
        return this.getFloatProperty("width");
    }

    public void setLayoutWidth(float width) {
        if (width >= 0.0f) {
            this.getProperties().put("width", String.valueOf(width));
        } else {
            this.getProperties().remove("width");
        }
    }

    public float getLayoutHeight() {
        return this.getFloatProperty("height");
    }

    public void setLayoutHeight(float height) {
        if (height >= 0.0f) {
            this.getProperties().put("height", String.valueOf(height));
        } else {
            this.getProperties().remove("height");
        }
    }

    public boolean isReference() {
        return false;
    }

    public List getPreferences() {
        if (this.fragmentPreferences == null) {
            this.fragmentPreferences = new FragmentPreferenceList(this);
        }
        return this.fragmentPreferences;
    }

    public void setPreferences(List preferences) {
        List fragmentPreferences = this.getPreferences();
        if (preferences != fragmentPreferences) {
            fragmentPreferences.clear();
            if (preferences != null) {
                fragmentPreferences.addAll(preferences);
            }
        }
    }

    List filterFragmentsByAccess(List fragments, boolean mutable) {
        if (fragments != null && !fragments.isEmpty()) {
            List filteredFragments = null;
            for (Fragment fragment : fragments) {
                try {
                    fragment.checkAccess(JetspeedActions.VIEW);
                    if (filteredFragments == null) continue;
                    filteredFragments.add(fragment);
                }
                catch (SecurityException se) {
                    Fragment copyFragment;
                    if (filteredFragments != null) continue;
                    filteredFragments = DatabasePageManagerUtils.createList();
                    Iterator copyIter = fragments.iterator();
                    while (copyIter.hasNext() && (copyFragment = (Fragment)copyIter.next()) != fragment) {
                        filteredFragments.add(copyFragment);
                    }
                }
            }
            if (filteredFragments != null) {
                if (!filteredFragments.isEmpty()) {
                    if (mutable) {
                        return new FilteredFragmentList(this, filteredFragments);
                    }
                    return filteredFragments;
                }
                return new FilteredFragmentList(this, filteredFragments);
            }
        }
        return fragments;
    }
}

