/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.folder.MenuDefinition;
import org.apache.jetspeed.om.folder.MenuExcludeDefinition;
import org.apache.jetspeed.om.folder.MenuIncludeDefinition;
import org.apache.jetspeed.om.folder.MenuOptionsDefinition;
import org.apache.jetspeed.om.folder.MenuSeparatorDefinition;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentFragmentImpl;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.Fragment;
import org.apache.jetspeed.om.page.Page;
import org.apache.jetspeed.om.portlet.GenericMetadata;
import org.apache.jetspeed.page.document.Node;

public class ContentPageImpl
implements ContentPage {
    private final Page page;
    private final Map cachedFragments;
    private ContentFragment rootContentFragment;
    private boolean dirty = false;

    public ContentPageImpl(Page page) {
        this.page = page;
        this.cachedFragments = new HashMap();
    }

    public void setRootContentFragment(ContentFragment frag) {
        this.rootContentFragment = frag;
    }

    public String toString() {
        return this.page.toString();
    }

    public ContentFragment getContentFragmentById(String id) {
        ContentFragment contentFragment = null;
        if (this.cachedFragments.containsKey(id)) {
            contentFragment = (ContentFragment)this.cachedFragments.get(id);
        } else {
            Fragment f = this.page.getFragmentById(id);
            if (f != null) {
                contentFragment = new ContentFragmentImpl(f, this.cachedFragments);
                this.cachedFragments.put(id, contentFragment);
            }
        }
        return contentFragment;
    }

    public Fragment getFragmentById(String id) {
        return this.getContentFragmentById(id);
    }

    public Fragment removeFragmentById(String id) {
        Fragment removed = this.page.removeFragmentById(id);
        if (removed != null) {
            if (this.rootContentFragment != null && this.rootContentFragment.getId().equals(id)) {
                this.rootContentFragment = null;
            }
            this.cachedFragments.clear();
        }
        return removed;
    }

    public List getContentFragmentsByName(String name) {
        List fragments = this.page.getFragmentsByName(name);
        if (fragments == null) {
            return null;
        }
        ListIterator<ContentFragment> fragmentsIter = fragments.listIterator();
        while (fragmentsIter.hasNext()) {
            Fragment fragment = (Fragment)fragmentsIter.next();
            String fragmentId = fragment.getId();
            ContentFragment contentFragment = (ContentFragment)this.cachedFragments.get(fragmentId);
            if (contentFragment == null) {
                contentFragment = new ContentFragmentImpl(fragment, this.cachedFragments);
                this.cachedFragments.put(fragmentId, contentFragment);
            }
            fragmentsIter.set(contentFragment);
        }
        return null;
    }

    public List getFragmentsByName(String name) {
        return this.getContentFragmentsByName(name);
    }

    public ContentFragment getRootContentFragment() {
        if (this.rootContentFragment == null) {
            this.rootContentFragment = new ContentFragmentImpl(this.page.getRootFragment(), this.cachedFragments);
            this.cachedFragments.put(this.rootContentFragment.getId(), this.rootContentFragment);
        }
        return this.rootContentFragment;
    }

    public Fragment getRootFragment() {
        return this.getRootContentFragment();
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        return this.page.getEffectiveDefaultDecorator(fragmentType);
    }

    public String getDefaultDecorator(String fragmentType) {
        return this.page.getDefaultDecorator(fragmentType);
    }

    public String getSkin() {
        return this.page.getSkin();
    }

    public void setDefaultDecorator(String decoratorName, String fragmentType) {
        this.page.setDefaultDecorator(decoratorName, fragmentType);
    }

    public void setSkin(String skinName) {
        this.page.setSkin(skinName);
    }

    public void setRootFragment(Fragment fragment) {
        this.page.setRootFragment(fragment);
    }

    public List getMenuDefinitions() {
        return this.page.getMenuDefinitions();
    }

    public MenuDefinition newMenuDefinition() {
        return this.page.newMenuDefinition();
    }

    public MenuExcludeDefinition newMenuExcludeDefinition() {
        return this.page.newMenuExcludeDefinition();
    }

    public MenuIncludeDefinition newMenuIncludeDefinition() {
        return this.page.newMenuIncludeDefinition();
    }

    public MenuOptionsDefinition newMenuOptionsDefinition() {
        return this.page.newMenuOptionsDefinition();
    }

    public MenuSeparatorDefinition newMenuSeparatorDefinition() {
        return this.page.newMenuSeparatorDefinition();
    }

    public void setMenuDefinitions(List definitions) {
        this.page.setMenuDefinitions(definitions);
    }

    public GenericMetadata getMetadata() {
        return this.page.getMetadata();
    }

    public String getName() {
        return this.page.getName();
    }

    public Node getParent() {
        return this.page.getParent();
    }

    public String getPath() {
        return this.page.getPath();
    }

    public String getShortTitle(Locale locale) {
        return this.page.getShortTitle(locale);
    }

    public String getTitle(Locale locale) {
        return this.page.getTitle(locale);
    }

    public String getType() {
        return this.page.getType();
    }

    public String getUrl() {
        return this.page.getUrl();
    }

    public boolean isHidden() {
        return this.page.isHidden();
    }

    public void setHidden(boolean hidden) {
        this.page.setHidden(hidden);
    }

    public void setParent(Node parent) {
        this.page.setParent(parent);
    }

    public void setPath(String path) {
        this.page.setPath(path);
    }

    public void checkAccess(String actions) throws SecurityException {
        this.page.checkAccess(actions);
    }

    public void checkConstraints(String actions) throws SecurityException {
        this.page.checkConstraints(actions);
    }

    public void checkPermissions(int mask) throws SecurityException {
        this.page.checkPermissions(mask);
    }

    public boolean getConstraintsEnabled() {
        return this.page.getConstraintsEnabled();
    }

    public boolean getPermissionsEnabled() {
        return this.page.getPermissionsEnabled();
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.page.getSecurityConstraints();
    }

    public SecurityConstraints newSecurityConstraints() {
        return this.page.newSecurityConstraints();
    }

    public SecurityConstraint newSecurityConstraint() {
        return this.page.newSecurityConstraint();
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.page.setSecurityConstraints(constraints);
    }

    public String getId() {
        return this.page.getId();
    }

    public String getShortTitle() {
        return this.page.getShortTitle();
    }

    public String getTitle() {
        return this.page.getTitle();
    }

    public void setShortTitle(String title) {
        this.page.setShortTitle(title);
    }

    public void setTitle(String title) {
        this.page.setTitle(title);
    }

    public Page getPage() {
        return this.page;
    }

    public String getVersion() {
        return this.page.getVersion();
    }

    public void setVersion(String version) {
        this.page.setVersion(version);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

