/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.folder.impl;

import java.util.AbstractList;
import java.util.List;
import org.apache.jetspeed.om.folder.impl.FolderImpl;
import org.apache.jetspeed.om.folder.impl.FolderOrder;
import org.apache.jetspeed.page.impl.DatabasePageManagerUtils;

class FolderOrderList
extends AbstractList {
    private FolderImpl folder;
    private List removedFolderOrders;

    FolderOrderList(FolderImpl folder) {
        this.folder = folder;
    }

    private FolderOrder wrapNameStringForAdd(String name) {
        int removedIndex;
        if (name == null) {
            throw new NullPointerException("Unable to add null to list.");
        }
        FolderOrder folderOrder = new FolderOrder();
        folderOrder.setName(name);
        if (this.folder.accessFolderOrders().contains(folderOrder)) {
            throw new IllegalArgumentException("Unable to add duplicate entry to list: " + folderOrder.getName());
        }
        if (this.removedFolderOrders != null && (removedIndex = this.removedFolderOrders.indexOf(folderOrder)) >= 0) {
            folderOrder = (FolderOrder)this.removedFolderOrders.remove(removedIndex);
        }
        return folderOrder;
    }

    private List getRemovedFolderOrders() {
        if (this.removedFolderOrders == null) {
            this.removedFolderOrders = DatabasePageManagerUtils.createList();
        }
        return this.removedFolderOrders;
    }

    public void add(int index, Object element) {
        FolderOrder nextFolderOrder;
        if (index < 0 || index > this.folder.accessFolderOrders().size()) {
            throw new IndexOutOfBoundsException("Unable to add to list at index: " + index);
        }
        FolderOrder folderOrder = this.wrapNameStringForAdd((String)element);
        this.folder.accessFolderOrders().add(index, folderOrder);
        if (index > 0) {
            folderOrder.setSortOrder(((FolderOrder)this.folder.accessFolderOrders().get(index - 1)).getSortOrder() + 1);
        } else {
            folderOrder.setSortOrder(0);
        }
        int limit = this.folder.accessFolderOrders().size() - 1;
        for (int i = index; i < limit && (nextFolderOrder = (FolderOrder)this.folder.accessFolderOrders().get(i + 1)).getSortOrder() <= folderOrder.getSortOrder(); ++i) {
            nextFolderOrder.setSortOrder(folderOrder.getSortOrder() + 1);
            folderOrder = nextFolderOrder;
        }
        this.folder.clearDocumentOrderComparator();
    }

    public Object get(int index) {
        return ((FolderOrder)this.folder.accessFolderOrders().get(index)).getName();
    }

    public Object remove(int index) {
        FolderOrder removed = (FolderOrder)this.folder.accessFolderOrders().remove(index);
        if (removed != null) {
            this.getRemovedFolderOrders().add(removed);
            this.folder.clearDocumentOrderComparator();
        }
        return removed;
    }

    public Object set(int index, Object element) {
        FolderOrder newFolderOrder = this.wrapNameStringForAdd((String)element);
        FolderOrder folderOrder = this.folder.accessFolderOrders().set(index, newFolderOrder);
        newFolderOrder.setSortOrder(folderOrder.getSortOrder());
        this.getRemovedFolderOrders().add(folderOrder);
        this.folder.clearDocumentOrderComparator();
        return folderOrder.getName();
    }

    public int size() {
        return this.folder.accessFolderOrders().size();
    }
}

