/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.layout.impl.PageLayoutComponentUtils;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.om.page.FragmentDefinition;
import org.apache.jetspeed.om.page.PageTemplate;
import org.apache.jetspeed.om.page.impl.ContentFragmentImpl;
import org.apache.jetspeed.om.page.impl.ContentGenericMetadataImpl;
import org.apache.jetspeed.om.portlet.GenericMetadata;

public class ContentPageImpl
implements ContentPage,
PageLayoutComponentUtils {
    private PageLayoutComponent pageLayoutComponent;
    private String id;
    private BaseFragmentsElement pageOrTemplate;
    private PageTemplate pageTemplate;
    private Map<String, FragmentDefinition> fragmentDefinitions;
    private ContentFragmentImpl rootContentFragment;
    private GenericMetadata metadata;
    private Map defaultDecorators;
    private Map effectiveDefaultDecorators;
    private String name;
    private String path;
    private String shortTitle;
    private String skin;
    private String title;
    private String url;
    private boolean hidden;
    private String contentType;
    private String defId;
    private boolean inheritable;

    public ContentPageImpl() {
        this.id = Integer.toHexString(System.identityHashCode(this));
    }

    public ContentPageImpl(String id) {
        this.id = id;
    }

    public ContentPageImpl(PageLayoutComponent pageLayoutComponent, String id, BaseFragmentsElement pageOrTemplate, PageTemplate pageTemplate, Map<String, FragmentDefinition> fragmentDefinitions) {
        this.pageLayoutComponent = pageLayoutComponent;
        this.id = id;
        this.pageOrTemplate = pageOrTemplate;
        this.pageTemplate = pageTemplate;
        this.fragmentDefinitions = fragmentDefinitions;
    }

    public void checkAccess(String actions) throws SecurityException {
        if (this.pageOrTemplate != null) {
            this.pageOrTemplate.checkAccess(actions);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ContentPageImpl) {
            ContentPageImpl cpi = (ContentPageImpl)o;
            return this.id == null && cpi.id == null || this.id != null && this.id.equals(cpi.id);
        }
        return false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDefId() {
        return this.defId;
    }

    public String getDefaultDecorator(String fragmentType) {
        return this.defaultDecorators != null ? (String)this.defaultDecorators.get(fragmentType) : null;
    }

    public String getEffectiveDefaultDecorator(String fragmentType) {
        return this.effectiveDefaultDecorators != null ? (String)this.effectiveDefaultDecorators.get(fragmentType) : null;
    }

    public Map<String, FragmentDefinition> getFragmentDefinitions() {
        return this.fragmentDefinitions;
    }

    public ContentFragment getFragmentById(String id) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentById(id, null);
        }
        return null;
    }

    public ContentFragment getFragmentByFragmentId(String id) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentByFragmentId(id, false);
        }
        return null;
    }

    public List<ContentFragment> getFragmentsByName(String name) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentsByName(name, false);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public GenericMetadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ContentGenericMetadataImpl();
        }
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public BaseFragmentsElement getPageOrTemplate() {
        return this.pageOrTemplate;
    }

    public PageLayoutComponent getPageLayoutComponent() {
        return this.pageLayoutComponent;
    }

    public PageTemplate getPageTemplate() {
        return this.pageTemplate;
    }

    public String getPath() {
        return this.path;
    }

    public ContentFragment getRootFragment() {
        return this.rootContentFragment;
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getShortTitle(Locale locale) {
        String localeSpecificShortTitle = this.getMetadata().getText("short-title", locale);
        if (localeSpecificShortTitle == null) {
            localeSpecificShortTitle = this.getMetadata().getText("title", locale);
        }
        return localeSpecificShortTitle != null ? localeSpecificShortTitle : (this.shortTitle != null ? this.shortTitle : this.title);
    }

    public String getSkin() {
        return this.skin;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitle(Locale locale) {
        String localeSpecificTitle = this.getMetadata().getText("title", locale);
        return localeSpecificTitle != null ? localeSpecificTitle : this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public void overrideDefaultDecorator(String decoratorName, String fragmentType) {
        if (decoratorName != null && decoratorName.length() > 0) {
            if (this.effectiveDefaultDecorators == null) {
                this.effectiveDefaultDecorators = new HashMap();
            }
            this.effectiveDefaultDecorators.put(fragmentType, decoratorName);
        } else if (this.effectiveDefaultDecorators != null) {
            this.effectiveDefaultDecorators.remove(fragmentType);
        }
    }

    public ContentFragment getFragmentByFragmentId(String id, boolean nonTemplate) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentByFragmentId(id, nonTemplate);
        }
        return null;
    }

    public List<ContentFragment> getFragmentsByName(String name, boolean nonTemplate) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentsByName(name, nonTemplate);
        }
        return null;
    }

    public ContentFragment getNonTemplateRootFragment() {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getNonTemplateLayoutFragment();
        }
        return null;
    }

    public ContentFragment addFragmentAtRowColumn(ContentFragment fragment, int row, int column) {
        if (this.pageLayoutComponent != null) {
            return this.pageLayoutComponent.addFragmentAtRowColumn((ContentPage)this, fragment, row, column);
        }
        ContentFragmentImpl contentFragmentImpl = (ContentFragmentImpl)fragment;
        if (!PageLayoutComponentUtils.Utils.isNull(row)) {
            contentFragmentImpl.setLayoutRow(row);
        }
        if (!PageLayoutComponentUtils.Utils.isNull(column)) {
            contentFragmentImpl.setLayoutColumn(column);
        }
        ContentFragmentImpl rootContentFragmentImpl = (ContentFragmentImpl)this.getRootFragment();
        rootContentFragmentImpl.getFragments().add(contentFragmentImpl);
        return contentFragmentImpl;
    }

    public ContentFragment addFragmentReference(String id) {
        if (this.pageLayoutComponent != null) {
            return this.pageLayoutComponent.addFragmentReference((ContentPage)this, id);
        }
        ContentFragmentImpl newContentFragmentImpl = new ContentFragmentImpl();
        newContentFragmentImpl.setType("reference");
        newContentFragmentImpl.setRefId(id);
        ContentFragmentImpl rootContentFragmentImpl = (ContentFragmentImpl)this.getRootFragment();
        rootContentFragmentImpl.getFragments().add(newContentFragmentImpl);
        return newContentFragmentImpl;
    }

    public ContentFragment addPortlet(String type, String name) {
        if (this.pageLayoutComponent != null) {
            return this.pageLayoutComponent.addPortlet((ContentPage)this, type, name);
        }
        ContentFragmentImpl newContentFragmentImpl = new ContentFragmentImpl();
        newContentFragmentImpl.setType(type);
        newContentFragmentImpl.setName(name);
        ContentFragmentImpl rootContentFragmentImpl = (ContentFragmentImpl)this.getRootFragment();
        rootContentFragmentImpl.getFragments().add(newContentFragmentImpl);
        return newContentFragmentImpl;
    }

    public void decrementFolderInDocumentOrder() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.decrementFolderInDocumentOrder((ContentPage)this);
        }
    }

    public void decrementInDocumentOrder() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.decrementInDocumentOrder((ContentPage)this);
        }
    }

    public int getFragmentNestingLevel(String fragmentId) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentNestingLevel(fragmentId, 0);
        }
        return -1;
    }

    public void incrementFolderInDocumentOrder() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.incrementFolderInDocumentOrder((ContentPage)this);
        }
    }

    public void incrementInDocumentOrder() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.incrementInDocumentOrder((ContentPage)this);
        }
    }

    public void moveFragment(String fragmentId, String fromFragmentId, String toFragmentId) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.moveFragment((ContentPage)this, fragmentId, fromFragmentId, toFragmentId);
        } else {
            ContentFragmentImpl fromContentFragmentImpl = (ContentFragmentImpl)this.getFragmentById(fromFragmentId);
            ContentFragmentImpl contentFragmentImpl = fromContentFragmentImpl.getFragmentById(fragmentId);
            ContentFragmentImpl toContentFragmentImpl = (ContentFragmentImpl)this.getFragmentById(toFragmentId);
            if (contentFragmentImpl != null && fromContentFragmentImpl != null && toContentFragmentImpl != null) {
                fromContentFragmentImpl.removeFragmentById(fragmentId);
                toContentFragmentImpl.getFragments().add(contentFragmentImpl);
            }
        }
    }

    public void newSiblingFolder(String folderName, String folderTitle, String folderShortTitle, String defaultPageLayoutName) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.newSiblingFolder((ContentPage)this, folderName, folderTitle, folderShortTitle, defaultPageLayoutName);
        }
    }

    public void newSiblingPage(String pageName, String layoutName, String pageTitle, String pageShortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.newSiblingPage((ContentPage)this, pageName, layoutName, pageTitle, pageShortTitle);
        }
    }

    public void newSiblingDynamicPage(String pageName, String contentType, String layoutName, String pageTitle, String pageShortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.newSiblingDynamicPage((ContentPage)this, pageName, contentType, layoutName, pageTitle, pageShortTitle);
        }
    }

    public void newSiblingPageTemplate(String templateName, String layoutName, String templateTitle, String templateShortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.newSiblingPageTemplate((ContentPage)this, templateName, layoutName, templateTitle, templateShortTitle);
        }
    }

    public void newSiblingFragmentDefinition(String definitionName, String defId, String portletName, String definitionTitle, String definitionShortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.newSiblingFragmentDefinition((ContentPage)this, definitionName, defId, portletName, definitionTitle, definitionShortTitle);
        }
    }

    public void removeFragment(String fragmentId) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.removeFragment((ContentPage)this, fragmentId);
        } else {
            this.removeFragmentById(fragmentId);
        }
    }

    public void remove() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.remove((ContentPage)this);
        }
    }

    public void removeFolder() {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.removeFolder((ContentPage)this);
        }
    }

    public void updateContent(String contentType, Boolean inheritable) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateContent((ContentPage)this, contentType, inheritable);
        } else {
            if (!PageLayoutComponentUtils.Utils.isNull(contentType)) {
                this.setContentType(contentType);
            }
            if (inheritable != null) {
                this.setInheritable(inheritable);
            }
        }
    }

    public void updateDefaultDecorator(String decoratorName, String fragmentType) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateDefaultDecorator((ContentPage)this, decoratorName, fragmentType);
        } else {
            String string = decoratorName = !PageLayoutComponentUtils.Utils.isNull(decoratorName) ? decoratorName : null;
            if (decoratorName != null) {
                if (this.effectiveDefaultDecorators == null) {
                    this.effectiveDefaultDecorators = new HashMap();
                }
                this.effectiveDefaultDecorators.put(fragmentType, decoratorName);
            } else if (this.effectiveDefaultDecorators != null) {
                this.effectiveDefaultDecorators.remove(fragmentType);
            }
        }
    }

    public void updateFolderTitles(String title, String shortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateFolderTitles((ContentPage)this, title, shortTitle);
        }
    }

    public void updateTitles(String title, String shortTitle) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateTitles((ContentPage)this, title, shortTitle);
        } else {
            if (!PageLayoutComponentUtils.Utils.isNull(title)) {
                this.setTitle(title);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(shortTitle)) {
                this.setShortTitle(shortTitle);
            }
        }
    }

    public ContentFragmentImpl getPageRootContentFragment() {
        if (this.rootContentFragment != null) {
            if (this.pageOrTemplate != null) {
                return this.rootContentFragment.getFragmentByDefinition(this.pageOrTemplate);
            }
            return this.rootContentFragment;
        }
        return null;
    }

    public ContentFragmentImpl getFragmentById(String id, ContentFragmentImpl[] parentFragment) {
        if (this.rootContentFragment != null) {
            return this.rootContentFragment.getFragmentById(id, parentFragment);
        }
        return null;
    }

    public ContentFragmentImpl removeFragmentById(String id) {
        ContentFragmentImpl removed = null;
        if (this.rootContentFragment != null) {
            if (this.rootContentFragment.getId().equals(id)) {
                removed = this.rootContentFragment;
                this.rootContentFragment = null;
            } else {
                removed = this.rootContentFragment.removeFragmentById(id);
            }
        }
        return removed;
    }

    public void setDefaultDecorators(Map defaultDecorators) {
        this.defaultDecorators = defaultDecorators;
    }

    public void setEffectiveDefaultDecorators(Map effectiveDefaultDecorators) {
        this.effectiveDefaultDecorators = effectiveDefaultDecorators;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRootFragment(ContentFragmentImpl rootContentFragment) {
        this.rootContentFragment = rootContentFragment;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDefId(String defId) {
        this.defId = defId;
    }

    public void setInheritable(boolean inheritable) {
        this.inheritable = inheritable;
    }
}

