/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.page.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.aggregator.PortletContent;
import org.apache.jetspeed.decoration.Decoration;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.layout.impl.PageLayoutComponentUtils;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.BaseFragmentElement;
import org.apache.jetspeed.om.page.BaseFragmentsElement;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.FragmentProperty;
import org.apache.jetspeed.om.page.FragmentReference;
import org.apache.jetspeed.om.page.impl.ContentFragmentPreferenceImpl;
import org.apache.jetspeed.om.page.impl.ContentFragmentPropertyImpl;
import org.apache.jetspeed.om.page.impl.ContentSecurityConstraint;
import org.apache.jetspeed.om.page.impl.ContentSecurityConstraints;
import org.apache.jetspeed.om.preference.FragmentPreference;
import org.apache.pluto.container.PortletPreference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFragmentImpl
implements ContentFragment,
PageLayoutComponentUtils {
    private static final Logger log = LoggerFactory.getLogger(ContentFragmentImpl.class);
    private PageLayoutComponent pageLayoutComponent;
    private String id;
    private BaseFragmentsElement pageOrTemplate;
    private BaseFragmentsElement definition;
    private BaseFragmentElement fragment;
    private BaseFragmentsElement referenceDefinition;
    private FragmentReference reference;
    private boolean instantlyRendered;
    private boolean template;
    private boolean locked;
    private StringBuffer overriddenContent;
    private PortletContent portletContent;
    private Decoration decoration;
    private List properties;
    private List fragments;
    private String name;
    private List preferences;
    private String shortTitle;
    private String title;
    private String type;
    private SecurityConstraints constraints;
    private String refId;
    private long refreshRate = -1L;
    private String refreshFunction = null;

    public ContentFragmentImpl() {
        this.id = Integer.toHexString(System.identityHashCode(this));
    }

    public ContentFragmentImpl(String id) {
        this.id = id;
    }

    public ContentFragmentImpl(String id, boolean instantlyRendered) {
        this.id = id;
        this.instantlyRendered = instantlyRendered;
        this.locked = instantlyRendered;
    }

    public ContentFragmentImpl(PageLayoutComponent pageLayoutComponent, String id, BaseFragmentsElement pageOrTemplate, BaseFragmentsElement definition, BaseFragmentElement fragment, BaseFragmentsElement referenceDefinition, FragmentReference reference, boolean template, boolean locked) {
        this.pageLayoutComponent = pageLayoutComponent;
        this.id = id;
        this.pageOrTemplate = pageOrTemplate;
        this.definition = definition;
        this.fragment = fragment;
        this.referenceDefinition = referenceDefinition;
        this.reference = reference;
        this.template = template;
        this.locked = locked;
    }

    public SecurityConstraints getSecurityConstraints() {
        return this.constraints;
    }

    public SecurityConstraint newSecurityConstraint() {
        return new ContentSecurityConstraint(true, null, null, null, null);
    }

    public SecurityConstraints newSecurityConstraints() {
        return new ContentSecurityConstraints(true, null, null, null);
    }

    public void checkAccess(String actions) throws SecurityException {
        if (this.fragment != null) {
            this.fragment.checkAccess(actions);
        }
    }

    public boolean isInstantlyRendered() {
        return this.instantlyRendered;
    }

    public boolean equals(Object o) {
        if (o instanceof ContentFragmentImpl) {
            ContentFragmentImpl cfi = (ContentFragmentImpl)o;
            return this.id == null && cfi.id == null || this.id != null && this.id.equals(cfi.id);
        }
        return false;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public String getDecorator() {
        return this.getProperty("decorator");
    }

    public float getFloatProperty(String propName) {
        String propValue = this.getProperty(propName);
        if (propValue != null) {
            return Float.parseFloat(propValue);
        }
        return -1.0f;
    }

    public float getFloatProperty(String propName, String scope, String scopeValue) {
        String propValue = this.getProperty(propName, scope, scopeValue);
        if (propValue != null) {
            return Float.parseFloat(propValue);
        }
        return -1.0f;
    }

    public String getFragmentId() {
        return this.fragment != null ? this.fragment.getId() : null;
    }

    public List getFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList();
        }
        return this.fragments;
    }

    public String getId() {
        return this.id;
    }

    public int getIntProperty(String propName) {
        String propValue = this.getProperty(propName);
        if (propValue != null) {
            return Integer.parseInt(propValue);
        }
        return -1;
    }

    public int getIntProperty(String propName, String scope, String scopeValue) {
        String propValue = this.getProperty(propName, scope, scopeValue);
        if (propValue != null) {
            return Integer.parseInt(propValue);
        }
        return -1;
    }

    public int getLayoutColumn() {
        return this.getIntProperty("column");
    }

    public float getLayoutHeight() {
        return this.getFloatProperty("height");
    }

    public int getLayoutRow() {
        return this.getIntProperty("row");
    }

    public String getLayoutSizes() {
        return this.getProperty("sizes");
    }

    public float getLayoutWidth() {
        return this.getFloatProperty("width");
    }

    public float getLayoutX() {
        return this.getFloatProperty("x");
    }

    public float getLayoutY() {
        return this.getFloatProperty("y");
    }

    public float getLayoutZ() {
        return this.getFloatProperty("z");
    }

    public String getMode() {
        return this.getProperty("mode");
    }

    public String getName() {
        return this.name;
    }

    public String getOverriddenContent() {
        return this.overriddenContent != null ? this.overriddenContent.toString() : null;
    }

    public PageLayoutComponent getPageLayoutComponent() {
        return this.pageLayoutComponent;
    }

    public PortletContent getPortletContent() {
        return this.portletContent;
    }

    public List<FragmentPreference> getPreferences() {
        if (this.preferences == null) {
            this.preferences = new ArrayList();
        }
        return this.preferences;
    }

    public List<FragmentProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        return this.properties;
    }

    public Map<String, String> getPropertiesMap() {
        HashSet<String> propertyNames = new HashSet<String>();
        for (FragmentProperty fragmentProperty : this.getProperties()) {
            propertyNames.add(fragmentProperty.getName());
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            String propertyValue = this.getProperty(propertyName);
            if (propertyValue == null) continue;
            propertiesMap.put(propertyName, propertyValue);
        }
        return propertiesMap;
    }

    public String getProperty(String propName) {
        String userValue = null;
        String groupValue = null;
        String roleValue = null;
        String globalValue = null;
        Iterator<FragmentProperty> propertiesIter = this.getProperties().iterator();
        while (userValue == null && propertiesIter.hasNext()) {
            FragmentProperty fragmentProperty = propertiesIter.next();
            if (!fragmentProperty.getName().equals(propName)) continue;
            String fragmentPropertyScope = fragmentProperty.getScope();
            if (fragmentPropertyScope != null) {
                if (!fragmentPropertyScope.equals("user")) continue;
                userValue = fragmentProperty.getValue();
                continue;
            }
            if (groupValue != null || roleValue != null || globalValue != null) continue;
            globalValue = fragmentProperty.getValue();
        }
        return userValue != null ? userValue : (groupValue != null ? groupValue : (roleValue != null ? roleValue : globalValue));
    }

    public String getProperty(String propName, String scope, String scopeValue) {
        for (FragmentProperty fragmentProperty : this.getProperties()) {
            String fragmentPropertyScopeValue;
            if (!fragmentProperty.getName().equals(propName)) continue;
            String fragmentPropertyScope = fragmentProperty.getScope();
            if (fragmentPropertyScope == null && scope == null) {
                return fragmentProperty.getValue();
            }
            if (fragmentPropertyScope == null || !fragmentPropertyScope.equals(scope)) continue;
            if (scopeValue == null && scope.equals("user")) {
                scopeValue = PageLayoutComponentUtils.Utils.getCurrentUserScopeValue();
            }
            if (((fragmentPropertyScopeValue = fragmentProperty.getScopeValue()) != null || scopeValue != null) && (fragmentPropertyScopeValue == null || !fragmentPropertyScopeValue.equals(scopeValue))) continue;
            return fragmentProperty.getValue();
        }
        return null;
    }

    public String getRefId() {
        return this.refId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRenderedContent() throws IllegalStateException {
        if (this.overriddenContent != null) {
            return this.overriddenContent.toString();
        }
        if (this.portletContent != null) {
            PortletContent portletContent = this.portletContent;
            synchronized (portletContent) {
                String string;
                if (this.portletContent.isComplete()) {
                    return this.portletContent.getContent();
                }
                try {
                    log.debug("Waiting on content for Fragment " + this.getId());
                    this.portletContent.wait();
                    string = this.portletContent.getContent();
                }
                catch (InterruptedException e) {
                    String string2;
                    try {
                        string2 = e.getMessage();
                    }
                    catch (Throwable throwable) {
                        log.debug("Been notified that Faragment " + this.getId() + " is complete");
                        throw throwable;
                    }
                    log.debug("Been notified that Faragment " + this.getId() + " is complete");
                    return string2;
                }
                log.debug("Been notified that Faragment " + this.getId() + " is complete");
                return string;
            }
        }
        throw new IllegalStateException("You cannot invoke getRenderedContent() until the content has been set.");
    }

    public String getShortTitle() {
        return this.shortTitle;
    }

    public String getSkin() {
        return this.getProperty("skin");
    }

    public String getState() {
        return this.getProperty("state");
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public void overrideRenderedContent(String content) {
        if (content != null) {
            if (this.overriddenContent == null) {
                this.overriddenContent = new StringBuffer();
            }
            if (!content.equals(this.overriddenContent.toString())) {
                this.overriddenContent.append(content);
            }
        }
    }

    public void setDecoration(Decoration decoration) {
        this.decoration = decoration;
    }

    public void setPortletContent(PortletContent portletContent) {
        this.portletContent = portletContent;
    }

    public ContentFragment addPortlet(String type, String name, int row, int column) {
        if (this.pageLayoutComponent != null) {
            return this.pageLayoutComponent.addPortlet((ContentFragment)this, type, name, row, column);
        }
        ContentFragmentImpl newContentFragmentImpl = new ContentFragmentImpl();
        newContentFragmentImpl.setType(type);
        newContentFragmentImpl.setType(name);
        if (!PageLayoutComponentUtils.Utils.isNull(row)) {
            newContentFragmentImpl.setLayoutRow(row);
        }
        if (!PageLayoutComponentUtils.Utils.isNull(column)) {
            newContentFragmentImpl.setLayoutColumn(column);
        }
        this.getFragments().add(newContentFragmentImpl);
        return newContentFragmentImpl;
    }

    public ContentFragment addPortlet(String type, String name) {
        if (this.pageLayoutComponent != null) {
            return this.pageLayoutComponent.addPortlet((ContentFragment)this, type, name);
        }
        ContentFragmentImpl newContentFragmentImpl = new ContentFragmentImpl();
        newContentFragmentImpl.setType(type);
        newContentFragmentImpl.setType(name);
        this.getFragments().add(newContentFragmentImpl);
        return newContentFragmentImpl;
    }

    public void updateDecorator(String decoratorName) {
        this.updateDecorator(decoratorName, null, null);
    }

    public void updateDecorator(String decoratorName, String scope, String scopeValue) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateDecorator((ContentFragment)this, decoratorName, scope, scopeValue);
        } else {
            decoratorName = !PageLayoutComponentUtils.Utils.isNull(decoratorName) ? decoratorName : null;
            this.setDecorator(scope, scopeValue, decoratorName);
        }
    }

    public void updateName(String name) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateName((ContentFragment)this, name);
        } else {
            this.setName(name);
        }
    }

    public void updatePosition(float x, float y, float z, float width, float height) {
        this.updatePosition(x, y, z, width, height, null, null);
    }

    public void updatePosition(float x, float y, float z, float width, float height, String scope, String scopeValue) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updatePosition((ContentFragment)this, x, y, z, width, height, scope, scopeValue);
        } else {
            if (!PageLayoutComponentUtils.Utils.isNull(x)) {
                this.setLayoutX(scope, scopeValue, x);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(y)) {
                this.setLayoutY(scope, scopeValue, y);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(z)) {
                this.setLayoutZ(scope, scopeValue, z);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(width)) {
                this.setLayoutWidth(scope, scopeValue, width);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(height)) {
                this.setLayoutWidth(scope, scopeValue, height);
            }
        }
    }

    public void updatePreferences(Map<String, ?> preferences) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updatePreferences((ContentFragment)this, preferences);
        } else {
            this.setPreferences(preferences);
        }
    }

    public void updateProperty(String propName, String propValue) {
        this.updateProperty(propName, propValue, null, null);
    }

    public void updateProperty(String propName, String propValue, String scope, String scopeValue) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateProperty((ContentFragment)this, propName, propValue, scope, scopeValue);
        } else {
            this.setProperty(propName, scope, scopeValue, propValue);
        }
    }

    public void updateRefId(String refId) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateRefId((ContentFragment)this, refId);
        } else {
            this.setRefId(refId);
        }
    }

    public void updateRowColumn(int row, int column) {
        this.updateRowColumn(row, column, null, null);
    }

    public void updateRowColumn(int row, int column, String scope, String scopeValue) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateRowColumn((ContentFragment)this, row, column, scope, scopeValue);
        } else {
            if (!PageLayoutComponentUtils.Utils.isNull(row)) {
                this.setLayoutRow(scope, scopeValue, row);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(column)) {
                this.setLayoutColumn(scope, scopeValue, column);
            }
        }
    }

    public void updateSecurityConstraints(SecurityConstraints constraints) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateSecurityConstraints((ContentFragment)this, constraints);
        } else {
            this.setSecurityConstraints(constraints);
        }
    }

    public void updateStateMode(String portletState, String portletMode) {
        this.updateStateMode(portletState, portletMode, null, null);
    }

    public void updateStateMode(String portletState, String portletMode, String scope, String scopeValue) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.updateStateMode((ContentFragment)this, portletState, portletMode, scope, scopeValue);
        } else {
            if (!PageLayoutComponentUtils.Utils.isNull(portletState)) {
                this.setState(scope, scopeValue, portletState);
            }
            if (!PageLayoutComponentUtils.Utils.isNull(portletMode)) {
                this.setMode(scope, scopeValue, portletMode);
            }
        }
    }

    public ContentFragmentImpl getFragmentByDefinition(BaseFragmentsElement definition) {
        if (this.definition == definition) {
            return this;
        }
        for (ContentFragmentImpl childFragment : this.getFragments()) {
            ContentFragmentImpl fragment = childFragment.getFragmentByDefinition(definition);
            if (fragment == null) continue;
            return fragment;
        }
        return null;
    }

    public ContentFragmentImpl getFragmentById(String id) {
        return this.getFragmentById(id, null);
    }

    public ContentFragmentImpl getFragmentById(String id, ContentFragmentImpl[] parentFragment) {
        if (this.id.equals(id)) {
            return this;
        }
        for (ContentFragmentImpl childFragment : this.getFragments()) {
            ContentFragmentImpl fragment = childFragment.getFragmentById(id, parentFragment);
            if (fragment == null) continue;
            if (parentFragment != null && parentFragment[0] == null) {
                parentFragment[0] = this;
            }
            return fragment;
        }
        return null;
    }

    public ContentFragmentImpl getFragmentByFragmentId(String id, boolean nonTemplate) {
        if (!(this.fragment == null || !this.fragment.getId().equals(id) || nonTemplate && this.template)) {
            return this;
        }
        for (ContentFragmentImpl childFragment : this.getFragments()) {
            ContentFragmentImpl fragment = childFragment.getFragmentByFragmentId(id, nonTemplate);
            if (fragment == null) continue;
            return fragment;
        }
        return null;
    }

    public int getFragmentNestingLevel(String fragmentId, int level) {
        if (fragmentId.equals(this.id)) {
            return level;
        }
        int childLevel = level + 1;
        for (ContentFragmentImpl childFragment : this.getFragments()) {
            int fragmentNestingLevel = childFragment.getFragmentNestingLevel(fragmentId, childLevel);
            if (fragmentNestingLevel == -1) continue;
            return fragmentNestingLevel;
        }
        return -1;
    }

    public List getFragmentsByName(String name, boolean nonTemplate) {
        List<ContentFragmentImpl> fragments = null;
        if (!(this.name == null || !this.name.equals(name) || nonTemplate && this.template)) {
            if (fragments == null) {
                fragments = new ArrayList<ContentFragmentImpl>();
            }
            fragments.add(this);
        }
        for (ContentFragmentImpl childFragment : this.getFragments()) {
            List childFragments = childFragment.getFragmentsByName(name, nonTemplate);
            if (childFragments == null) continue;
            if (fragments == null) {
                fragments = childFragments;
                continue;
            }
            fragments.addAll(childFragments);
        }
        return fragments;
    }

    public ContentFragment getNonTemplateLayoutFragment() {
        if (this.type != null && this.type.equals("layout") && !this.template) {
            return this;
        }
        Iterator fragmentIter = this.getFragments().iterator();
        while (fragmentIter.hasNext()) {
            ContentFragment nonTemplateLayoutFragment = ((ContentFragmentImpl)fragmentIter.next()).getNonTemplateLayoutFragment();
            if (nonTemplateLayoutFragment == null) continue;
            return nonTemplateLayoutFragment;
        }
        return null;
    }

    public BaseFragmentsElement getPageOrTemplate() {
        return this.pageOrTemplate;
    }

    public BaseFragmentsElement getDefinition() {
        return this.definition;
    }

    public BaseFragmentElement getFragment() {
        return this.fragment;
    }

    public BaseFragmentsElement getReferenceDefinition() {
        return this.referenceDefinition;
    }

    public FragmentReference getReference() {
        return this.reference;
    }

    public void initialize(PageLayoutComponent pageLayoutComponent, BaseFragmentsElement pageOrTemplate, BaseFragmentsElement definition, BaseFragmentElement fragment, BaseFragmentsElement referenceDefinition, FragmentReference reference, boolean template, boolean locked) {
        this.pageLayoutComponent = pageLayoutComponent;
        this.pageOrTemplate = pageOrTemplate;
        this.definition = definition;
        this.fragment = fragment;
        this.referenceDefinition = referenceDefinition;
        this.reference = reference;
        this.template = template;
        this.locked = locked;
    }

    public ContentFragmentImpl removeFragmentById(String id) {
        ContentFragmentImpl removed = null;
        Iterator fragmentIter = this.getFragments().iterator();
        while (removed == null && fragmentIter.hasNext()) {
            ContentFragmentImpl childFragment = (ContentFragmentImpl)fragmentIter.next();
            if (childFragment.getId().equals(id)) {
                fragmentIter.remove();
                removed = childFragment;
                continue;
            }
            removed = childFragment.removeFragmentById(id);
        }
        return removed;
    }

    public void setDecorator(String decorator) {
        this.setProperty("decorator", null, null, decorator);
    }

    public void setDecorator(String scope, String scopeValue, String decorator) {
        this.setProperty("decorator", scope, scopeValue, decorator);
    }

    public void setIntProperty(String name, String scope, String scopeValue, int value) {
        this.setProperty(name, scope, scopeValue, value >= 0 ? String.valueOf(value) : null);
    }

    public void setFloatProperty(String name, String scope, String scopeValue, float value) {
        this.setProperty(name, scope, scopeValue, value >= 0.0f ? String.valueOf(value) : null);
    }

    public void setLayoutColumn(int column) {
        this.setIntProperty("column", null, null, column);
    }

    public void setLayoutColumn(String scope, String scopeValue, int column) {
        this.setIntProperty("column", scope, scopeValue, column);
    }

    public void setLayoutHeight(float height) {
        this.setFloatProperty("height", null, null, height);
    }

    public void setLayoutHeight(String scope, String scopeValue, float height) {
        this.setFloatProperty("height", scope, scopeValue, height);
    }

    public void setLayoutSizes(String sizes) {
        this.setProperty("sizes", null, null, sizes);
    }

    public void setLayoutSizes(String scope, String scopeValue, String sizes) {
        this.setProperty("sizes", scope, scopeValue, sizes);
    }

    public void setLayoutRow(int row) {
        this.setIntProperty("row", null, null, row);
    }

    public void setLayoutRow(String scope, String scopeValue, int row) {
        this.setIntProperty("row", scope, scopeValue, row);
    }

    public void setLayoutWidth(float width) {
        this.setFloatProperty("width", null, null, width);
    }

    public void setLayoutWidth(String scope, String scopeValue, float width) {
        this.setFloatProperty("width", scope, scopeValue, width);
    }

    public void setLayoutX(float x) {
        this.setFloatProperty("x", null, null, x);
    }

    public void setLayoutX(String scope, String scopeValue, float x) {
        this.setFloatProperty("x", scope, scopeValue, x);
    }

    public void setLayoutY(float y) {
        this.setFloatProperty("y", null, null, y);
    }

    public void setLayoutY(String scope, String scopeValue, float y) {
        this.setFloatProperty("y", scope, scopeValue, y);
    }

    public void setLayoutZ(float z) {
        this.setFloatProperty("z", null, null, z);
    }

    public void setLayoutZ(String scope, String scopeValue, float z) {
        this.setFloatProperty("z", scope, scopeValue, z);
    }

    public void setProperty(String propName, String scope, String scopeValue, String value) {
        FragmentProperty fragmentProperty = null;
        for (FragmentProperty findFragmentProperty : this.getProperties()) {
            String findFragmentPropertyScopeValue;
            if (!findFragmentProperty.getName().equals(propName)) continue;
            String findFragmentPropertyScope = findFragmentProperty.getScope();
            if (scope == null && findFragmentPropertyScope == null) {
                fragmentProperty = findFragmentProperty;
                break;
            }
            if (findFragmentPropertyScope == null || !findFragmentPropertyScope.equals(scope)) continue;
            if (scopeValue == null && scope.equals("user")) {
                scopeValue = PageLayoutComponentUtils.Utils.getCurrentUserScopeValue();
            }
            if ((findFragmentPropertyScopeValue = findFragmentProperty.getScopeValue()) == null || !findFragmentPropertyScopeValue.equals(scopeValue)) continue;
            fragmentProperty = findFragmentProperty;
            break;
        }
        if (fragmentProperty != null) {
            this.getProperties().remove(fragmentProperty);
        }
        if (value != null) {
            if (scopeValue == null && scope != null && scope.equals("user")) {
                scopeValue = PageLayoutComponentUtils.Utils.getCurrentUserScopeValue();
            }
            this.getProperties().add(new ContentFragmentPropertyImpl(propName, scope, scopeValue, value));
        }
    }

    public void setMode(String mode) {
        this.setProperty("mode", null, null, mode);
    }

    public void setMode(String scope, String scopeValue, String mode) {
        this.setProperty("mode", scope, scopeValue, mode);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferences(Map preferences) {
        this.getPreferences().clear();
        if (preferences != null) {
            for (Map.Entry preferencesEntry : preferences.entrySet()) {
                String name = (String)preferencesEntry.getKey();
                Object values = preferencesEntry.getValue();
                ContentFragmentPreferenceImpl preference = null;
                if (values instanceof String) {
                    preference = new ContentFragmentPreferenceImpl(name, false, Arrays.asList((String)values));
                } else if (values instanceof String[]) {
                    preference = new ContentFragmentPreferenceImpl(name, false, Arrays.asList((String[])values));
                } else if (values instanceof FragmentPreference) {
                    FragmentPreference fragmentPreference = (FragmentPreference)values;
                    preference = new ContentFragmentPreferenceImpl(name, fragmentPreference.isReadOnly(), fragmentPreference.getValueList());
                } else if (values instanceof PortletPreference) {
                    PortletPreference portletPreference = (PortletPreference)values;
                    List<String> prefValueList = null;
                    String[] prefValues = portletPreference.getValues();
                    if (prefValues != null) {
                        prefValueList = Arrays.asList(prefValues);
                    }
                    preference = new ContentFragmentPreferenceImpl(name, portletPreference.isReadOnly(), prefValueList);
                } else {
                    throw new IllegalArgumentException("Unexpected preference value type");
                }
                this.getPreferences().add(preference);
            }
        }
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    public void setSecurityConstraints(SecurityConstraints constraints) {
        this.constraints = constraints;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setSkin(String skin) {
        this.setProperty("skin", null, null, skin);
    }

    public void setSkin(String scope, String scopeValue, String skin) {
        this.setProperty("skin", scope, scopeValue, skin);
    }

    public void setState(String state) {
        this.setProperty("state", null, null, state);
    }

    public void setState(String scope, String scopeValue, String state) {
        this.setProperty("state", scope, scopeValue, state);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(long rate) {
        this.refreshRate = rate;
    }

    public String getRefreshFunction() {
        return this.refreshFunction;
    }

    public void setRefreshFunction(String function) {
        this.refreshFunction = function;
    }

    public void reorderColumns(int max) {
        if (this.pageLayoutComponent != null) {
            this.pageLayoutComponent.reorderColumns((ContentFragment)this, max);
        }
    }
}

