/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.apache.jetspeed.maven.utils.Artifacts;
import org.apache.jetspeed.maven.utils.FileEntry;
import org.apache.jetspeed.maven.utils.FileEntryCollection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.SelectorUtils;

public class UnpackResources {
    private String artifact;
    private String file;
    private String targetDirectory;
    private Boolean overwrite = Boolean.TRUE;
    private Resource[] resources;

    private static String getValue(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static Boolean getValue(Boolean value, Boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpack(Artifacts artifacts, String defaultTargetDirectory, Log log, boolean verbose) throws MojoExecutionException {
        File resourceFile = null;
        if (this.artifact == null && this.file == null && artifacts.size() == 1) {
            resourceFile = artifacts.getFirstArtifact().getFile();
        } else {
            if (this.artifact == null && this.file == null || this.artifact != null && this.file != null) {
                throw new MojoExecutionException("Either specify artifact or file");
            }
            if (this.artifact != null) {
                Artifact artifactObj = artifacts.get(this.artifact);
                if (artifactObj == null) {
                    throw new MojoExecutionException("unpack artifact " + this.artifact + " not defined as plugin dependency");
                }
                resourceFile = artifactObj.getFile();
            } else {
                resourceFile = new File(this.file);
                if (!resourceFile.exists() || !resourceFile.isFile()) {
                    throw new MojoExecutionException("Invalid or non-existing file: " + resourceFile);
                }
            }
        }
        UnpackResource[] unpackResources = null;
        if (this.resources == null) {
            unpackResources = new UnpackResource[]{new UnpackResource(this.overwrite)};
        } else {
            unpackResources = new UnpackResource[this.resources.length];
            for (int i = 0; i < this.resources.length; ++i) {
                unpackResources[i] = new UnpackResource(this.resources[i], this.overwrite);
            }
        }
        this.targetDirectory = UnpackResources.getValue(this.targetDirectory, defaultTargetDirectory);
        File targetBaseDir = new File(this.targetDirectory);
        if (targetBaseDir.exists()) {
            if (!targetBaseDir.isDirectory()) {
                throw new MojoExecutionException("Invalid target directory " + targetBaseDir.getAbsolutePath() + ": not a directory");
            }
        } else {
            targetBaseDir.mkdirs();
        }
        FileEntryCollection fileEntryCollection = null;
        ZipFile zipFile = null;
        try {
            if (!resourceFile.isDirectory()) {
                zipFile = new ZipFile(resourceFile);
                fileEntryCollection = new FileEntryCollection(zipFile);
            } else {
                fileEntryCollection = new FileEntryCollection(resourceFile);
            }
            FileEntry fileEntry = null;
            Enumeration<? extends FileEntry> entries = fileEntryCollection.entries();
            while (entries.hasMoreElements()) {
                fileEntry = entries.nextElement();
                if (fileEntry.isDirectory()) continue;
                File firstDestFile = null;
                for (int i = 0; i < unpackResources.length; ++i) {
                    String destFileName = unpackResources[i].getDestFileName(fileEntry.getName(), this.targetDirectory);
                    if (destFileName == null) continue;
                    File destFile = new File(destFileName);
                    if (destFile.exists()) {
                        if (!destFile.isFile()) {
                            throw new MojoExecutionException("Destination " + destFile.getAbsolutePath() + " already exists and is not a file");
                        }
                        if (destFile.lastModified() >= fileEntry.getTime() || !unpackResources[i].isOverwrite()) {
                            if (verbose) {
                                log.info((CharSequence)(fileEntry.getName() + " skipped: already exists at " + destFile.getAbsolutePath()));
                                continue;
                            }
                            log.debug((CharSequence)(fileEntry.getName() + " skipped: already exists at " + destFile.getAbsolutePath()));
                            continue;
                        }
                    } else {
                        destFile.getParentFile().mkdirs();
                    }
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    InputStream is = null;
                    FileOutputStream fos = null;
                    try {
                        if (firstDestFile == null) {
                            firstDestFile = destFile;
                            is = fileEntryCollection.getInputStream(fileEntry);
                        } else {
                            is = new FileInputStream(firstDestFile);
                        }
                        fos = new FileOutputStream(destFile);
                        while ((length = is.read(buffer)) >= 0) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        fos = null;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    destFile.setLastModified(fileEntry.getTime());
                    if (verbose) {
                        log.info((CharSequence)(fileEntry.getName() + " extracted to " + destFile.getAbsolutePath()));
                        continue;
                    }
                    log.debug((CharSequence)(fileEntry.getName() + " extracted to " + destFile.getAbsolutePath()));
                }
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error while unpacking " + resourceFile.getPath(), (Exception)ioe);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class UnpackResource {
        private String dest;
        private boolean flat;
        private boolean overwrite;
        private String name;
        public EntrySet entrySet;

        public UnpackResource(boolean overwrite) {
            this.dest = "";
            this.overwrite = overwrite;
            this.entrySet = new EntrySet("");
            this.entrySet.setIncludes(null);
        }

        public UnpackResource(Resource resource, Boolean defaultOverwrite) {
            this.dest = UnpackResource.makeRelativePath(resource.destination);
            this.overwrite = UnpackResources.getValue(resource.overwrite, defaultOverwrite);
            this.flat = UnpackResources.getValue(resource.flat, Boolean.FALSE);
            this.name = resource.name;
            if (resource.path != null || resource.include != null || resource.exclude != null) {
                this.entrySet = new EntrySet(resource.path);
                this.entrySet.setIncludes(UnpackResource.getPatterns(resource.include));
                this.entrySet.setExcludes(UnpackResource.getPatterns(resource.exclude));
            } else {
                this.entrySet = new EntrySet("");
                this.entrySet.setIncludes(null);
            }
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        private static String[] getPatterns(String patternList) {
            StringTokenizer t = null;
            int count = 0;
            if (patternList != null) {
                t = new StringTokenizer(patternList, ", ");
                count = t.countTokens();
            }
            String[] tokens = new String[count];
            for (int i = 0; i < count; ++i) {
                tokens[i] = t.nextToken();
            }
            return tokens;
        }

        private static String fixFileSeparator(String name) {
            return name != null ? name.trim().replace('/', File.separatorChar).replace('\\', File.separatorChar) : null;
        }

        private static String makeRelativePath(String dir) {
            if (dir != null) {
                dir = UnpackResource.fixFileSeparator(dir);
                while (dir.startsWith(File.separator)) {
                    dir = dir.substring(File.separator.length());
                }
                while (dir.endsWith(File.separator)) {
                    dir = dir.substring(0, dir.length() - File.separator.length());
                }
            } else {
                dir = "";
            }
            return dir;
        }

        public String getDestFileName(String entryName, String baseDirectory) {
            String destFileName = null;
            if (entryName != null) {
                int j;
                boolean match = false;
                entryName = UnpackResource.makeRelativePath(entryName);
                if (this.entrySet.includes != null) {
                    for (j = 0; j < this.entrySet.includes.length; ++j) {
                        if (!SelectorUtils.matchPath((String)this.entrySet.includes[j], (String)entryName)) continue;
                        match = true;
                        break;
                    }
                } else {
                    match = true;
                }
                if (match && this.entrySet.excludes != null) {
                    for (j = 0; j < this.entrySet.excludes.length; ++j) {
                        if (!SelectorUtils.matchPath((String)this.entrySet.excludes[j], (String)entryName)) continue;
                        match = false;
                        break;
                    }
                }
                if (match) {
                    if (this.entrySet.getDir().length() > 0) {
                        entryName = entryName.substring(this.entrySet.getDir().length() + File.separator.length());
                    }
                    if (this.flat) {
                        int index = entryName.lastIndexOf(File.separator);
                        String string = entryName = index >= 0 ? entryName.substring(index + 1) : entryName;
                    }
                    if (baseDirectory == null) {
                        baseDirectory = "";
                    } else if (!baseDirectory.endsWith(File.separator)) {
                        baseDirectory = baseDirectory + File.separator;
                    }
                    destFileName = this.dest.length() > 0 ? baseDirectory + File.separator + this.dest + File.separator + (this.name == null ? entryName : this.name) : baseDirectory + (this.name == null ? entryName : this.name);
                }
            }
            return destFileName;
        }

        private static class EntrySet {
            private String dir;
            private String[] includes;
            private String[] excludes;

            public EntrySet(String dir) {
                this.dir = UnpackResource.makeRelativePath(dir);
            }

            public void setExcludes(String[] excludes) {
                if (excludes == null || excludes.length == 0) {
                    this.excludes = null;
                } else {
                    this.excludes = new String[excludes.length];
                    for (int i = 0; i < excludes.length; ++i) {
                        String pattern = UnpackResource.fixFileSeparator(excludes[i]);
                        if (pattern.endsWith(File.separator)) {
                            pattern = pattern + "**";
                        }
                        pattern = UnpackResource.makeRelativePath(pattern);
                        if (this.dir.length() > 0) {
                            pattern = this.dir + File.separatorChar + pattern;
                        }
                        this.excludes[i] = pattern;
                    }
                }
            }

            public void setIncludes(String[] includes) {
                if (includes == null || includes.length == 0) {
                    this.includes = new String[1];
                    this.includes[0] = this.dir.length() > 0 ? this.dir + File.separator + "**" : "**";
                } else {
                    this.includes = new String[includes.length];
                    for (int i = 0; i < includes.length; ++i) {
                        String pattern = UnpackResource.fixFileSeparator(includes[i]);
                        if (pattern.endsWith(File.separator)) {
                            pattern = pattern + "**";
                        }
                        pattern = UnpackResource.makeRelativePath(pattern);
                        if (this.dir.length() > 0) {
                            pattern = this.dir + File.separatorChar + pattern;
                        }
                        this.includes[i] = pattern;
                    }
                }
            }

            public String getDir() {
                return this.dir;
            }

            public String[] getExcludes() {
                return this.excludes;
            }

            public String[] getIncludes() {
                return this.includes;
            }
        }
    }

    public static class Resource {
        private String path;
        private String destination;
        private Boolean overwrite;
        private Boolean flat;
        private String include;
        private String exclude;
        private String name;
    }
}

