/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.jetspeed.maven.utils.DbConnection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class SqlScripts {
    private String delimiter = ";";
    private String delimiterType = "normal";
    private Boolean escapeProcessing = Boolean.TRUE;
    private Boolean ignoreErrors = Boolean.FALSE;
    private Script[] scripts;

    public boolean isConfigered() throws MojoExecutionException {
        if (this.scripts != null && this.scripts.length > 0) {
            for (int i = 0; i < this.scripts.length; ++i) {
                this.scripts[i].delimiter = SqlScripts.getValue(this.scripts[i].delimiter, this.delimiter);
                this.scripts[i].delimiterType = SqlScripts.getValue(this.scripts[i].delimiterType, this.delimiterType);
                this.scripts[i].escapeProcessing = SqlScripts.getValue(this.scripts[i].escapeProcessing, this.escapeProcessing);
                this.scripts[i].ignoreErrors = SqlScripts.getValue(this.scripts[i].ignoreErrors, this.ignoreErrors);
                if (this.scripts[i].path != null && this.scripts[i].path.length() != 0) continue;
                throw new MojoExecutionException("sql script[" + i + "] path not specified");
            }
            return true;
        }
        return false;
    }

    private static String getValue(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    private static Boolean getValue(Boolean value, Boolean defaultValue) {
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DbConnection dbConnection, Log log) throws MojoExecutionException {
        Connection connection = dbConnection.getConnection();
        log.info((CharSequence)("Running sql scripts against: " + dbConnection.getUrl() + " for user: " + dbConnection.getUsername()));
        try {
            for (int i = 0; i < this.scripts.length; ++i) {
                this.runScript(connection, this.scripts[i], log);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    private void runScript(Connection connection, Script script, Log log) throws MojoExecutionException {
        File scriptFile = new File(script.path);
        if (!scriptFile.exists() || !scriptFile.isFile()) {
            throw new MojoExecutionException("SQL script file " + scriptFile.getAbsolutePath() + " not found");
        }
        log.info((CharSequence)("Executing SQL script file: " + scriptFile.getAbsolutePath()));
        Reader reader = null;
        Statement statement = null;
        try {
            String line;
            statement = connection.createStatement();
            statement.setEscapeProcessing(script.escapeProcessing);
            reader = new FileReader(scriptFile);
            StringBuffer sql = new StringBuffer();
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                String token;
                StringTokenizer st;
                if ((line = line.trim()).startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken())) continue;
                sql.append(" ").append(line);
                if (line.indexOf("--") >= 0) {
                    sql.append("\n");
                }
                if ((!script.delimiterType.equals("normal") || !sql.toString().endsWith(script.delimiter)) && (!script.delimiterType.equals("row") || !line.equals(script.delimiter))) continue;
                this.execSQL(connection, statement, sql.substring(0, sql.length() - script.delimiter.length()), script.ignoreErrors, log);
                sql.replace(0, sql.length(), "");
            }
            if (!sql.equals("")) {
                this.execSQL(connection, statement, sql.toString(), script.ignoreErrors, log);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected error", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException ex) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSQL(Connection connection, Statement statement, String sql, boolean ignoreErrors, Log log) throws MojoExecutionException {
        if ("".equals(sql.trim())) {
            return;
        }
        ResultSet resultSet = null;
        try {
            log.debug((CharSequence)("SQL: " + sql));
            int updateCountTotal = 0;
            boolean ret = statement.execute(sql);
            int updateCount = statement.getUpdateCount();
            resultSet = statement.getResultSet();
            do {
                if (!ret && updateCount != -1) {
                    updateCountTotal += updateCount;
                }
                if (!(ret = statement.getMoreResults())) continue;
                updateCount = statement.getUpdateCount();
                resultSet = statement.getResultSet();
            } while (ret);
            if (updateCountTotal > 0) {
                log.debug((CharSequence)(updateCountTotal + " rows affected"));
                StringBuffer line = new StringBuffer();
                line.append(updateCountTotal).append(" rows affected");
            }
            for (SQLWarning warning = connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                log.debug((CharSequence)(warning + " sql warning"));
            }
            connection.clearWarnings();
        }
        catch (SQLException e) {
            log.error((CharSequence)("Failed to execute: " + sql));
            if (!ignoreErrors) {
                throw new MojoExecutionException("Failed to execute: " + sql, (Exception)e);
            }
            log.error((CharSequence)e.toString());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new MojoExecutionException("Unexpected SQL exception: ", (Exception)e);
                }
            }
        }
    }

    public static class Script {
        String delimiter;
        String delimiterType;
        String path;
        Boolean ignoreErrors;
        Boolean escapeProcessing;
    }
}

