/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.maven.utils;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.jetspeed.maven.utils.MavenToolsLogger;
import org.apache.jetspeed.serializer.JetspeedSerializerApplication;
import org.apache.jetspeed.serializer.SerializerException;
import org.apache.jetspeed.tools.ToolsLogger;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class Serializer {
    private static final String SERIALIZER_APPLICATION_CLASS_NAME = "org.apache.jetspeed.tools.db.serializer.JetspeedSerializerApplicationImpl";
    private String filterPropertiesFileName;
    private String categories;
    private String applicationRootPath;
    private String[] files;
    private Map initProperties;

    public boolean isConfigered() throws MojoExecutionException {
        boolean configured = false;
        if (this.files != null && this.files.length > 0) {
            for (int i = 0; i < this.files.length; ++i) {
                if (this.files[i] == null || this.files[i].length() == 0) {
                    throw new MojoExecutionException("Serializer seed element [" + i + "] is empty");
                }
                if (new File(this.files[i]).exists()) continue;
                throw new MojoExecutionException("Serializer seed file or directory " + this.files[i] + " not found");
            }
            if (this.applicationRootPath == null) {
                throw new MojoExecutionException("Serializer applicationRootPath is required");
            }
            configured = true;
        }
        return configured;
    }

    public void execute(Log log) throws MojoExecutionException {
        JetspeedSerializerApplication app = null;
        try {
            Class<?> dfClass = Class.forName(SERIALIZER_APPLICATION_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            app = (JetspeedSerializerApplication)dfClass.newInstance();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot find or load JetspeedSerializerApplication class org.apache.jetspeed.tools.db.serializer.JetspeedSerializerApplicationImpl", e);
        }
        MavenToolsLogger logger = new MavenToolsLogger(log);
        Properties props = null;
        if (this.initProperties != null) {
            props = new Properties();
            for (Map.Entry entry : this.initProperties.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue("");
            }
            props.putAll((Map<?, ?>)this.initProperties);
        }
        try {
            if (this.files != null && this.files.length > 0) {
                app.importFiles((ToolsLogger)logger, this.applicationRootPath, this.categories, this.filterPropertiesFileName, props, this.files);
            }
        }
        catch (SerializerException se) {
            throw new MojoExecutionException("Serializer error: ", (Exception)((Object)se));
        }
    }
}

