/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.file.FileCacheEntry;
import org.apache.jetspeed.cache.file.FileCacheEntryImpl;
import org.apache.jetspeed.cache.file.FileCacheEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCache {
    protected long scanRate = 300L;
    private FileCacheScanner scanner = null;
    private JetspeedCache cache = null;
    private Map<FileCacheEventListener, JetspeedCacheEventListener> listeners = new Hashtable<FileCacheEventListener, JetspeedCacheEventListener>();
    private static final Logger log = LoggerFactory.getLogger(FileCache.class);

    public FileCache(JetspeedCache cache) {
        this.cache = cache;
        this.scanner = new FileCacheScanner();
        this.scanner.setDaemon(true);
    }

    public FileCache(JetspeedCache cache, long scanRate) {
        this(cache);
        this.scanRate = scanRate;
    }

    public void setScanRate(long scanRate) {
        this.scanRate = scanRate;
    }

    public long getScanRate() {
        return this.scanRate;
    }

    public FileCacheEntry get(String key) {
        FileCacheEntry entry = null;
        CacheElement element = this.cache.get((Object)key);
        if (element != null) {
            entry = (FileCacheEntry)element.getContent();
        }
        return entry;
    }

    public Object getDocument(String key) {
        FileCacheEntry entry = this.get(key);
        if (entry != null) {
            return entry.getDocument();
        }
        return null;
    }

    public void put(File file, Object document) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File to cache: " + file.getAbsolutePath() + " does not exist.");
        }
        FileCacheEntryImpl entry = new FileCacheEntryImpl(file, document);
        CacheElement element = this.cache.createElement((Object)file.getCanonicalPath(), (Object)entry);
        this.cache.put(element);
    }

    public void put(String key, Object document, File rootFile) throws IOException {
        File file = new File(rootFile, key);
        if (!file.exists()) {
            throw new FileNotFoundException("File to cache: " + file.getAbsolutePath() + " does not exist.");
        }
        FileCacheEntryImpl entry = new FileCacheEntryImpl(file, document);
        CacheElement element = this.cache.createElement((Object)key, (Object)entry);
        this.cache.put(element);
    }

    public Object remove(String key) {
        boolean removed = this.cache.remove((Object)key);
        return null;
    }

    public void addListener(final FileCacheEventListener listener) {
        JetspeedCacheEventListener cacheEventListener = new JetspeedCacheEventListener(){

            public void notifyElementRemoved(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementAdded(JetspeedCache cache, boolean local, Object key, Object element) {
            }

            public void notifyElementChanged(JetspeedCache cache, boolean local, Object key, Object element) {
                try {
                    listener.refresh((FileCacheEntry)element);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void notifyElementEvicted(JetspeedCache cache, boolean local, Object key, Object element) {
                try {
                    listener.evict((FileCacheEntry)element);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }

            public void notifyElementExpired(JetspeedCache cache, boolean local, Object key, Object element) {
            }
        };
        this.listeners.put(listener, cacheEventListener);
        this.cache.addEventListener(cacheEventListener, true);
    }

    public void removeListener(FileCacheEventListener listener) {
        JetspeedCacheEventListener cacheEventListener = this.listeners.remove(listener);
        if (cacheEventListener != null) {
            this.cache.removeEventListener(cacheEventListener, true);
        }
    }

    public void startFileScanner() {
        try {
            this.scanner.start();
        }
        catch (IllegalThreadStateException e) {
            log.error("Exception starting scanner", (Throwable)e);
        }
    }

    public void stopFileScanner() {
        this.scanner.setStopping(true);
    }

    public void evictAll() {
        this.cache.clear();
    }

    public List getKeys() {
        return this.cache.getKeys();
    }

    public int getSize() {
        return this.cache.getSize();
    }

    protected class FileCacheScanner
    extends Thread {
        private boolean stopping = false;

        protected FileCacheScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setStopping(boolean flag) {
            FileCacheScanner fileCacheScanner = this;
            synchronized (fileCacheScanner) {
                if (!this.stopping && flag) {
                    this.stopping = flag;
                    this.notifyAll();
                } else {
                    flag = false;
                }
            }
            if (flag) {
                try {
                    this.join(FileCache.this.getScanRate() * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public synchronized void run() {
            boolean done = false;
            try {
                while (!done) {
                    try {
                        for (Object key : FileCache.this.getKeys()) {
                            FileCacheEntry entry;
                            File file;
                            Date modified;
                            CacheElement element = FileCache.this.cache.get(key);
                            if (element == null || !(modified = new Date((file = (entry = (FileCacheEntry)element.getContent()).getFile()).lastModified())).after(entry.getLastModified())) continue;
                            FileCacheEntryImpl updatedEntry = new FileCacheEntryImpl(file, entry.getDocument());
                            CacheElement updatedElement = FileCache.this.cache.createElement(key, (Object)updatedEntry);
                            FileCache.this.cache.put(updatedElement);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("page file has been updated: " + key);
                        }
                    }
                    catch (Exception e) {
                        log.error("FileCache Scanner: Error in iteration...", (Throwable)e);
                    }
                    this.wait(FileCache.this.getScanRate() * 1000L);
                    if (!this.stopping) continue;
                    this.stopping = false;
                    done = true;
                }
            }
            catch (InterruptedException e) {
                log.error("FileCacheScanner: recieved interruption, exiting.", (Throwable)e);
            }
        }
    }
}

