/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.jetspeed.tools.deploy.Deploy;
import org.apache.jetspeed.tools.deploy.JetspeedContextRewriter;
import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriterFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JetspeedDeploy
implements Deploy {
    private final byte[] buffer;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            JetspeedDeploy.printUsage();
            System.exit(1);
            return;
        }
        boolean stripLoggers = false;
        String version = null;
        for (int i = 0; i < args.length - 2; ++i) {
            String option = args[i];
            if (option.equals("-s")) {
                stripLoggers = true;
                continue;
            }
            if (option.equals("-v") && i < args.length - 3) {
                version = args[i + 1];
                ++i;
                continue;
            }
            JetspeedDeploy.printUsage();
            System.exit(1);
            return;
        }
        new JetspeedDeploy(args[args.length - 2], args[args.length - 1], stripLoggers, version);
    }

    private static void printUsage() {
        System.out.println("Usage: java -jar jetspeed-deploy-tools-<version>.jar [options] INPUT OUTPUT");
        System.out.println("Options:");
        System.out.println("  -s: stripLoggers - remove commons-logging[version].jar and/or log4j[version].jar from war");
        System.out.println("                     (required when targetting application servers like JBoss)");
        System.out.println("  -v VERSION: force servlet specification version to handle web.xml");
        System.out.println("                     (default will automatically determine version)");
    }

    public JetspeedDeploy(String inputName, String outputName, boolean stripLoggers) throws Exception {
        this(inputName, outputName, stripLoggers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JetspeedDeploy(String inputName, String outputName, boolean stripLoggers, String forcedVersion) throws Exception {
        block46: {
            block45: {
                block44: {
                    block39: {
                        super();
                        this.buffer = new byte[4096];
                        tempFile = null;
                        jin = null;
                        jout = null;
                        srcChannel = null;
                        dstChannel = null;
                        try {
                            portletApplicationName = this.getPortletApplicationName(outputName);
                            tempFile = File.createTempFile(portletApplicationName, "");
                            tempFile.deleteOnExit();
                            jin = new JarFile(inputName);
                            jout = new JarOutputStream(new FileOutputStream(tempFile));
                            webXml = null;
                            portletXml = null;
                            contextXml = null;
                            taglibFound = false;
                            zipEntries = jin.entries();
                            while (zipEntries.hasMoreElements()) {
                                block37: {
                                    block38: {
                                        src = zipEntries.nextElement();
                                        source = jin.getInputStream(src);
                                        try {
                                            target = src.getName();
                                            if ("WEB-INF/web.xml".equals(target)) {
                                                System.out.println("Found web.xml");
                                                webXml = this.parseXml(source);
                                                break block37;
                                            }
                                            if ("WEB-INF/portlet.xml".equals(target)) {
                                                System.out.println("Found WEB-INF/portlet.xml");
                                                portletXml = this.parseXml(source);
                                                break block37;
                                            }
                                            if ("META-INF/context.xml".equals(target)) {
                                                System.out.println("Found META-INF/context.xml");
                                                contextXml = this.parseXml(source);
                                                break block37;
                                            }
                                            if (stripLoggers && target.endsWith(".jar") && (target.startsWith("WEB-INF/lib/commons-logging") || target.startsWith("WEB-INF/lib/log4j"))) {
                                                System.out.println("Stripping logger " + target);
                                                var20_19 = null;
                                                break block38;
                                            }
                                            if ("WEB-INF/tld/portlet.tld".equals(target)) {
                                                System.out.println("Warning: WEB-INF/tld/portlet.tld already provided, won't be replaced.");
                                                taglibFound = true;
                                            }
                                            this.addFile(target, source, (JarOutputStream)jout, src.getTime());
                                            break block37;
                                        }
                                        catch (Throwable var19_20) {
                                            var20_19 = null;
                                            source.close();
                                            throw var19_20;
                                        }
                                    }
                                    source.close();
                                    continue;
                                }
                                var20_19 = null;
                                source.close();
                            }
                            if (webXml == null) {
                                throw new IllegalArgumentException("WEB-INF/web.xml");
                            }
                            if (portletXml == null) {
                                throw new IllegalArgumentException("WEB-INF/portlet.xml");
                            }
                            webRewriterFactory = new JetspeedWebApplicationRewriterFactory();
                            webRewriter = webRewriterFactory.getInstance(webXml, portletApplicationName, forcedVersion);
                            webRewriter.processWebXML();
                            contextRewriter = new JetspeedContextRewriter(contextXml, portletApplicationName);
                            contextRewriter.processContextXML();
                            this.addFile("WEB-INF/web.xml", webXml, (JarOutputStream)jout);
                            this.addFile("WEB-INF/portlet.xml", portletXml, (JarOutputStream)jout);
                            this.addFile("META-INF/context.xml", contextXml, (JarOutputStream)jout);
                            if (!taglibFound) {
                                System.out.println("Attempting to add portlet.tld to war...");
                                is = this.getClass().getResourceAsStream("/org/apache/jetspeed/tools/deploy/portlet.tld");
                                if (is == null) {
                                    System.out.println("Failed to find portlet.tld in classpath");
                                } else {
                                    System.out.println("Adding portlet.tld to war...");
                                    try {
                                        this.addFile("WEB-INF/tld/portlet.tld", is, (JarOutputStream)jout, 0L);
                                        var23_23 = null;
                                    }
                                    catch (Throwable var22_25) {
                                        var23_24 = null;
                                        is.close();
                                        throw var22_25;
                                    }
                                    is.close();
                                }
                            }
                            jout.close();
                            jin.close();
                            jin = null;
                            jout = null;
                            System.out.println("Creating war " + outputName + " ...");
                            System.out.flush();
                            srcChannel = new FileInputStream(tempFile).getChannel();
                            dstChannel = new FileOutputStream(outputName).getChannel();
                            dstChannel.transferFrom((ReadableByteChannel)srcChannel, 0L, srcChannel.size());
                            srcChannel.close();
                            srcChannel = null;
                            dstChannel.close();
                            dstChannel = null;
                            tempFile.delete();
                            tempFile = null;
                            System.out.println("War " + outputName + " created");
                            System.out.flush();
                            var25_26 = null;
                            if (srcChannel == null) break block39;
                        }
                        catch (Throwable var24_30) {
                            var25_27 = null;
                            if (srcChannel != null && srcChannel.isOpen()) {
                                try {
                                    srcChannel.close();
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (dstChannel != null && dstChannel.isOpen()) {
                                try {
                                    dstChannel.close();
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (jin != null) {
                                try {
                                    jin.close();
                                    jin = null;
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (jout != null) {
                                try {
                                    jout.close();
                                    jout = null;
                                }
                                catch (IOException e1) {
                                    // empty catch block
                                }
                            }
                            if (tempFile == null) throw var24_30;
                            if (tempFile.exists() == false) throw var24_30;
                            tempFile.delete();
                            throw var24_30;
                        }
                        if (srcChannel.isOpen()) {
                            ** try [egrp 3[TRYBLOCK] [7 : 719->727)] { 
lbl152:
                            // 1 sources

                            srcChannel.close();
                            break block39;
lbl154:
                            // 1 sources

                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                    }
                    if (dstChannel != null && dstChannel.isOpen()) {
                        ** try [egrp 4[TRYBLOCK] [8 : 742->750)] { 
lbl159:
                        // 1 sources

                        dstChannel.close();
                        break block44;
lbl161:
                        // 1 sources

                        catch (IOException e1) {
                            // empty catch block
                        }
                    }
                }
                if (jin != null) {
                    ** try [egrp 5[TRYBLOCK] [9 : 757->768)] { 
lbl166:
                    // 1 sources

                    jin.close();
                    jin = null;
                    break block45;
lbl169:
                    // 1 sources

                    catch (IOException e1) {
                        // empty catch block
                    }
                }
            }
            if (jout != null) {
                ** try [egrp 6[TRYBLOCK] [10 : 775->786)] { 
lbl174:
                // 1 sources

                jout.close();
                jout = null;
                break block46;
lbl177:
                // 1 sources

                catch (IOException e1) {
                    // empty catch block
                }
            }
        }
        if (tempFile == null) return;
        if (tempFile.exists() == false) return;
        tempFile.delete();
    }

    protected Document parseXml(InputStream source) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd")) {
                    return new InputSource(this.getClass().getResourceAsStream("web-app_2_3.dtd"));
                }
                return null;
            }
        });
        Document document = saxBuilder.build(source);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(String path, InputStream source, JarOutputStream jos, long fileTime) throws IOException {
        ZipEntry ze = new ZipEntry(path);
        if (fileTime > 0L) {
            ze.setTime(fileTime);
        }
        jos.putNextEntry(ze);
        try {
            int count;
            while ((count = source.read(this.buffer)) > 0) {
                jos.write(this.buffer, 0, count);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            jos.closeEntry();
            throw throwable;
        }
        jos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFile(String path, Document source, JarOutputStream jos) throws IOException {
        if (source != null) {
            jos.putNextEntry(new ZipEntry(path));
            XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
            try {
                xmlOutputter.output(source, (OutputStream)jos);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                jos.closeEntry();
                throw throwable;
            }
            jos.closeEntry();
            {
            }
        }
    }

    protected String getPortletApplicationName(String path) {
        String name;
        File file = new File(path);
        String portletApplicationName = name = file.getName();
        int index = name.lastIndexOf("-infused.war");
        if (index > -1) {
            portletApplicationName = name.substring(0, index);
        } else {
            index = name.lastIndexOf(".");
            if (index > -1) {
                portletApplicationName = name.substring(0, index);
            }
        }
        return portletApplicationName;
    }
}

