/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.migration;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.jetspeed.components.datasource.DBCPDatasourceComponent;
import org.apache.jetspeed.tools.migration.JetspeedCapabilitiesMigration;
import org.apache.jetspeed.tools.migration.JetspeedDBPageManagerMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigration;
import org.apache.jetspeed.tools.migration.JetspeedMigrationListener;
import org.apache.jetspeed.tools.migration.JetspeedMigrationResult;
import org.apache.jetspeed.tools.migration.JetspeedProfilerMigration;
import org.apache.jetspeed.tools.migration.JetspeedRegistryMigration;
import org.apache.jetspeed.tools.migration.JetspeedSSOSecurityMigration;
import org.apache.jetspeed.tools.migration.JetspeedSecurityMigration;
import org.apache.jetspeed.tools.migration.JetspeedStatisticsMigration;
import org.apache.jetspeed.tools.migration.SQLScriptReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JetspeedMigrationApplication {
    private static final Logger log = LoggerFactory.getLogger(JetspeedMigrationApplication.class);
    private static final int ALL_MIGRATION_PHASE = 0;
    private static final int CREATE_SCHEMA_MIGRATION_PHASE = 1;
    private static final int DATA_MIGRATION_PHASE = 2;
    private static final int CONSTRAINTS_SCHEMA_MIGRATION_PHASE = 3;
    private static final int DEFAULT_ROWS_MIGRATED_PER_COMMIT = 500;
    private static final int DEFAULT_MIGRATION_PHASE = 0;
    private String sourceDBUsername;
    private String sourceDBPassword;
    private String sourceJDBCUrl;
    private String sourceJDBCDriverClass;
    private String dbUsername;
    private String dbPassword;
    private String jdbcUrl;
    private String jdbcDriverClass;
    private int rowsMigratedPerCommit = 500;
    private File dropSchemaSQLScriptFile;
    private File createSchemaSQLScriptFile;
    private int migrationPhase = 0;
    private DBCPDatasourceComponent sourceDataSourceFactory;
    private DBCPDatasourceComponent targetDataSourceFactory;
    private DBCPDatasourceComponent targetTxnDataSourceFactory;
    private JetspeedMigration[] migrations;
    private int rowsCheckpointCommitted;
    private int rowsMigrated;

    public JetspeedMigrationApplication(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-migration-phase=")) {
                this.migrationPhase = Integer.parseInt(arg.substring(17));
                continue;
            }
            if (arg.startsWith("-source-db-username=")) {
                this.sourceDBUsername = arg.substring(20);
                continue;
            }
            if (arg.startsWith("-source-db-password=")) {
                this.sourceDBPassword = arg.substring(20);
                continue;
            }
            if (arg.startsWith("-source-jdbc-url=")) {
                this.sourceJDBCUrl = arg.substring(17);
                continue;
            }
            if (arg.startsWith("-source-jdbc-driver-class=")) {
                this.sourceJDBCDriverClass = arg.substring(26);
                continue;
            }
            if (arg.startsWith("-db-username=")) {
                this.dbUsername = arg.substring(13);
                continue;
            }
            if (arg.startsWith("-db-password=")) {
                this.dbPassword = arg.substring(13);
                continue;
            }
            if (arg.startsWith("-jdbc-url=")) {
                this.jdbcUrl = arg.substring(10);
                continue;
            }
            if (arg.startsWith("-jdbc-driver-class=")) {
                this.jdbcDriverClass = arg.substring(19);
                continue;
            }
            if (arg.startsWith("-rows-migrated-per-commit=")) {
                this.rowsMigratedPerCommit = Integer.parseInt(arg.substring(26));
                continue;
            }
            if (arg.startsWith("-drop-schema-sql=")) {
                this.dropSchemaSQLScriptFile = new File(arg.substring(17));
                if (this.dropSchemaSQLScriptFile.isFile()) continue;
                throw new RuntimeException("Cannot access -drop-schema-sql file: " + this.dropSchemaSQLScriptFile);
            }
            if (!arg.startsWith("-create-schema-sql=")) continue;
            this.createSchemaSQLScriptFile = new File(arg.substring(19));
            if (this.createSchemaSQLScriptFile.isFile()) continue;
            throw new RuntimeException("Cannot access -create-schema-sql file: " + this.createSchemaSQLScriptFile);
        }
        if (this.migrationPhase != 0 && this.migrationPhase != 1 && this.migrationPhase != 2 && this.migrationPhase != 3) {
            throw new RuntimeException("Invalid -migration-phase argument");
        }
        if (this.sourceDBUsername == null && (this.migrationPhase == 0 || this.migrationPhase == 2)) {
            throw new RuntimeException("Missing -source-db-username argument");
        }
        if (this.sourceDBPassword == null && (this.migrationPhase == 0 || this.migrationPhase == 2)) {
            throw new RuntimeException("Missing -source-db-password argument");
        }
        if (this.sourceJDBCUrl == null && (this.migrationPhase == 0 || this.migrationPhase == 2)) {
            throw new RuntimeException("Missing -source-jdbc-url argument");
        }
        if (this.sourceJDBCDriverClass == null && (this.migrationPhase == 0 || this.migrationPhase == 2)) {
            throw new RuntimeException("Missing -source-jdbc-driver-class argument");
        }
        if (this.dbUsername == null) {
            throw new RuntimeException("Missing -db-username argument");
        }
        if (this.dbPassword == null) {
            throw new RuntimeException("Missing -db-password argument");
        }
        if (this.jdbcUrl == null) {
            throw new RuntimeException("Missing -jdbc-url argument");
        }
        if (this.jdbcDriverClass == null) {
            throw new RuntimeException("Missing -jdbc-driver-class argument");
        }
        if (this.dropSchemaSQLScriptFile == null && (this.migrationPhase == 0 || this.migrationPhase == 1)) {
            throw new RuntimeException("Missing -drop-schema-sql argument required for phase");
        }
        if (this.createSchemaSQLScriptFile == null && (this.migrationPhase == 0 || this.migrationPhase == 1 || this.migrationPhase == 3)) {
            throw new RuntimeException("Missing -create-schema-sql argument required for phase");
        }
        this.jdbcUrl = this.validateJDBCUrlOptions(this.jdbcUrl, this.jdbcDriverClass);
        this.sourceJDBCUrl = this.validateJDBCUrlOptions(this.sourceJDBCUrl, this.sourceJDBCDriverClass);
        if (this.migrationPhase == 0 || this.migrationPhase == 2) {
            if (this.jdbcUrl.equals(this.sourceJDBCUrl)) {
                throw new RuntimeException("Source and target JDBC databases must be different: " + this.jdbcUrl);
            }
            this.sourceDataSourceFactory = new DBCPDatasourceComponent(this.sourceDBUsername, this.sourceDBPassword, this.sourceJDBCDriverClass, this.sourceJDBCUrl, 2, 0, 2, true);
            this.targetTxnDataSourceFactory = new DBCPDatasourceComponent(this.dbUsername, this.dbPassword, this.jdbcDriverClass, this.jdbcUrl, 2, 0, 2, false);
        }
        if (this.migrationPhase == 0 || this.migrationPhase == 1 || this.migrationPhase == 3) {
            this.targetDataSourceFactory = new DBCPDatasourceComponent(this.dbUsername, this.dbPassword, this.jdbcDriverClass, this.jdbcUrl, 2, 0, 2, true);
        }
        this.migrations = new JetspeedMigration[]{new JetspeedCapabilitiesMigration(), new JetspeedStatisticsMigration(), new JetspeedDBPageManagerMigration(), new JetspeedProfilerMigration(), new JetspeedRegistryMigration(), new JetspeedSecurityMigration(), new JetspeedSSOSecurityMigration()};
    }

    private String validateJDBCUrlOptions(String jdbcUrl, String jdbcDriverClass) {
        if (jdbcUrl != null && jdbcDriverClass != null && jdbcUrl.startsWith("jdbc:mysql://") && jdbcDriverClass.startsWith("com.mysql.jdbc.") && !jdbcUrl.contains("useCursorFetch=")) {
            jdbcUrl = jdbcUrl + (jdbcUrl.contains("?") ? "&" : "?") + "useCursorFetch=true";
        }
        return jdbcUrl;
    }

    public void run() throws IOException, SQLException {
        this.rowsCheckpointCommitted = 0;
        this.rowsMigrated = 0;
        Connection targetConnection = null;
        Connection targetTxnConnection = null;
        Connection sourceConnection = null;
        switch (this.migrationPhase) {
            case 0: 
            case 1: 
            case 3: {
                this.targetDataSourceFactory.start();
                DataSource targetDataSource = this.targetDataSourceFactory.getDatasource();
                targetConnection = targetDataSource.getConnection();
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 2: {
                this.targetTxnDataSourceFactory.start();
                DataSource targetTxnDataSource = this.targetTxnDataSourceFactory.getDatasource();
                targetTxnConnection = targetTxnDataSource.getConnection();
                this.sourceDataSourceFactory.start();
                DataSource sourceDataSource = this.sourceDataSourceFactory.getDatasource();
                sourceConnection = sourceDataSource.getConnection();
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 1: {
                log.info("Clean target database...");
                this.executeSQLScript(targetConnection, this.dropSchemaSQLScriptFile, true);
                log.info("Initialize target database schema tables and indices...");
                this.executeSQLScript(targetConnection, this.createSchemaSQLScriptFile, false, "^\\s*create\\s+(?:table|index|unique\\s+index)\\s", true);
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 2: {
                int sourceVersion = 0;
                for (JetspeedMigration migration : this.migrations) {
                    sourceVersion = migration.detectSourceVersion(sourceConnection, sourceVersion);
                }
                for (JetspeedMigration migration : this.migrations) {
                    sourceVersion = migration.detectSourceVersion(sourceConnection, sourceVersion);
                }
                log.info("Detected source schema version: " + sourceVersion);
                JetspeedMigrationListener migrationListener = new JetspeedMigrationListener(){

                    public void rowMigrated(Connection targetTxnConnection) throws SQLException {
                        JetspeedMigrationApplication.this.rowsMigrated++;
                        if (JetspeedMigrationApplication.this.rowsMigrated > JetspeedMigrationApplication.this.rowsCheckpointCommitted && JetspeedMigrationApplication.this.rowsMigratedPerCommit > 0 && JetspeedMigrationApplication.this.rowsMigrated - JetspeedMigrationApplication.this.rowsCheckpointCommitted >= JetspeedMigrationApplication.this.rowsMigratedPerCommit) {
                            targetTxnConnection.commit();
                            JetspeedMigrationApplication.this.rowsCheckpointCommitted = JetspeedMigrationApplication.this.rowsMigrated;
                            log.info("Checkpoint commit of " + JetspeedMigrationApplication.this.rowsCheckpointCommitted + " total data rows.");
                        }
                    }

                    public void rowDropped(Connection targetTxnConnection) {
                    }
                };
                for (JetspeedMigration migration : this.migrations) {
                    log.info("Migrating " + migration.getName() + " data...");
                    JetspeedMigrationResult result = migration.migrate(sourceConnection, sourceVersion, targetTxnConnection, migrationListener);
                    if (result.getDroppedRows() == 0) {
                        log.info("Migrated " + result.getMigratedRows() + " " + migration.getName() + " data rows.");
                    } else {
                        log.info("Migrated " + result.getMigratedRows() + " " + migration.getName() + " data rows, (" + result.getDroppedRows() + " dropped).");
                    }
                    if (this.rowsMigrated <= this.rowsCheckpointCommitted) continue;
                    targetTxnConnection.commit();
                    this.rowsCheckpointCommitted = this.rowsMigrated;
                    log.info("Checkpoint commit of " + this.rowsCheckpointCommitted + " total data rows.");
                }
                break;
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 3: {
                log.info("Setup target database schema constraints...");
                this.executeSQLScript(targetConnection, this.createSchemaSQLScriptFile, false, "^\\s*create\\s+(?:table|index|unique\\s+index)\\s", false);
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 2: {
                sourceConnection.close();
                this.sourceDataSourceFactory.stop();
                targetTxnConnection.commit();
                targetTxnConnection.close();
                this.targetTxnDataSourceFactory.stop();
            }
        }
        switch (this.migrationPhase) {
            case 0: 
            case 1: 
            case 3: {
                targetConnection.close();
                this.targetDataSourceFactory.stop();
            }
        }
    }

    private void executeSQLScript(Connection connection, File sqlScriptFile, boolean ignoreSQLErrors) throws IOException, SQLException {
        this.executeSQLScript(connection, sqlScriptFile, ignoreSQLErrors, null, true);
    }

    private void executeSQLScript(Connection connection, File sqlScriptFile, boolean ignoreSQLErrors, String statementsRegexp, boolean include) throws IOException, SQLException {
        String scriptStatement;
        Pattern statementsPattern = statementsRegexp != null ? Pattern.compile(statementsRegexp, 2) : null;
        SQLScriptReader reader = new SQLScriptReader(sqlScriptFile);
        while ((scriptStatement = reader.readSQLStatement()) != null) {
            if (statementsPattern != null && statementsPattern.matcher(scriptStatement).find() != include) continue;
            Statement statement = connection.createStatement();
            if (ignoreSQLErrors) {
                try {
                    statement.execute(scriptStatement);
                }
                catch (SQLException sqle) {}
                continue;
            }
            statement.execute(scriptStatement);
        }
    }

    public static void main(String[] args) {
        try {
            JetspeedMigrationApplication application = new JetspeedMigrationApplication(args);
            application.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.error("Unexpected exception: " + e, (Throwable)e);
            System.exit(-1);
        }
    }
}

