/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ReloadablePropertyResourceBundle
extends ResourceBundle {
    protected PropertyResourceBundle internalBundle;
    protected String baseName;
    protected Properties overridingProps;

    public ReloadablePropertyResourceBundle(PropertyResourceBundle internalBundle, String baseName) {
        this.internalBundle = internalBundle;
        this.setParent(internalBundle);
        this.baseName = baseName;
    }

    public void reload(ClassLoader loader) throws IOException {
        String bundleName = this.baseName;
        Locale locale = this.getLocale();
        if (locale != null) {
            String localeSuffix = locale.toString();
            if (localeSuffix.length() > 0) {
                bundleName = bundleName + "_" + localeSuffix;
            } else if (locale.getVariant().length() > 0) {
                bundleName = bundleName + "___" + locale.getVariant();
            }
        }
        String resPath = bundleName.replace('.', '/') + ".properties";
        Properties props = new Properties();
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            URL url = loader.getResource(resPath);
            is = "file".equals(url.getProtocol()) ? new FileInputStream(new File(url.toURI())) : url.openStream();
            bis = new BufferedInputStream(is);
            props.load(bis);
            if (!props.isEmpty()) {
                this.overridingProps = props;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ignore) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public void reset() {
        this.overridingProps = null;
    }

    @Override
    public Locale getLocale() {
        return this.internalBundle.getLocale();
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.overridingProps != null) {
            return new TypedEnumeration<String>(this.overridingProps.keys());
        }
        return this.internalBundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.overridingProps != null) {
            return this.overridingProps.getProperty(key);
        }
        return null;
    }

    private class TypedEnumeration<T>
    implements Enumeration<T> {
        private Enumeration<Object> internalEnum;

        private TypedEnumeration(Enumeration<Object> internalEnum) {
            this.internalEnum = internalEnum;
        }

        @Override
        public boolean hasMoreElements() {
            return this.internalEnum.hasMoreElements();
        }

        @Override
        public T nextElement() {
            return (T)this.internalEnum.nextElement();
        }
    }
}

